#!/usr/bin/env ruby
require 'gpgme'

ctx = GPGME::GpgmeCtx.new
ctx.armor = true
ctx.set_passphrase_cb(proc {|h,d,r| if d; 'test'; end})

plain = GPGME::GpgmeData.new
plain.write('test test test')
puts("Plaintext:\n#{plain.read}")
plain.rewind

# Perform symmetric encryption on PLAIN.
cipher = ctx.encrypt(nil, plain)
puts("Ciphertext:\n#{cipher.read}")
cipher.rewind

plain = ctx.decrypt(cipher)
puts("Plaintext:\n#{plain.read}")
