/* testhashset.c generated by valac, the Vala compiler
 * generated from testhashset.vala, do not modify */

/* testhashset.vala
 *
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_SET_TESTS (set_tests_get_type ())
#define SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SET_TESTS, SetTests))
#define SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SET_TESTS, SetTestsClass))
#define IS_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SET_TESTS))
#define IS_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SET_TESTS))
#define SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SET_TESTS, SetTestsClass))

typedef struct _SetTests SetTests;
typedef struct _SetTestsClass SetTestsClass;
typedef struct _SetTestsPrivate SetTestsPrivate;

#define TYPE_HASH_SET_TESTS (hash_set_tests_get_type ())
#define HASH_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_SET_TESTS, HashSetTests))
#define HASH_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_SET_TESTS, HashSetTestsClass))
#define IS_HASH_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_SET_TESTS))
#define IS_HASH_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_SET_TESTS))
#define HASH_SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_SET_TESTS, HashSetTestsClass))

typedef struct _HashSetTests HashSetTests;
typedef struct _HashSetTestsClass HashSetTestsClass;
typedef struct _HashSetTestsPrivate HashSetTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _SetTests {
	CollectionTests parent_instance;
	SetTestsPrivate * priv;
};

struct _SetTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_ignored) (SetTests* self);
};

struct _HashSetTests {
	SetTests parent_instance;
	HashSetTestsPrivate * priv;
};

struct _HashSetTestsClass {
	SetTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer hash_set_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType set_tests_get_type (void) G_GNUC_CONST;
GType hash_set_tests_get_type (void) G_GNUC_CONST;
enum  {
	HASH_SET_TESTS_DUMMY_PROPERTY
};
SetTests* set_tests_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void hash_set_tests_test_selected_functions (HashSetTests* self);
static void _hash_set_tests_test_selected_functions_gee_test_case_test_method (gpointer self);
void hash_set_tests_test_gobject_properties (HashSetTests* self);
static void _hash_set_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
HashSetTests* hash_set_tests_new (void);
HashSetTests* hash_set_tests_construct (GType object_type);
static void hash_set_tests_real_set_up (GeeTestCase* base);
static void hash_set_tests_real_tear_down (GeeTestCase* base);



static void _hash_set_tests_test_selected_functions_gee_test_case_test_method (gpointer self) {
	hash_set_tests_test_selected_functions (self);
}


static void _hash_set_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	hash_set_tests_test_gobject_properties (self);
}


HashSetTests* hash_set_tests_construct (GType object_type) {
	HashSetTests * self;
	self = (HashSetTests*) set_tests_construct (object_type, "HashSet");
	gee_test_case_add_test ((GeeTestCase*) self, "[HashSet] selected functions", _hash_set_tests_test_selected_functions_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[HashSet] GObject properties", _hash_set_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


HashSetTests* hash_set_tests_new (void) {
	return hash_set_tests_construct (TYPE_HASH_SET_TESTS);
}


static void hash_set_tests_real_set_up (GeeTestCase* base) {
	HashSetTests * self;
	GeeCollection* _tmp0_;
	self = (HashSetTests*) base;
	((CollectionTests*) self)->test_collection = (_tmp0_ = (GeeCollection*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (((CollectionTests*) self)->test_collection), _tmp0_);
}


static void hash_set_tests_real_tear_down (GeeTestCase* base) {
	HashSetTests * self;
	GeeCollection* _tmp0_;
	self = (HashSetTests*) base;
	((CollectionTests*) self)->test_collection = (_tmp0_ = NULL, _g_object_unref0 (((CollectionTests*) self)->test_collection), _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void hash_set_tests_test_selected_functions (HashSetTests* self) {
	GeeCollection* _tmp0_;
	GeeHashSet* test_set;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_HASH_SET (_tmp0_) ? ((GeeHashSet*) _tmp0_) : NULL));
	g_assert (test_set != NULL);
	g_assert (gee_hash_set_get_hash_func (test_set) == g_str_hash);
	g_assert (gee_hash_set_get_equal_func (test_set) == g_str_equal);
	_g_object_unref0 (test_set);
}


void hash_set_tests_test_gobject_properties (HashSetTests* self) {
	GeeCollection* _tmp0_;
	GeeHashSet* test_set;
	GValue value = {0};
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	GValue _tmp4_;
	GValue _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_HASH_SET (_tmp0_) ? ((GeeHashSet*) _tmp0_) : NULL));
	g_assert (test_set != NULL);
	value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_POINTER), _tmp1_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp2_);
	g_object_get_property ((GObject*) test_set, "hash-func", &value);
	g_assert (g_value_get_pointer (&value) == ((void*) gee_hash_set_get_hash_func (test_set)));
	g_value_unset (&value);
	value = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_POINTER), _tmp3_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp4_);
	g_object_get_property ((GObject*) test_set, "equal-func", &value);
	g_assert (g_value_get_pointer (&value) == ((void*) gee_hash_set_get_equal_func (test_set)));
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_object_unref0 (test_set);
}


static void hash_set_tests_class_init (HashSetTestsClass * klass) {
	hash_set_tests_parent_class = g_type_class_peek_parent (klass);
	GEE_TEST_CASE_CLASS (klass)->set_up = hash_set_tests_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = hash_set_tests_real_tear_down;
}


static void hash_set_tests_instance_init (HashSetTests * self) {
}


GType hash_set_tests_get_type (void) {
	static volatile gsize hash_set_tests_type_id__volatile = 0;
	if (g_once_init_enter (&hash_set_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HashSetTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hash_set_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HashSetTests), 0, (GInstanceInitFunc) hash_set_tests_instance_init, NULL };
		GType hash_set_tests_type_id;
		hash_set_tests_type_id = g_type_register_static (TYPE_SET_TESTS, "HashSetTests", &g_define_type_info, 0);
		g_once_init_leave (&hash_set_tests_type_id__volatile, hash_set_tests_type_id);
	}
	return hash_set_tests_type_id__volatile;
}




