#line 24 "../noweb/f_basic.nw"
/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/f_basic.nw"
/* DO NOT read or edit this file ! Use ../noweb/f_basic.nw instead */

#line 47 "../noweb/f_basic.nw"
#include <config.h>

#include <stdio.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <sys/param.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <libguile.h>

#include "defines.h"
#include "struct.h"
#include "globals.h"

#include "../include/prototype.h"

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>
#endif

#line 85 "../noweb/f_basic.nw"
int f_open(TOPLEVEL * w_current, char *filename)
{
  int opened = FALSE;
  char *full_filename = NULL;
  char *full_rcfilename = NULL;
  char *file_directory = NULL;
  char *saved_cwd = NULL;

  /* has the head been freed yet? */
  /* probably not hack PAGE */

  set_window(w_current, w_current->page_current,
	     w_current->init_left, w_current->init_right,
	     w_current->init_top, w_current->init_bottom);


  /* 
   * If we are only opening a preview window, we don't want to 
   * change the directory. Therefore, if this is only a preview window, 
   * we cache the cwd so we can restore it later.
   */
  if (w_current->wid == -1) {
    saved_cwd = getcwd(NULL, 1024);
  }

  /* get full, absolute path to file */
  full_filename = f_normalize_filename(filename);

  /* write full, absolute filename into page_current->page_filename */
  if (w_current->page_current->page_filename) {
    free(w_current->page_current->page_filename);
  }
  w_current->page_current->page_filename = g_strdup(full_filename);

  /* Before we open the page, let's load the corresponding gafrc. */
  /* First cd into file's directory. */
  file_directory = g_dirname(full_filename);

  full_rcfilename = g_strconcat(file_directory,
				G_DIR_SEPARATOR_S, "gafrc", NULL);
  if (file_directory) {
    chdir(file_directory);
    /* Probably should do some checking of chdir return values */
    free(file_directory);
  }
  /* If directory is not found, we should do something . . . . */

  /* Now open RC and process file */
  g_rc_parse_specified_rc(w_current, full_rcfilename);

  /* Now that we have set the current directory and read
   * the RC file, it's time to read in the file. */
  w_current->page_current->object_tail = (OBJECT *)
      o_read(w_current, w_current->page_current->object_tail,
	     full_filename);

  if (w_current->page_current->object_tail != NULL) {
    s_log_message("Opened file [%s]\n", full_filename);
    opened = TRUE;

  } else {
    /* Failed to open page */
    opened = FALSE;
  }


  w_current->page_current->object_tail = (OBJECT *)
      return_tail(w_current->page_current->object_head);

  /* make sure you init net_consolide to false (default) in all */
  /* programs */
  if (w_current->net_consolidate == TRUE) {
    o_net_consolidate(w_current);
  }

  w_current->page_current->CHANGED = 0;	/* added 4/7/98 */

  free(full_filename);
  free(full_rcfilename);

  /* If this was a preview window, reset the directory to the 
   * value it had when f_open was called.  Also get rid of component
   * libraries opened while opening preview window.  If the component
   * is actually selected, they will be re-read later. */
  if (w_current->wid == -1) {
    chdir(saved_cwd);
    free(saved_cwd);
  }

  if (!opened) {
    return (FALSE);
  } else {
    return (TRUE);
  }
}

#line 194 "../noweb/f_basic.nw"
void f_close(TOPLEVEL * w_current)
{

}

#line 209 "../noweb/f_basic.nw"
void f_save_close(TOPLEVEL * w_current, char *filename)
{
  o_save(w_current, filename);
  s_page_delete(w_current, w_current->page_current);
}

#line 225 "../noweb/f_basic.nw"
int f_save(TOPLEVEL * w_current, const char *filename)
{
  return o_save(w_current, filename);
}

#line 242 "../noweb/f_basic.nw"
char *f_normalize_filename(const gchar * filename)
{
  char filename_buffer[MAXPATHLEN];	/* nasty hack for realpath */
  char *full_filename;

  /*  Check for pathological case  */
  if (filename == NULL) {
    return NULL;
  }

  realpath(filename, filename_buffer);	/* places reult in filename_buffer */
  full_filename = g_strdup(filename_buffer);

#ifdef DEBUG
  printf("In f_normalize_filename, returning full_filename= %s \n",
	 full_filename);
#endif

  return full_filename;

}
