#include <apt-pkg/init.h>
#include <ept/config.h>
#include <ept/init.h>

namespace ept {

Init::FunctionDeque *Init::s_functions = 0;
bool Init::s_done = false;
bool Init::s_globalDone = false;

void init() {
    Init::FunctionDeque::iterator i;
    for (i = Init::s_functions->begin();
         i != Init::s_functions->end();
         ++ i) {
        (*i)();
    }
    Init::s_done = true;
};

namespace {
void globalinit() {
    if (! Init::s_globalDone) {
        pkgInitConfig(*_config);
        pkgInitSystem(*_config, _system);
    }
    Init::s_globalDone = true;
}
Init global( globalinit );
}

}

