/** -*- C++ -*-
    @file ept/configuration/apt.h
    @author Peter Rockai <me@mornfall.net>
*/

#ifndef EPT_CONFIGURATION_APT_H
#define EPT_CONFIGURATION_APT_H

#include <ept/cache/apt/index.h>

namespace ept {
namespace configuration {

struct Apt {
    typedef t::Manager< Apt > Manager;
    typedef t::cache::apt::Aggregator< Apt > Aggregator;
    typedef t::cache::apt::Index< Apt > Index;
    typedef t::cache::apt::State< Apt > State;
    typedef t::cache::apt::Records< Apt > Records;
    typedef t::cache::Package< Apt > Package;
    typedef t::cache::PackageEditor< Apt, Package > PackageEditor;
    typedef t::cache::Version< Apt > Version;
    typedef t::cache::Relation< Apt > Relation;
    typedef t::cache::debtags::Vocabulary< Apt > Vocabulary;
    typedef t::cache::debtags::TagMap< Apt > TagMap;
    typedef t::cache::debtags::PkgIdx< Apt > PkgIdx;
    typedef t::cache::debtags::Utils< Apt > DebtagsUtils;
    typedef t::cache::Tag< Apt > Tag;
    typedef t::cache::Facet< Apt > Facet;
    typedef Index::PackagePointer PackagePointer;
    typedef Index::VersionPointer VersionPointer;
    typedef Index::RelationPointer RelationPointer;
};

namespace apt {

typedef Apt::Manager Manager;

namespace cache {
typedef t::cache::NamedEntity NamedEntity;
typedef t::cache::Entity Entity; // convenience
typedef Apt::Aggregator Aggregator;
typedef Aggregator Packages; // compat

typedef Apt::Index Index;
typedef Apt::Records Records;
typedef Apt::State State;
typedef Apt::Package Package;
typedef Apt::PackageEditor PackageEditor;
typedef Apt::Version Version;
typedef Apt::Relation Relation;
typedef Apt::TagMap TagMap;
typedef Apt::Vocabulary Vocabulary;
typedef Apt::DebtagsUtils DebtagsUtils;
typedef Apt::Tag Tag;
typedef Apt::Facet Facet;

// convenience and swig
typedef wibble::Range< Package > PackageRange;
typedef wibble::Range< Relation > RelationRange;
typedef wibble::Range< Version > VersionRange;
}

namespace act {
typedef actor::Factory< t::cache::PackageEditor< Apt, cache::Package > > Package;
typedef actor::Factory< cache::Entity > Entity;
}

namespace match {
typedef ept::predicate::Factory< cache::Package > Package;
typedef ept::predicate::Factory< cache::Version > Version;
typedef ept::predicate::Factory< cache::Relation > Relation;
}

}
}
}

#endif
