/***************************************************************************
                           cxml.cpp  -  description
                             -------------------
    begin                : Wed May 15 2002
    copyright            : (C) 2002-2005 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define __STDC_ISO_10646__  200104L
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#include <dclib/core/ciconv.h>

#include "cxml.h"

/** */
CXml::CXml()
{
	int i;
	
	pDoc = 0;

	if ( xmlParserVersion != CString("20510") )
	{
		xmlInitParser();
	}
	
	m_sLocaleEnc = getenv("LANG");
	i = m_sLocaleEnc.Find('.');
	if ( i == -1 )
	{
#ifdef __APPLE__
		m_sLocaleEnc = "UTF-8";
#else
		m_sLocaleEnc = "";
#endif
	}
	else
	{
		m_sLocaleEnc = m_sLocaleEnc.Mid(i + 1);
	}
}

/** */
CXml::~CXml()
{
	FreeDoc();

#if LIBXML_VERSION > 20510
	if ( xmlParserVersion != CString("20510") )
	{
		xmlCleanupParser();
	}
#endif
}

/** */
void CXml::FreeDoc()
{
	if (pDoc)
	{
		xmlFreeDoc(pDoc);
		pDoc = 0;
	}
}

/** */
bool CXml::NewDoc()
{
	FreeDoc();

	if ( (pDoc = xmlNewDoc((const xmlChar*)"1.0")) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
bool CXml::ParseFile( CString name )
{
	FreeDoc();

	if ( (pDoc = xmlRecoverFile(name.Data())) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
bool CXml::ParseMemory( const char * s, int size )
{
	FreeDoc();

	if ( (pDoc = xmlRecoverMemory(s,size)) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
CString CXml::content( xmlNodePtr node )
{
	xmlChar *c;
	CString s = "";

	if ( (c = xmlNodeGetContent(node)) != 0 )
	{
		s = FromUtf8((char*)c);
		xmlFree(c);
	}

	return s;
}

/** */
CString CXml::prop( xmlNodePtr node, CString prop )
{
	xmlChar *c;
	CString s = "";

	if ( (c = xmlGetProp(node,(const xmlChar*)prop.Data())) != 0 )
	{
		s = (char*)c;
		xmlFree(c);
	}

	return s;
}

/** */
CString CXml::xml_UTF8ToOutput( char * s, int len, CString to_codec )
{
	CString r = "";
	unsigned char *b;
	int inlen,outlen,res;
	CString codecname = "";
	CIconv * ciconv = 0;

	if ( (s == 0) || (len <= 0) )
	{
		return "";
	}

	if (to_codec == "")
	{
		codecname = m_sLocaleEnc;
	}
	else
	{
		codecname = to_codec;
	}

	if ( codecname == "" )
	{
		inlen  = len;
		outlen = inlen*4;

		b = (unsigned char*) calloc(1,outlen);

		if ( b == 0 )
			return r;
	
		//printf("Warning: LANG does not specify codec or codec not found, using ISO-8859-1\n");
		res = UTF8Toisolat1( b, &outlen, (unsigned char*)s, &inlen );
		
		if ( res == -2 )
			printf("CXml::xml_UTF8ToOutput transcoding fail: '%s'\n",s);
		else if ( res == -1 )
			printf("CXml::xml_UTF8ToOutput fail: '%s'\n",s);
		else if ( res >= 0 )
			r = (char*)b;
		else
			printf("CXml::xml_UTF8ToOutput error %d\n",res);

		free(b);
	}
	else
	{
		ciconv = new CIconv( "UTF-8", codecname );
		r = ciconv->encode(s);
		delete ciconv;
	}

	return r;
}

/** */
CString CXml::xml_InputToUTF8( char * s, int len, CString from_codec )
{
	CString r = "";
	unsigned char *b;
	int inlen,outlen,res;
	CString codecname = "";
	CIconv * ciconv = 0;

	if ( (s == 0) || (len <= 0) )
	{
		return "";
	}

	if (from_codec == "")
	{
		codecname = m_sLocaleEnc;
	}
	else
	{
		codecname = from_codec;
	}

	if ( codecname == "" )
	{
		// this code is copied and pasted below after xmlCheckUTF8
		
		inlen  = len;
		outlen = inlen*4;

		b = (unsigned char*) calloc(1,outlen);

		if ( b == 0 )
			return r;
		
		//printf("Warning: LANG does not specify codec or codec not found, using ISO-8859-1\n");
		res = isolat1ToUTF8( b, &outlen, (unsigned char*)s, &inlen );
		
		if ( res >= 0 )
			r = (char*)b;
		else
			printf("CXml::xml_InputToUTF8 fail: '%s'\n",s);

		free(b);
	}
	else
	{
		ciconv = new CIconv( codecname, "UTF-8" );
		r = ciconv->encode(s);
		delete ciconv;
		
		if ( xmlCheckUTF8( (const unsigned char*) r.Data() ) == FALSE )
		{
			printf("CXml::xml_InputToUTF8 warning: iconv returned invalid utf-8\n");
			printf("CXml::xml_InputToUTF8 warning: assuming input is ISO-8859-1\n");
			
			// this is copied and pasted from above
			
			inlen = len;
			outlen = inlen * 4;
			
			b = (unsigned char*) calloc(1,outlen);
			
			if ( b == 0 )
				return r;
			
			res = isolat1ToUTF8( b, &outlen, (unsigned char*)s, &inlen );
			
			if ( res >= 0 )
				r = (char*)b;
			else
				printf("CXml::xml_InputToUTF8 fail: '%s'\n",s);
			
			free(b);
			
			// end of copied and pasted code
		}
	}

	return r;
}

/** */
CString CXml::ToUTF8( const char * s, CString from_codec, bool nosub )
{
	CString str = s;

	return ToUTF8(str, from_codec, nosub);
}

/** */
CString CXml::FromUtf8( const char * s, CString to_codec, bool nosub )
{
	CString str = s;

	return FromUtf8(str, to_codec, nosub);
}

/** */
CString CXml::ToUTF8( CString & s, CString from_codec, bool nosub )
{
	int i;
	CString dst = "",dst1;

	if ( s == "" )
		return dst;

	dst = xml_InputToUTF8( s.Data(), s.Length(), from_codec );
	
	if ( nosub == TRUE )
	{
		return dst;
	}
	
	dst = dst.Replace("&","&amp;");
	dst = dst.Replace("\'","&apos;");
	dst = dst.Replace("\"","&quot;");
	dst = dst.Replace("<","&lt;");
	dst = dst.Replace(">","&gt;");

	/* 0x00 - 0x08, 0x0B, 0x0C, 0x0E - 0x1F have been declared to
	 * be illegal in XML documents
	*/
	for(i=0;i<dst.Length();i++)
	{
		int x = dst.Data()[i]&0xff;
		
		if ( ((x <= 0x08) && (x >= 0x00)) ||
		     (x == 0x0B) ||
		     (x <= 0x0C) ||
		     ((x <= 0x1F) && (x >= 0x0E)) )
		{
			dst1 += "&#0" + CString().setNum(x) + ";";
		}
		else
		{
			dst1 += dst.Data()[i];
		}
	}

	return dst1;
}

/** */
CString CXml::FromUtf8( CString & s, CString to_codec, bool nosub )
{
	int i,i1;
	CString c = "",c1 = "";
	CString t;

	if ( s != "" )
	{
		c = xml_UTF8ToOutput( s.Data(), s.Length(), to_codec );
	}
	
	if ( nosub == TRUE )
	{
		return c;
	}

	for(i=0;i<c.Length();i++)
	{
		if ( c.Data()[i] == '&' )
		{
			if ( c.Mid(i,2) == "&#" )
			{
				if ( (i1 = c.Find(';',i)) != -1 )
				{
					if ( (i1-i) <= 5 )
					{
						t = c.Mid(i,i1-i);				
						//printf("%s\n",t.Data());
						
						t = t.Mid(2);
						
						if ( t.Left(1) == "x" )
						{
							t = t.Mid(1);
							
							c1 += t.asINT(16);
						}
						else
						{
							c1 += t.asINT();
						}
						
						//printf("%s\n",t.Data());
						i += i1-i;
						continue;
					}
				}
			}
		}
		
		c1 += c.Data()[i];
	}

	c1 = c1.Replace("&apos;", "\'");
	c1 = c1.Replace("&quot;", "\"");
	c1 = c1.Replace("&lt;",   "<");
	c1 = c1.Replace("&gt;",   ">");
	c1 = c1.Replace("&amp;",  "&");

	return c1;
}
	
/** */
xmlNodePtr CXml::xmlNewBoolChild( xmlNodePtr parent, xmlNsPtr ns, const xmlChar *name, bool b )
{
	CString s;
	
	if (b)
		s = XML_TRUE;
	else
		s = XML_FALSE;

	return xmlNewChild( parent, ns, name, (const xmlChar*)(const char*)s.Data() );
}

/** */
xmlNodePtr CXml::xmlNewStringChild( xmlNodePtr parent, xmlNsPtr ns, const xmlChar *name, CString s, bool createempty )
{
	if ( (createempty==TRUE) || (s!="") )
		return xmlNewTextChild( parent, ns, name, (const xmlChar*)ToUTF8(s).Data() );
	else
		return 0;
}

/** */
void CXml::xmlNewStringProp( xmlNodePtr node, CString prop, CString value )
{
	xmlNewProp( node, (const xmlChar*)prop.Data(), (const xmlChar*)ToUTF8(value).Data() );
}

/** */
bool CXml::getBoolChild( xmlNodePtr node )
{
	if ( content(node) == XML_TRUE )
		return TRUE;
	else
		return FALSE;
}
