/***************************************************************************
                          track.cpp  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001 by root
    email                : root@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusic.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"
/** Adds a track to the dataabse.
 *
 *@param QString CD ID
 *@param TrackInfo Pointer to TrackInfo struct containing track description.
 */
int dbMusic::addTrack(const QString &cdid, TrackInfo *const track)
{
	if (cdid.isEmpty())
		return TRACK_ADD_FAIL;
	if (cdid=="0")
	{
		cerr << "addTrack: cdid is 0." << endl;
		return TRACK_ADD_FAIL;
	}
	// inserts a specific track into track table.
	sqlstring="INSERT INTO track (cdid, name, length) VALUES (";
	sqlstring.append(validateNumQString(cdid));
	sqlstring.append(", '");
	sqlstring.append(validateQString(track->name));
	sqlstring.append("', '");
	sqlstring.append(validateInterval(track->length));
	sqlstring.append("')");
	cerr << "addTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TRACK_ADD_FAIL;

	int s=updateTime(cdid);
	if (s<0)
		return TITLE_UPDATE_FAIL;

	sqlstring="UPDATE title SET notracks=notracks+1 WHERE cdid=";
	sqlstring.append(cdid);
	cerr << "updateTitleNoTracks: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TITLE_UPDATE_FAIL;

	sqlstring="SELECT trackid FROM track WHERE cdid=";
	sqlstring.append(cdid);
	sqlstring.append(" AND name='");
	sqlstring.append(validateQString(track->name));
	sqlstring.append("' AND length='");
	sqlstring.append(validateInterval(track->length));
	sqlstring.append("'");
	cerr << "getTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TRACK_GET_FAIL;

	track->trackid=GetValue(0,0);


	return EVERYTHING_OK;
}
/** Deletes a track from the databse.
 *
 *@param QString Track ID
 *@param QString CD ID
 */
int dbMusic::deleteTrack(const QString &trackid, const QString &cdid)
{
	if (trackid.isEmpty())
		return TRACK_DELETE_FAIL;
	if (cdid.isEmpty())
		return TRACK_DELETE_FAIL;
	// deletes a specific track from track table.
	sqlstring="DELETE FROM track WHERE trackid=";
	sqlstring.append(validateNumQString(trackid));
	cerr << "deleteTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TRACK_DELETE_FAIL;

	// now update the time
	int s=updateTime(cdid);
	if (s<0)
		return TITLE_UPDATE_FAIL;

	sqlstring="UPDATE title SET notracks=notracks-1 WHERE cdid=";
	sqlstring.append(validateNumQString(cdid));
	cerr << "updateTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TITLE_UPDATE_FAIL;

	return EVERYTHING_OK;
}
/** Moves a track down one number for a specific title.
 *
 *@param TrackInfo top track
 *@param TrackInfo bottom track
 */
int dbMusic::trackDown(const TrackInfo *t, const TrackInfo *b)
{
	if (t->name.isEmpty())
		return TRACK_UPDATE_FAIL;
	if (b->name.isEmpty())
		return TRACK_UPDATE_FAIL;
	sqlstring="UPDATE track SET name='";
	sqlstring.append(validateQString(t->name));
	sqlstring.append("', length='");
	sqlstring.append(validateInterval(t->length));
	sqlstring.append("' WHERE trackid=");
	sqlstring.append(validateNumQString(b->trackid));
	cerr << "updateTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck()<0)
		return TRACK_GET_FAIL;

	sqlstring="UPDATE track SET name='";
	sqlstring.append(validateQString(b->name));
	sqlstring.append("', length='");
	sqlstring.append(validateInterval(b->length));
	sqlstring.append("' WHERE trackid=");
	sqlstring.append(validateNumQString(t->trackid));
	cerr << "updateTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck()<0)
		return TRACK_GET_FAIL;

	return EVERYTHING_OK;

}
/** Moves a track up one number for a specific title.
 *
 *@param TrackInfo top track
 *@param TrackInfo bottom track
 */
int dbMusic::trackUp(const TrackInfo *t, const TrackInfo *b)
{
	if (t->name.isEmpty())
		return TRACK_UPDATE_FAIL;
	if (b->name.isEmpty())
		return TRACK_UPDATE_FAIL;
	sqlstring="UPDATE track SET name='";
	sqlstring.append(validateQString(t->name));
	sqlstring.append("', length='");
	sqlstring.append(validateInterval(t->length));
	sqlstring.append("' WHERE trackid=");
	sqlstring.append(validateNumQString(b->trackid));
	cerr << "updateTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return TRACK_GET_FAIL;

	sqlstring="UPDATE track SET name='";
	sqlstring.append(validateQString(b->name));
	sqlstring.append("', length='");
	sqlstring.append(validateInterval(b->length));
	sqlstring.append("' WHERE trackid=");
	sqlstring.append(validateNumQString(t->trackid));
	cerr << "updateTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return TRACK_GET_FAIL;

	return EVERYTHING_OK;

}
/** Updates a specific track.
 *
 *@param TrackInfo Pointer to TrackInfo struct containing track ID to update as well as the updated information.
 */
int dbMusic::updateTrack(const TrackInfo *const newt)
{
	sqlstring="UPDATE track SET name='";
	sqlstring.append(validateQString(newt->name));
	sqlstring.append("', length='");
	sqlstring.append(validateInterval(newt->length));
	sqlstring.append("' WHERE trackid=");
	sqlstring.append(validateNumQString(newt->trackid));
	cerr << "updateTrack: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TRACK_UPDATE_FAIL;

	sqlstring="SELECT cdid FROM track WHERE trackid=";
	sqlstring.append(validateNumQString(newt->trackid));
	cerr << "getTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return TRACK_GET_FAIL;
	int s=updateTime(GetValue(0,0));
	if (s<0)
		return TITLE_UPDATE_FAIL;


	return EVERYTHING_OK;
}
