package DateTime::LocaleCatalog;

use strict;

BEGIN
{
    return unless $] >= 5.006;

    require utf8; import utf8;
}

@DateTime::Locale::Locales = (
    { id => "af",
      en_language => "Afrikaans",
      native_language => "Afrikaans",
    },
    { id => "af_ZA",
      en_language => "Afrikaans",
      en_territory => "South\ Africa",
      native_language => "Afrikaans",
      native_territory => "South\ Africa",
    },
    { id => "am",
      en_language => "Amharic",
      native_language => "አማርኛ",
    },
    { id => "am_ET",
      en_language => "Amharic",
      en_territory => "Ethiopia",
      native_language => "አማርኛ",
      native_territory => "ኢትዮጵያ",
    },
    { id => "ar",
      en_language => "Arabic",
      native_language => "العربية",
    },
    { id => "ar_AE",
      en_language => "Arabic",
      en_territory => "United\ Arab\ Emirates",
      native_language => "العربية",
      native_territory => "الإمارات",
      real_class => "ar",
    },
    { id => "ar_BH",
      en_language => "Arabic",
      en_territory => "Bahrain",
      native_language => "العربية",
      native_territory => "البحرين",
      real_class => "ar",
    },
    { id => "ar_DZ",
      en_language => "Arabic",
      en_territory => "Algeria",
      native_language => "العربية",
      native_territory => "الجزائر",
      real_class => "ar",
    },
    { id => "ar_EG",
      en_language => "Arabic",
      en_territory => "Egypt",
      native_language => "العربية",
      native_territory => "مصر",
      real_class => "ar",
    },
    { id => "ar_IN",
      en_language => "Arabic",
      en_territory => "India",
      native_language => "العربية",
      native_territory => "الهند",
    },
    { id => "ar_IQ",
      en_language => "Arabic",
      en_territory => "Iraq",
      native_language => "العربية",
      native_territory => "العراق",
      real_class => "ar",
    },
    { id => "ar_JO",
      en_language => "Arabic",
      en_territory => "Jordan",
      native_language => "العربية",
      native_territory => "الأردن",
    },
    { id => "ar_KW",
      en_language => "Arabic",
      en_territory => "Kuwait",
      native_language => "العربية",
      native_territory => "الكويت",
      real_class => "ar",
    },
    { id => "ar_LB",
      en_language => "Arabic",
      en_territory => "Lebanon",
      native_language => "العربية",
      native_territory => "لبنان",
    },
    { id => "ar_LY",
      en_language => "Arabic",
      en_territory => "Libya",
      native_language => "العربية",
      native_territory => "ليبيا",
      real_class => "ar",
    },
    { id => "ar_MA",
      en_language => "Arabic",
      en_territory => "Morocco",
      native_language => "العربية",
      native_territory => "المغرب",
      real_class => "ar",
    },
    { id => "ar_OM",
      en_language => "Arabic",
      en_territory => "Oman",
      native_language => "العربية",
      native_territory => "سلطنة\ عمان",
      real_class => "ar",
    },
    { id => "ar_QA",
      en_language => "Arabic",
      en_territory => "Qatar",
      native_language => "العربية",
      native_territory => "قطر",
    },
    { id => "ar_SA",
      en_language => "Arabic",
      en_territory => "Saudi\ Arabia",
      native_language => "العربية",
      native_territory => "السعودية",
    },
    { id => "ar_SD",
      en_language => "Arabic",
      en_territory => "Sudan",
      native_language => "العربية",
      native_territory => "السودان",
      real_class => "ar",
    },
    { id => "ar_SY",
      en_language => "Arabic",
      en_territory => "Syria",
      native_language => "العربية",
      native_territory => "سوريا",
    },
    { id => "ar_TN",
      en_language => "Arabic",
      en_territory => "Tunisia",
      native_language => "العربية",
      native_territory => "تونس",
    },
    { id => "ar_YE",
      en_language => "Arabic",
      en_territory => "Yemen",
      native_language => "العربية",
      native_territory => "اليمن",
    },
    { id => "az",
      en_language => "Azerbaijani",
      native_language => "Азәрбајҹан",
    },
    { id => "az_AZ",
      en_language => "Azerbaijani",
      en_territory => "Azerbaijan",
      native_language => "Азәрбајҹан",
      native_territory => "Azerbaijan",
    },
    { id => "be",
      en_language => "Belarusian",
      native_language => "Беларускі",
    },
    { id => "be_BY",
      en_language => "Belarusian",
      en_territory => "Belarus",
      native_language => "Беларускі",
      native_territory => "Беларусь",
      real_class => "be",
    },
    { id => "bg",
      en_language => "Bulgarian",
      native_language => "български",
    },
    { id => "bg_BG",
      en_language => "Bulgarian",
      en_territory => "Bulgaria",
      native_language => "български",
      native_territory => "България",
      real_class => "bg",
    },
    { id => "bn",
      en_language => "Bengali",
      native_language => "বাংলা",
    },
    { id => "bn_IN",
      en_language => "Bengali",
      en_territory => "India",
      native_language => "বাংলা",
      native_territory => "ভারত",
    },
    { id => "ca",
      en_language => "Catalan",
      native_language => "català",
    },
    { id => "ca_ES",
      en_language => "Catalan",
      en_territory => "Spain",
      native_language => "català",
      native_territory => "Espanya",
      real_class => "ca",
    },
    { id => "ca_ES_PREEURO",
      en_language => "Catalan",
      en_territory => "Spain",
      en_variant => "Preeuro",
      native_language => "català",
      native_territory => "Espanya",
      native_variant => "Preeuro",
      real_class => "ca",
    },
    { id => "cs",
      en_language => "Czech",
      native_language => "čeština",
    },
    { id => "cs_CZ",
      en_language => "Czech",
      en_territory => "Czech\ Republic",
      native_language => "čeština",
      native_territory => "Česká\ republika",
      real_class => "cs",
    },
    { id => "da",
      en_language => "Danish",
      native_language => "dansk",
    },
    { id => "da_DK",
      en_language => "Danish",
      en_territory => "Denmark",
      native_language => "dansk",
      native_territory => "Danmark",
      real_class => "da",
    },
    { id => "de",
      en_language => "German",
      native_language => "Deutsch",
    },
    { id => "de_AT",
      en_language => "German",
      en_territory => "Austria",
      native_language => "Deutsch",
      native_territory => "Österreich",
    },
    { id => "de_AT_PREEURO",
      en_language => "German",
      en_territory => "Austria",
      en_variant => "Preeuro",
      native_language => "Deutsch",
      native_territory => "Österreich",
      native_variant => "Preeuro",
      real_class => "de_AT",
    },
    { id => "de_BE",
      en_language => "German",
      en_territory => "Belgium",
      native_language => "Deutsch",
      native_territory => "Belgien",
    },
    { id => "de_CH",
      en_language => "German",
      en_territory => "Switzerland",
      native_language => "Deutsch",
      native_territory => "Schweiz",
      real_class => "de",
    },
    { id => "de_DE",
      en_language => "German",
      en_territory => "Germany",
      native_language => "Deutsch",
      native_territory => "Deutschland",
      real_class => "de",
    },
    { id => "de_DE_PREEURO",
      en_language => "German",
      en_territory => "Germany",
      en_variant => "Preeuro",
      native_language => "Deutsch",
      native_territory => "Deutschland",
      native_variant => "Preeuro",
      real_class => "de",
    },
    { id => "de_LI",
      en_language => "German",
      en_territory => "Liechtenstein",
      native_language => "Deutsch",
      native_territory => "Liechtenstein",
      real_class => "de",
    },
    { id => "de_LU",
      en_language => "German",
      en_territory => "Luxembourg",
      native_language => "Deutsch",
      native_territory => "Luxemburg",
      real_class => "de",
    },
    { id => "de_LU_PREEURO",
      en_language => "German",
      en_territory => "Luxembourg",
      en_variant => "Preeuro",
      native_language => "Deutsch",
      native_territory => "Luxemburg",
      native_variant => "Preeuro",
      real_class => "de",
    },
    { id => "dv",
      en_language => "Divehi",
      native_language => "ދިވެހިބަސް",
    },
    { id => "dv_MV",
      en_language => "Divehi",
      en_territory => "Maldives",
      native_language => "ދިވެހިބަސް",
      native_territory => "ދިވެހި\ ރާއްޖެ",
    },
    { id => "el",
      en_language => "Greek",
      native_language => "ελληνικά",
    },
    { id => "el_GR",
      en_language => "Greek",
      en_territory => "Greece",
      native_language => "ελληνικά",
      native_territory => "Ελλάδα",
      real_class => "el",
    },
    { id => "el_GR_PREEURO",
      en_language => "Greek",
      en_territory => "Greece",
      en_variant => "Preeuro",
      native_language => "ελληνικά",
      native_territory => "Ελλάδα",
      native_variant => "Preeuro",
      real_class => "el",
    },
    { id => "en",
      en_language => "English",
      native_language => "English",
      real_class => "root",
    },
    { id => "en_AS",
      en_language => "English",
      en_territory => "American\ Samoa",
      native_language => "English",
      native_territory => "American\ Samoa",
      real_class => "root",
    },
    { id => "en_AU",
      en_language => "English",
      en_territory => "Australia",
      native_language => "English",
      native_territory => "Australia",
    },
    { id => "en_BE",
      en_language => "English",
      en_territory => "Belgium",
      native_language => "English",
      native_territory => "Belgium",
    },
    { id => "en_BE_PREEURO",
      en_language => "English",
      en_territory => "Belgium",
      en_variant => "Preeuro",
      native_language => "English",
      native_territory => "Belgium",
      native_variant => "Preeuro",
      real_class => "en_BE",
    },
    { id => "en_BW",
      en_language => "English",
      en_territory => "Botswana",
      native_language => "English",
      native_territory => "Botswana",
    },
    { id => "en_BZ",
      en_language => "English",
      en_territory => "Belize",
      native_language => "English",
      native_territory => "Belize",
    },
    { id => "en_CA",
      en_language => "English",
      en_territory => "Canada",
      native_language => "English",
      native_territory => "Canada",
    },
    { id => "en_GB",
      en_language => "English",
      en_territory => "United\ Kingdom",
      native_language => "English",
      native_territory => "United\ Kingdom",
    },
    { id => "en_GB_EURO",
      en_language => "English",
      en_territory => "United\ Kingdom",
      en_variant => "Euro",
      native_language => "English",
      native_territory => "United\ Kingdom",
      native_variant => "Euro",
      real_class => "en_GB",
    },
    { id => "en_GU",
      en_language => "English",
      en_territory => "Guam",
      native_language => "English",
      native_territory => "Guam",
      real_class => "root",
    },
    { id => "en_HK",
      en_language => "English",
      en_territory => "Hong\ Kong\ S\.A\.R\.\,\ China",
      native_language => "English",
      native_territory => "Hong\ Kong\ S\.A\.R\.\,\ China",
    },
    { id => "en_IE",
      en_language => "English",
      en_territory => "Ireland",
      native_language => "English",
      native_territory => "Ireland",
    },
    { id => "en_IE_PREEURO",
      en_language => "English",
      en_territory => "Ireland",
      en_variant => "Preeuro",
      native_language => "English",
      native_territory => "Ireland",
      native_variant => "Preeuro",
      real_class => "en_IE",
    },
    { id => "en_IN",
      en_language => "English",
      en_territory => "India",
      native_language => "English",
      native_territory => "India",
    },
    { id => "en_JM",
      en_language => "English",
      en_territory => "Jamaica",
      native_language => "English",
      native_territory => "Jamaica",
      real_class => "root",
    },
    { id => "en_MH",
      en_language => "English",
      en_territory => "Marshall\ Islands",
      native_language => "English",
      native_territory => "Marshall\ Islands",
      real_class => "root",
    },
    { id => "en_MP",
      en_language => "English",
      en_territory => "Northern\ Mariana\ Islands",
      native_language => "English",
      native_territory => "Northern\ Mariana\ Islands",
      real_class => "root",
    },
    { id => "en_MT",
      en_language => "English",
      en_territory => "Malta",
      native_language => "English",
      native_territory => "Malta",
    },
    { id => "en_NZ",
      en_language => "English",
      en_territory => "New\ Zealand",
      native_language => "English",
      native_territory => "New\ Zealand",
    },
    { id => "en_PH",
      en_language => "English",
      en_territory => "Philippines",
      native_language => "English",
      native_territory => "Philippines",
    },
    { id => "en_SG",
      en_language => "English",
      en_territory => "Singapore",
      native_language => "English",
      native_territory => "Singapore",
    },
    { id => "en_TT",
      en_language => "English",
      en_territory => "Trinidad\ and\ Tobago",
      native_language => "English",
      native_territory => "Trinidad\ and\ Tobago",
      real_class => "root",
    },
    { id => "en_UM",
      en_language => "English",
      en_territory => "United\ States\ Minor\ Outlying\ Islands",
      native_language => "English",
      native_territory => "United\ States\ Minor\ Outlying\ Islands",
      real_class => "root",
    },
    { id => "en_US",
      en_language => "English",
      en_territory => "United\ States",
      native_language => "English",
      native_territory => "United\ States",
      real_class => "root",
    },
    { id => "en_US_POSIX",
      en_language => "English",
      en_territory => "United\ States",
      en_variant => "Posix",
      native_language => "English",
      native_territory => "United\ States",
      native_variant => "Posix",
      real_class => "root",
    },
    { id => "en_VI",
      en_language => "English",
      en_territory => "U\.S\.\ Virgin\ Islands",
      native_language => "English",
      native_territory => "U\.S\.\ Virgin\ Islands",
      real_class => "root",
    },
    { id => "en_ZA",
      en_language => "English",
      en_territory => "South\ Africa",
      native_language => "English",
      native_territory => "South\ Africa",
    },
    { id => "en_ZW",
      en_language => "English",
      en_territory => "Zimbabwe",
      native_language => "English",
      native_territory => "Zimbabwe",
    },
    { id => "eo",
      en_language => "Esperanto",
      native_language => "esperanto",
    },
    { id => "es",
      en_language => "Spanish",
      native_language => "español",
    },
    { id => "es_AR",
      en_language => "Spanish",
      en_territory => "Argentina",
      native_language => "español",
      native_territory => "Argentina",
    },
    { id => "es_BO",
      en_language => "Spanish",
      en_territory => "Bolivia",
      native_language => "español",
      native_territory => "Bolivia",
    },
    { id => "es_CL",
      en_language => "Spanish",
      en_territory => "Chile",
      native_language => "español",
      native_territory => "Chile",
    },
    { id => "es_CO",
      en_language => "Spanish",
      en_territory => "Colombia",
      native_language => "español",
      native_territory => "Colombia",
    },
    { id => "es_CR",
      en_language => "Spanish",
      en_territory => "Costa\ Rica",
      native_language => "español",
      native_territory => "Costa\ Rica",
    },
    { id => "es_DO",
      en_language => "Spanish",
      en_territory => "Dominican\ Republic",
      native_language => "español",
      native_territory => "República\ Dominicana",
    },
    { id => "es_EC",
      en_language => "Spanish",
      en_territory => "Ecuador",
      native_language => "español",
      native_territory => "Ecuador",
    },
    { id => "es_ES",
      en_language => "Spanish",
      en_territory => "Spain",
      native_language => "español",
      native_territory => "España",
    },
    { id => "es_ES_PREEURO",
      en_language => "Spanish",
      en_territory => "Spain",
      en_variant => "Preeuro",
      native_language => "español",
      native_territory => "España",
      native_variant => "Preeuro",
      real_class => "es_ES",
    },
    { id => "es_GT",
      en_language => "Spanish",
      en_territory => "Guatemala",
      native_language => "español",
      native_territory => "Guatemala",
    },
    { id => "es_HN",
      en_language => "Spanish",
      en_territory => "Honduras",
      native_language => "español",
      native_territory => "Honduras",
    },
    { id => "es_MX",
      en_language => "Spanish",
      en_territory => "Mexico",
      native_language => "español",
      native_territory => "México",
    },
    { id => "es_NI",
      en_language => "Spanish",
      en_territory => "Nicaragua",
      native_language => "español",
      native_territory => "Nicaragua",
    },
    { id => "es_PA",
      en_language => "Spanish",
      en_territory => "Panama",
      native_language => "español",
      native_territory => "Panamá",
    },
    { id => "es_PE",
      en_language => "Spanish",
      en_territory => "Peru",
      native_language => "español",
      native_territory => "Perú",
    },
    { id => "es_PR",
      en_language => "Spanish",
      en_territory => "Puerto\ Rico",
      native_language => "español",
      native_territory => "Puerto\ Rico",
    },
    { id => "es_PY",
      en_language => "Spanish",
      en_territory => "Paraguay",
      native_language => "español",
      native_territory => "Paraguay",
    },
    { id => "es_SV",
      en_language => "Spanish",
      en_territory => "El\ Salvador",
      native_language => "español",
      native_territory => "El\ Salvador",
    },
    { id => "es_US",
      en_language => "Spanish",
      en_territory => "United\ States",
      native_language => "español",
      native_territory => "Estados\ Unidos",
    },
    { id => "es_UY",
      en_language => "Spanish",
      en_territory => "Uruguay",
      native_language => "español",
      native_territory => "Uruguay",
    },
    { id => "es_VE",
      en_language => "Spanish",
      en_territory => "Venezuela",
      native_language => "español",
      native_territory => "Venezuela",
    },
    { id => "es__TRADITIONAL",
      en_language => "Spanish",
      en_variant => "Traditional",
      native_language => "español",
      native_variant => "Traditional",
      real_class => "root",
    },
    { id => "et",
      en_language => "Estonian",
      native_language => "Eesti",
    },
    { id => "et_EE",
      en_language => "Estonian",
      en_territory => "Estonia",
      native_language => "Eesti",
      native_territory => "Eesti",
      real_class => "et",
    },
    { id => "eu",
      en_language => "Basque",
      native_language => "euskara",
    },
    { id => "eu_ES",
      en_language => "Basque",
      en_territory => "Spain",
      native_language => "euskara",
      native_territory => "Spain",
    },
    { id => "eu_ES_PREEURO",
      en_language => "Basque",
      en_territory => "Spain",
      en_variant => "Preeuro",
      native_language => "euskara",
      native_territory => "Spain",
      native_variant => "Preeuro",
      real_class => "eu_ES",
    },
    { id => "fa",
      en_language => "Persian",
      native_language => "فارسی",
    },
    { id => "fa_IR",
      en_language => "Persian",
      en_territory => "Iran",
      native_language => "فارسی",
      native_territory => "ایران",
      real_class => "fa",
    },
    { id => "fi",
      en_language => "Finnish",
      native_language => "suomi",
    },
    { id => "fi_FI",
      en_language => "Finnish",
      en_territory => "Finland",
      native_language => "suomi",
      native_territory => "Suomi",
      real_class => "fi",
    },
    { id => "fi_FI_PREEURO",
      en_language => "Finnish",
      en_territory => "Finland",
      en_variant => "Preeuro",
      native_language => "suomi",
      native_territory => "Suomi",
      native_variant => "Preeuro",
      real_class => "fi",
    },
    { id => "fo",
      en_language => "Faroese",
      native_language => "føroyskt",
    },
    { id => "fo_FO",
      en_language => "Faroese",
      en_territory => "Faroe\ Islands",
      native_language => "føroyskt",
      native_territory => "Føroyar",
    },
    { id => "fr",
      en_language => "French",
      native_language => "français",
    },
    { id => "fr_BE",
      en_language => "French",
      en_territory => "Belgium",
      native_language => "français",
      native_territory => "Belgique",
    },
    { id => "fr_BE_PREEURO",
      en_language => "French",
      en_territory => "Belgium",
      en_variant => "Preeuro",
      native_language => "français",
      native_territory => "Belgique",
      native_variant => "Preeuro",
      real_class => "fr_BE",
    },
    { id => "fr_CA",
      en_language => "French",
      en_territory => "Canada",
      native_language => "français",
      native_territory => "Canada",
    },
    { id => "fr_CH",
      en_language => "French",
      en_territory => "Switzerland",
      native_language => "français",
      native_territory => "Suisse",
    },
    { id => "fr_FR",
      en_language => "French",
      en_territory => "France",
      native_language => "français",
      native_territory => "France",
      real_class => "fr",
    },
    { id => "fr_FR_PREEURO",
      en_language => "French",
      en_territory => "France",
      en_variant => "Preeuro",
      native_language => "français",
      native_territory => "France",
      native_variant => "Preeuro",
      real_class => "fr",
    },
    { id => "fr_LU",
      en_language => "French",
      en_territory => "Luxembourg",
      native_language => "français",
      native_territory => "Luxembourg",
      real_class => "fr",
    },
    { id => "fr_LU_PREEURO",
      en_language => "French",
      en_territory => "Luxembourg",
      en_variant => "Preeuro",
      native_language => "français",
      native_territory => "Luxembourg",
      native_variant => "Preeuro",
      real_class => "fr",
    },
    { id => "fr_MC",
      en_language => "French",
      en_territory => "Monaco",
      native_language => "français",
      native_territory => "Monaco",
      real_class => "fr",
    },
    { id => "ga",
      en_language => "Irish",
      native_language => "Irish",
    },
    { id => "ga_IE",
      en_language => "Irish",
      en_territory => "Ireland",
      native_language => "Irish",
      native_territory => "Ireland",
    },
    { id => "ga_IE_PREEURO",
      en_language => "Irish",
      en_territory => "Ireland",
      en_variant => "Preeuro",
      native_language => "Irish",
      native_territory => "Ireland",
      native_variant => "Preeuro",
      real_class => "ga_IE",
    },
    { id => "gl",
      en_language => "Gallegan",
      native_language => "Gallegan",
    },
    { id => "gl_ES",
      en_language => "Gallegan",
      en_territory => "Spain",
      native_language => "Gallegan",
      native_territory => "Spain",
    },
    { id => "gl_ES_PREEURO",
      en_language => "Gallegan",
      en_territory => "Spain",
      en_variant => "Preeuro",
      native_language => "Gallegan",
      native_territory => "Spain",
      native_variant => "Preeuro",
      real_class => "gl_ES",
    },
    { id => "gu",
      en_language => "Gujarati",
      native_language => "ગુજરાતી",
    },
    { id => "gu_IN",
      en_language => "Gujarati",
      en_territory => "India",
      native_language => "ગુજરાતી",
      native_territory => "ભારત",
    },
    { id => "gv",
      en_language => "Manx",
      native_language => "Manx",
    },
    { id => "gv_GB",
      en_language => "Manx",
      en_territory => "United\ Kingdom",
      native_language => "Manx",
      native_territory => "United\ Kingdom",
    },
    { id => "he",
      en_language => "Hebrew",
      native_language => "עברית",
    },
    { id => "he_IL",
      en_language => "Hebrew",
      en_territory => "Israel",
      native_language => "עברית",
      native_territory => "ישראל",
      real_class => "he",
    },
    { id => "hi",
      en_language => "Hindi",
      native_language => "हिंदी",
    },
    { id => "hi_IN",
      en_language => "Hindi",
      en_territory => "India",
      native_language => "हिंदी",
      native_territory => "भारत",
    },
    { id => "hr",
      en_language => "Croatian",
      native_language => "hrvatski",
    },
    { id => "hr_HR",
      en_language => "Croatian",
      en_territory => "Croatia",
      native_language => "hrvatski",
      native_territory => "Hrvatska",
      real_class => "hr",
    },
    { id => "hu",
      en_language => "Hungarian",
      native_language => "magyar",
    },
    { id => "hu_HU",
      en_language => "Hungarian",
      en_territory => "Hungary",
      native_language => "magyar",
      native_territory => "Magyarország",
      real_class => "hu",
    },
    { id => "hy",
      en_language => "Armenian",
      native_language => "Հայերէն",
    },
    { id => "hy_AM",
      en_language => "Armenian",
      en_territory => "Armenia",
      native_language => "Հայերէն",
      native_territory => "Հայաստանի\ Հանրապետութիւն",
    },
    { id => "hy_AM_REVISED",
      en_language => "Armenian",
      en_territory => "Armenia",
      en_variant => "Revised",
      native_language => "Հայերէն",
      native_territory => "Հայաստանի\ Հանրապետութիւն",
      native_variant => "Revised",
    },
    { id => "id",
      en_language => "Indonesian",
      native_language => "Indonesian",
    },
    { id => "id_ID",
      en_language => "Indonesian",
      en_territory => "Indonesia",
      native_language => "Indonesian",
      native_territory => "Indonesia",
    },
    { id => "is",
      en_language => "Icelandic",
      native_language => "íslenska",
    },
    { id => "is_IS",
      en_language => "Icelandic",
      en_territory => "Iceland",
      native_language => "íslenska",
      native_territory => "Ísland",
      real_class => "is",
    },
    { id => "it",
      en_language => "Italian",
      native_language => "italiano",
    },
    { id => "it_CH",
      en_language => "Italian",
      en_territory => "Switzerland",
      native_language => "italiano",
      native_territory => "Svizzera",
    },
    { id => "it_IT",
      en_language => "Italian",
      en_territory => "Italy",
      native_language => "italiano",
      native_territory => "Italia",
    },
    { id => "it_IT_PREEURO",
      en_language => "Italian",
      en_territory => "Italy",
      en_variant => "Preeuro",
      native_language => "italiano",
      native_territory => "Italia",
      native_variant => "Preeuro",
      real_class => "it_IT",
    },
    { id => "ja",
      en_language => "Japanese",
      native_language => "日本語",
    },
    { id => "ja_JP",
      en_language => "Japanese",
      en_territory => "Japan",
      native_language => "日本語",
      native_territory => "日本",
      real_class => "ja",
    },
    { id => "ka",
      en_language => "Georgian",
      native_language => "ქართული",
    },
    { id => "ka_GE",
      en_language => "Georgian",
      en_territory => "Georgia",
      native_language => "ქართული",
      native_territory => "საქართველო",
    },
    { id => "kk",
      en_language => "Kazakh",
      native_language => "Қазақ",
    },
    { id => "kk_KZ",
      en_language => "Kazakh",
      en_territory => "Kazakhstan",
      native_language => "Қазақ",
      native_territory => "Қазақстан",
      real_class => "kk",
    },
    { id => "kl",
      en_language => "Kalaallisut",
      native_language => "Kalaallisut",
    },
    { id => "kl_GL",
      en_language => "Kalaallisut",
      en_territory => "Greenland",
      native_language => "Kalaallisut",
      native_territory => "Greenland",
    },
    { id => "kn",
      en_language => "Kannada",
      native_language => "ಕನ್ನಡ",
    },
    { id => "kn_IN",
      en_language => "Kannada",
      en_territory => "India",
      native_language => "ಕನ್ನಡ",
      native_territory => "ಭಾರತ",
    },
    { id => "ko",
      en_language => "Korean",
      native_language => "한국어",
    },
    { id => "ko_KR",
      en_language => "Korean",
      en_territory => "South\ Korea",
      native_language => "한국어",
      native_territory => "대한민국",
    },
    { id => "kok",
      en_language => "Konkani",
      native_language => "कोंकणी",
    },
    { id => "kok_IN",
      en_language => "Konkani",
      en_territory => "India",
      native_language => "कोंकणी",
      native_territory => "भारत",
    },
    { id => "kw",
      en_language => "Cornish",
      native_language => "Cornish",
    },
    { id => "kw_GB",
      en_language => "Cornish",
      en_territory => "United\ Kingdom",
      native_language => "Cornish",
      native_territory => "United\ Kingdom",
    },
    { id => "ky",
      en_language => "Kirghiz",
      native_language => "Кыргыз",
    },
    { id => "ky_KG",
      en_language => "Kirghiz",
      en_territory => "Kyrgyzstan",
      native_language => "Кыргыз",
      native_territory => "Kyrgyzstan",
    },
    { id => "lt",
      en_language => "Lithuanian",
      native_language => "Lietuvių",
    },
    { id => "lt_LT",
      en_language => "Lithuanian",
      en_territory => "Lithuania",
      native_language => "Lietuvių",
      native_territory => "Lietuva",
      real_class => "lt",
    },
    { id => "lv",
      en_language => "Latvian",
      native_language => "Latviešu",
    },
    { id => "lv_LV",
      en_language => "Latvian",
      en_territory => "Latvia",
      native_language => "Latviešu",
      native_territory => "Latvija",
      real_class => "lv",
    },
    { id => "mk",
      en_language => "Macedonian",
      native_language => "македонски",
    },
    { id => "mk_MK",
      en_language => "Macedonian",
      en_territory => "Macedonia",
      native_language => "македонски",
      native_territory => "Македонија",
      real_class => "mk",
    },
    { id => "mn",
      en_language => "Mongolian",
      native_language => "Монгол\ хэл",
    },
    { id => "mn_MN",
      en_language => "Mongolian",
      en_territory => "Mongolia",
      native_language => "Монгол\ хэл",
      native_territory => "Mongolia",
    },
    { id => "mr",
      en_language => "Marathi",
      native_language => "मराठी",
    },
    { id => "mr_IN",
      en_language => "Marathi",
      en_territory => "India",
      native_language => "मराठी",
      native_territory => "भारत",
    },
    { id => "ms",
      en_language => "Malay",
      native_language => "Malay",
    },
    { id => "ms_BN",
      en_language => "Malay",
      en_territory => "Brunei",
      native_language => "Malay",
      native_territory => "Brunei",
    },
    { id => "ms_MY",
      en_language => "Malay",
      en_territory => "Malaysia",
      native_language => "Malay",
      native_territory => "Malaysia",
    },
    { id => "mt",
      en_language => "Maltese",
      native_language => "Malti",
    },
    { id => "mt_MT",
      en_language => "Maltese",
      en_territory => "Malta",
      native_language => "Malti",
      native_territory => "Malta",
      real_class => "mt",
    },
    { id => "nb",
      en_language => "Norwegian\ Bokmål",
      native_language => "bokmål",
    },
    { id => "nb_NO",
      en_language => "Norwegian\ Bokmål",
      en_territory => "Norway",
      native_language => "bokmål",
      native_territory => "Norge",
      real_class => "nb",
    },
    { id => "nl",
      en_language => "Dutch",
      native_language => "Nederlands",
    },
    { id => "nl_BE",
      en_language => "Dutch",
      en_territory => "Belgium",
      native_language => "Nederlands",
      native_territory => "België",
    },
    { id => "nl_BE_PREEURO",
      en_language => "Dutch",
      en_territory => "Belgium",
      en_variant => "Preeuro",
      native_language => "Nederlands",
      native_territory => "België",
      native_variant => "Preeuro",
      real_class => "nl_BE",
    },
    { id => "nl_NL",
      en_language => "Dutch",
      en_territory => "Netherlands",
      native_language => "Nederlands",
      native_territory => "Nederland",
      real_class => "nl",
    },
    { id => "nl_NL_PREEURO",
      en_language => "Dutch",
      en_territory => "Netherlands",
      en_variant => "Preeuro",
      native_language => "Nederlands",
      native_territory => "Nederland",
      native_variant => "Preeuro",
      real_class => "nl",
    },
    { id => "nn",
      en_language => "Norwegian\ Nynorsk",
      native_language => "nynorsk",
    },
    { id => "nn_NO",
      en_language => "Norwegian\ Nynorsk",
      en_territory => "Norway",
      native_language => "nynorsk",
      native_territory => "Noreg",
      real_class => "nn",
    },
    { id => "no",
      en_language => "Norwegian",
      native_language => "norsk",
    },
    { id => "no_NO",
      en_language => "Norwegian",
      en_territory => "Norway",
      native_language => "norsk",
      native_territory => "Norge",
      real_class => "no",
    },
    { id => "no_NO_NY",
      en_language => "Norwegian",
      en_territory => "Norway",
      en_variant => "Ny",
      native_language => "norsk",
      native_territory => "Norge",
      native_variant => "Ny",
      real_class => "no",
    },
    { id => "om",
      en_language => "Oromo",
      native_language => "Oromoo",
    },
    { id => "om_ET",
      en_language => "Oromo",
      en_territory => "Ethiopia",
      native_language => "Oromoo",
      native_territory => "Itoophiyaa",
    },
    { id => "om_KE",
      en_language => "Oromo",
      en_territory => "Kenya",
      native_language => "Oromoo",
      native_territory => "Keeniyaa",
    },
    { id => "pa",
      en_language => "Punjabi",
      native_language => "ਪੰਜਾਬੀ",
    },
    { id => "pa_IN",
      en_language => "Punjabi",
      en_territory => "India",
      native_language => "ਪੰਜਾਬੀ",
      native_territory => "ਭਾਰਤ",
    },
    { id => "pl",
      en_language => "Polish",
      native_language => "polski",
    },
    { id => "pl_PL",
      en_language => "Polish",
      en_territory => "Poland",
      native_language => "polski",
      native_territory => "Polska",
      real_class => "pl",
    },
    { id => "pt",
      en_language => "Portuguese",
      native_language => "Português",
    },
    { id => "pt_BR",
      en_language => "Portuguese",
      en_territory => "Brazil",
      native_language => "Português",
      native_territory => "Brasil",
    },
    { id => "pt_PT",
      en_language => "Portuguese",
      en_territory => "Portugal",
      native_language => "Português",
      native_territory => "Portugal",
      real_class => "pt",
    },
    { id => "pt_PT_PREEURO",
      en_language => "Portuguese",
      en_territory => "Portugal",
      en_variant => "Preeuro",
      native_language => "Português",
      native_territory => "Portugal",
      native_variant => "Preeuro",
      real_class => "pt",
    },
    { id => "ro",
      en_language => "Romanian",
      native_language => "română",
    },
    { id => "ro_RO",
      en_language => "Romanian",
      en_territory => "Romania",
      native_language => "română",
      native_territory => "România",
      real_class => "ro",
    },
    { id => "root",
      en_language => "Root",
      native_language => "Root",
    },
    { id => "ru",
      en_language => "Russian",
      native_language => "русский",
    },
    { id => "ru_RU",
      en_language => "Russian",
      en_territory => "Russia",
      native_language => "русский",
      native_territory => "Россия",
      real_class => "ru",
    },
    { id => "ru_UA",
      en_language => "Russian",
      en_territory => "Ukraine",
      native_language => "русский",
      native_territory => "Украина",
    },
    { id => "sa",
      en_language => "Sanskrit",
      native_language => "संस्कृत",
    },
    { id => "sa_IN",
      en_language => "Sanskrit",
      en_territory => "India",
      native_language => "संस्कृत",
      native_territory => "India",
    },
    { id => "sh",
      en_language => "Serbo\-Croatian",
      native_language => "Srpsko\-Hrvatski",
    },
    { id => "sh_YU",
      en_language => "Serbo\-Croatian",
      en_territory => "Yugoslavia",
      native_language => "Srpsko\-Hrvatski",
      native_territory => "Jugoslavija",
      real_class => "sh",
    },
    { id => "sk",
      en_language => "Slovak",
      native_language => "Slovenčina",
    },
    { id => "sk_SK",
      en_language => "Slovak",
      en_territory => "Slovakia",
      native_language => "Slovenčina",
      native_territory => "Slovenská\ republika",
      real_class => "sk",
    },
    { id => "sl",
      en_language => "Slovenian",
      native_language => "Slovenščina",
    },
    { id => "sl_SI",
      en_language => "Slovenian",
      en_territory => "Slovenia",
      native_language => "Slovenščina",
      native_territory => "Slovenija",
      real_class => "sl",
    },
    { id => "so",
      en_language => "Somali",
      native_language => "Soomaali",
    },
    { id => "so_DJ",
      en_language => "Somali",
      en_territory => "Djibouti",
      native_language => "Soomaali",
      native_territory => "Jabuuti",
      real_class => "so",
    },
    { id => "so_ET",
      en_language => "Somali",
      en_territory => "Ethiopia",
      native_language => "Soomaali",
      native_territory => "Itoobiya",
      real_class => "so",
    },
    { id => "so_KE",
      en_language => "Somali",
      en_territory => "Kenya",
      native_language => "Soomaali",
      native_territory => "Kiiniya",
    },
    { id => "so_SO",
      en_language => "Somali",
      en_territory => "Somalia",
      native_language => "Soomaali",
      native_territory => "Soomaaliya",
      real_class => "so",
    },
    { id => "sq",
      en_language => "Albanian",
      native_language => "shqipe",
    },
    { id => "sq_AL",
      en_language => "Albanian",
      en_territory => "Albania",
      native_language => "shqipe",
      native_territory => "Shqipëria",
      real_class => "sq",
    },
    { id => "sr",
      en_language => "Serbian",
      native_language => "Српски",
    },
    { id => "sr_YU",
      en_language => "Serbian",
      en_territory => "Yugoslavia",
      native_language => "Српски",
      native_territory => "Југославија",
      real_class => "sr",
    },
    { id => "sv",
      en_language => "Swedish",
      native_language => "svenska",
    },
    { id => "sv_FI",
      en_language => "Swedish",
      en_territory => "Finland",
      native_language => "svenska",
      native_territory => "Finland",
      real_class => "sv",
    },
    { id => "sv_SE",
      en_language => "Swedish",
      en_territory => "Sweden",
      native_language => "svenska",
      native_territory => "Sverige",
      real_class => "sv",
    },
    { id => "sw",
      en_language => "Swahili",
      native_language => "Kiswahili",
    },
    { id => "sw_KE",
      en_language => "Swahili",
      en_territory => "Kenya",
      native_language => "Kiswahili",
      native_territory => "Kenya",
      real_class => "sw",
    },
    { id => "sw_TZ",
      en_language => "Swahili",
      en_territory => "Tanzania",
      native_language => "Kiswahili",
      native_territory => "Tanzania",
      real_class => "sw",
    },
    { id => "syr",
      en_language => "Syriac",
      native_language => "ܣܘܪܝܝܐ",
    },
    { id => "syr_SY",
      en_language => "Syriac",
      en_territory => "Syria",
      native_language => "ܣܘܪܝܝܐ",
      native_territory => "Syria",
    },
    { id => "ta",
      en_language => "Tamil",
      native_language => "தமிழ்",
    },
    { id => "ta_IN",
      en_language => "Tamil",
      en_territory => "India",
      native_language => "தமிழ்",
      native_territory => "இந்தியா",
    },
    { id => "te",
      en_language => "Telugu",
      native_language => "తెలుగు",
    },
    { id => "te_IN",
      en_language => "Telugu",
      en_territory => "India",
      native_language => "తెలుగు",
      native_territory => "భారత\ దెళ౦",
    },
    { id => "th",
      en_language => "Thai",
      native_language => "ไทย",
    },
    { id => "th_TH",
      en_language => "Thai",
      en_territory => "Thailand",
      native_language => "ไทย",
      native_territory => "ประเทศไทย",
      real_class => "th",
    },
    { id => "ti",
      en_language => "Tigrinya",
      native_language => "ትግርኛ",
    },
    { id => "ti_ER",
      en_language => "Tigrinya",
      en_territory => "Eritrea",
      native_language => "ትግርኛ",
      native_territory => "ኤርትራ",
    },
    { id => "ti_ET",
      en_language => "Tigrinya",
      en_territory => "Ethiopia",
      native_language => "ትግርኛ",
      native_territory => "ኢትዮጵያ",
    },
    { id => "tr",
      en_language => "Turkish",
      native_language => "Türkçe",
    },
    { id => "tr_TR",
      en_language => "Turkish",
      en_territory => "Turkey",
      native_language => "Türkçe",
      native_territory => "Türkiye",
      real_class => "tr",
    },
    { id => "tt",
      en_language => "Tatar",
      native_language => "Татар",
    },
    { id => "tt_RU",
      en_language => "Tatar",
      en_territory => "Russia",
      native_language => "Татар",
      native_territory => "Russia",
    },
    { id => "uk",
      en_language => "Ukrainian",
      native_language => "українська",
    },
    { id => "uk_UA",
      en_language => "Ukrainian",
      en_territory => "Ukraine",
      native_language => "українська",
      native_territory => "Україна",
      real_class => "uk",
    },
    { id => "ur",
      en_language => "Urdu",
      native_language => "اردو",
    },
    { id => "ur_PK",
      en_language => "Urdu",
      en_territory => "Pakistan",
      native_language => "اردو",
      native_territory => "پاكِستان",
    },
    { id => "uz",
      en_language => "Uzbek",
      native_language => "Ўзбек",
    },
    { id => "uz_UZ",
      en_language => "Uzbek",
      en_territory => "Uzbekistan",
      native_language => "Ўзбек",
      native_territory => "Ўзбекистон",
    },
    { id => "vi",
      en_language => "Vietnamese",
      native_language => "Tiếng\ Việt",
    },
    { id => "vi_VN",
      en_language => "Vietnamese",
      en_territory => "Vietnam",
      native_language => "Tiếng\ Việt",
      native_territory => "Việt\ Nam",
      real_class => "vi",
    },
    { id => "zh",
      en_language => "Chinese",
      native_language => "中文",
    },
    { id => "zh_CN",
      en_language => "Chinese",
      en_territory => "China",
      native_language => "中文",
      native_territory => "中華人民共和國",
    },
    { id => "zh_HK",
      en_language => "Chinese",
      en_territory => "Hong\ Kong\ S\.A\.R\.\,\ China",
      native_language => "中文",
      native_territory => "香港",
    },
    { id => "zh_MO",
      en_language => "Chinese",
      en_territory => "Macao\ S\.A\.R\.\ China",
      native_language => "中文",
      native_territory => "中国澳门特别行政区",
    },
    { id => "zh_SG",
      en_language => "Chinese",
      en_territory => "Singapore",
      native_language => "中文",
      native_territory => "新加坡",
    },
    { id => "zh_TW",
      en_language => "Chinese",
      en_territory => "Taiwan",
      native_language => "中文",
      native_territory => "臺灣",
    },
    { id => "zh_TW_STROKE",
      en_language => "Chinese",
      en_territory => "Taiwan",
      en_variant => "Stroke",
      native_language => "中文",
      native_territory => "臺灣",
      native_variant => "Stroke",
      real_class => "zh_TW",
    },
);

%DateTime::Locale::Aliases = (
    C => 'en_US_POSIX',
    POSIX => 'en_US_POSIX',
    iw => 'he',
    iw_IL => 'he_IL',
);

1;

__END__

=head1 NAME

DateTime::LocaleCatalog - Provides a list of all valid locale names

=head1 SYNOPSIS

See DateTime::Locale for usage details.

=head1 DESCRIPTION

This module contains a list of all known locales.

=head1 LOCALES

Any method taking locale id or name arguments should use one of the
values listed below.  Ids and names are case sensitive.

Always select the closest matching locale - for example, French
Canadians would choose fr_CA over fr - and B<always> use locale ids in
preference to names; locale ids offer greater compatibility when using
localized third party modules.

Many of the available locales are the same as other, more generic
locales for datetime information.  In that case, we simply load the
more generic class.  However, the various methods related to name,
territory, and variant return the values for the requested locale.

The available locales are:

 Locale id           Locale name
 ==================================================
 af                  Afrikaans
 af_ZA               Afrikaans South Africa
 am                  Amharic
 am_ET               Amharic Ethiopia
 ar                  Arabic
 ar_AE               Arabic United Arab Emirates
 ar_BH               Arabic Bahrain
 ar_DZ               Arabic Algeria
 ar_EG               Arabic Egypt
 ar_IN               Arabic India
 ar_IQ               Arabic Iraq
 ar_JO               Arabic Jordan
 ar_KW               Arabic Kuwait
 ar_LB               Arabic Lebanon
 ar_LY               Arabic Libya
 ar_MA               Arabic Morocco
 ar_OM               Arabic Oman
 ar_QA               Arabic Qatar
 ar_SA               Arabic Saudi Arabia
 ar_SD               Arabic Sudan
 ar_SY               Arabic Syria
 ar_TN               Arabic Tunisia
 ar_YE               Arabic Yemen
 az                  Azerbaijani
 az_AZ               Azerbaijani Azerbaijan
 be                  Belarusian
 be_BY               Belarusian Belarus
 bg                  Bulgarian
 bg_BG               Bulgarian Bulgaria
 bn                  Bengali
 bn_IN               Bengali India
 ca                  Catalan
 ca_ES               Catalan Spain
 ca_ES_PREEURO       Catalan Spain Preeuro
 cs                  Czech
 cs_CZ               Czech Czech Republic
 da                  Danish
 da_DK               Danish Denmark
 de                  German
 de_AT               German Austria
 de_AT_PREEURO       German Austria Preeuro
 de_BE               German Belgium
 de_CH               German Switzerland
 de_DE               German Germany
 de_DE_PREEURO       German Germany Preeuro
 de_LI               German Liechtenstein
 de_LU               German Luxembourg
 de_LU_PREEURO       German Luxembourg Preeuro
 dv                  Divehi
 dv_MV               Divehi Maldives
 el                  Greek
 el_GR               Greek Greece
 el_GR_PREEURO       Greek Greece Preeuro
 en                  English
 en_AS               English American Samoa
 en_AU               English Australia
 en_BE               English Belgium
 en_BE_PREEURO       English Belgium Preeuro
 en_BW               English Botswana
 en_BZ               English Belize
 en_CA               English Canada
 en_GB               English United Kingdom
 en_GB_EURO          English United Kingdom Euro
 en_GU               English Guam
 en_HK               English Hong Kong S.A.R., China
 en_IE               English Ireland
 en_IE_PREEURO       English Ireland Preeuro
 en_IN               English India
 en_JM               English Jamaica
 en_MH               English Marshall Islands
 en_MP               English Northern Mariana Islands
 en_MT               English Malta
 en_NZ               English New Zealand
 en_PH               English Philippines
 en_SG               English Singapore
 en_TT               English Trinidad and Tobago
 en_UM               English United States Minor Outlying Islands
 en_US               English United States
 en_US_POSIX         English United States Posix
 en_VI               English U.S. Virgin Islands
 en_ZA               English South Africa
 en_ZW               English Zimbabwe
 eo                  Esperanto
 es                  Spanish
 es_AR               Spanish Argentina
 es_BO               Spanish Bolivia
 es_CL               Spanish Chile
 es_CO               Spanish Colombia
 es_CR               Spanish Costa Rica
 es_DO               Spanish Dominican Republic
 es_EC               Spanish Ecuador
 es_ES               Spanish Spain
 es_ES_PREEURO       Spanish Spain Preeuro
 es_GT               Spanish Guatemala
 es_HN               Spanish Honduras
 es_MX               Spanish Mexico
 es_NI               Spanish Nicaragua
 es_PA               Spanish Panama
 es_PE               Spanish Peru
 es_PR               Spanish Puerto Rico
 es_PY               Spanish Paraguay
 es_SV               Spanish El Salvador
 es_US               Spanish United States
 es_UY               Spanish Uruguay
 es_VE               Spanish Venezuela
 es__TRADITIONAL     Spanish Traditional
 et                  Estonian
 et_EE               Estonian Estonia
 eu                  Basque
 eu_ES               Basque Spain
 eu_ES_PREEURO       Basque Spain Preeuro
 fa                  Persian
 fa_IR               Persian Iran
 fi                  Finnish
 fi_FI               Finnish Finland
 fi_FI_PREEURO       Finnish Finland Preeuro
 fo                  Faroese
 fo_FO               Faroese Faroe Islands
 fr                  French
 fr_BE               French Belgium
 fr_BE_PREEURO       French Belgium Preeuro
 fr_CA               French Canada
 fr_CH               French Switzerland
 fr_FR               French France
 fr_FR_PREEURO       French France Preeuro
 fr_LU               French Luxembourg
 fr_LU_PREEURO       French Luxembourg Preeuro
 fr_MC               French Monaco
 ga                  Irish
 ga_IE               Irish Ireland
 ga_IE_PREEURO       Irish Ireland Preeuro
 gl                  Gallegan
 gl_ES               Gallegan Spain
 gl_ES_PREEURO       Gallegan Spain Preeuro
 gu                  Gujarati
 gu_IN               Gujarati India
 gv                  Manx
 gv_GB               Manx United Kingdom
 he                  Hebrew
 he_IL               Hebrew Israel
 hi                  Hindi
 hi_IN               Hindi India
 hr                  Croatian
 hr_HR               Croatian Croatia
 hu                  Hungarian
 hu_HU               Hungarian Hungary
 hy                  Armenian
 hy_AM               Armenian Armenia
 hy_AM_REVISED       Armenian Armenia Revised
 id                  Indonesian
 id_ID               Indonesian Indonesia
 is                  Icelandic
 is_IS               Icelandic Iceland
 it                  Italian
 it_CH               Italian Switzerland
 it_IT               Italian Italy
 it_IT_PREEURO       Italian Italy Preeuro
 ja                  Japanese
 ja_JP               Japanese Japan
 ka                  Georgian
 ka_GE               Georgian Georgia
 kk                  Kazakh
 kk_KZ               Kazakh Kazakhstan
 kl                  Kalaallisut
 kl_GL               Kalaallisut Greenland
 kn                  Kannada
 kn_IN               Kannada India
 ko                  Korean
 ko_KR               Korean South Korea
 kok                 Konkani
 kok_IN              Konkani India
 kw                  Cornish
 kw_GB               Cornish United Kingdom
 ky                  Kirghiz
 ky_KG               Kirghiz Kyrgyzstan
 lt                  Lithuanian
 lt_LT               Lithuanian Lithuania
 lv                  Latvian
 lv_LV               Latvian Latvia
 mk                  Macedonian
 mk_MK               Macedonian Macedonia
 mn                  Mongolian
 mn_MN               Mongolian Mongolia
 mr                  Marathi
 mr_IN               Marathi India
 ms                  Malay
 ms_BN               Malay Brunei
 ms_MY               Malay Malaysia
 mt                  Maltese
 mt_MT               Maltese Malta
 nb                  Norwegian Bokmål
 nb_NO               Norwegian Bokmål Norway
 nl                  Dutch
 nl_BE               Dutch Belgium
 nl_BE_PREEURO       Dutch Belgium Preeuro
 nl_NL               Dutch Netherlands
 nl_NL_PREEURO       Dutch Netherlands Preeuro
 nn                  Norwegian Nynorsk
 nn_NO               Norwegian Nynorsk Norway
 no                  Norwegian
 no_NO               Norwegian Norway
 no_NO_NY            Norwegian Norway Ny
 om                  Oromo
 om_ET               Oromo Ethiopia
 om_KE               Oromo Kenya
 pa                  Punjabi
 pa_IN               Punjabi India
 pl                  Polish
 pl_PL               Polish Poland
 pt                  Portuguese
 pt_BR               Portuguese Brazil
 pt_PT               Portuguese Portugal
 pt_PT_PREEURO       Portuguese Portugal Preeuro
 ro                  Romanian
 ro_RO               Romanian Romania
 root                Root
 ru                  Russian
 ru_RU               Russian Russia
 ru_UA               Russian Ukraine
 sa                  Sanskrit
 sa_IN               Sanskrit India
 sh                  Serbo-Croatian
 sh_YU               Serbo-Croatian Yugoslavia
 sk                  Slovak
 sk_SK               Slovak Slovakia
 sl                  Slovenian
 sl_SI               Slovenian Slovenia
 so                  Somali
 so_DJ               Somali Djibouti
 so_ET               Somali Ethiopia
 so_KE               Somali Kenya
 so_SO               Somali Somalia
 sq                  Albanian
 sq_AL               Albanian Albania
 sr                  Serbian
 sr_YU               Serbian Yugoslavia
 sv                  Swedish
 sv_FI               Swedish Finland
 sv_SE               Swedish Sweden
 sw                  Swahili
 sw_KE               Swahili Kenya
 sw_TZ               Swahili Tanzania
 syr                 Syriac
 syr_SY              Syriac Syria
 ta                  Tamil
 ta_IN               Tamil India
 te                  Telugu
 te_IN               Telugu India
 th                  Thai
 th_TH               Thai Thailand
 ti                  Tigrinya
 ti_ER               Tigrinya Eritrea
 ti_ET               Tigrinya Ethiopia
 tr                  Turkish
 tr_TR               Turkish Turkey
 tt                  Tatar
 tt_RU               Tatar Russia
 uk                  Ukrainian
 uk_UA               Ukrainian Ukraine
 ur                  Urdu
 ur_PK               Urdu Pakistan
 uz                  Uzbek
 uz_UZ               Uzbek Uzbekistan
 vi                  Vietnamese
 vi_VN               Vietnamese Vietnam
 zh                  Chinese
 zh_CN               Chinese China
 zh_HK               Chinese Hong Kong S.A.R., China
 zh_MO               Chinese Macao S.A.R. China
 zh_SG               Chinese Singapore
 zh_TW               Chinese Taiwan
 zh_TW_STROKE        Chinese Taiwan Stroke


There are also some hard-coded aliases available, these are:

 Locale id           Is an alias for
 ==================================================
 C                   en_US_POSIX
 POSIX               en_US_POSIX
 iw                  he
 iw_IL               he_IL


=cut
