/* 
 * $Id: ctkobject.h,v 1.5 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKOBJECT_H__
#define __CTKOBJECT_H__

#include "ctktype.h"

struct CtkObject_S {
	gpointer (*destroy_func)();
	
	CtkType type;
	
	GSList *signals;
};

typedef struct CtkObject_S CtkObject;

void ctk_object_init(CtkObject *object);

#define CTK_OBJECT(obj)	CTK_CHECK_CAST((obj),CtkObject,CtkTypeObject)

#endif
