/* 
 * $Id: ctkbin.c,v 1.4 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>

#include "ctk.h"

/* We have bins that can deal with a child's padding, the border, and expand/fill */
/* Our bins are smart! This way we can reuse them in virtually everything else */

void ctk_bin_min_size(CtkWidget* widget)
{
	CtkWidget*    child;
	CtkContainer* container;
	
	if (!widget)
		return;
	
	widget->min_height = 0;
	widget->min_width  = 0;
	
	container = CTK_CONTAINER(widget);
	
	if (!widget->node || !widget->node->children || !widget->node->children->data)
		return;
		
	child = CTK_WIDGET(widget->node->children->data);
	
	if (!child->show)
		return;
	
	widget->min_height = (container->border_width + child->ypadding) * 2 + 
							child->min_height;
	widget->min_width  = (container->border_width + child->xpadding) * 2 + 
							child->min_width;
}

void ctk_bin_real_size(CtkWidget* widget)
{
	CtkWidget*    child;
	CtkContainer* container;
	
	if (!widget || !widget->node || !widget->node->children || 
		!widget->node->children->data)
		return;
	
	container = CTK_CONTAINER(widget);
	child     = CTK_WIDGET(widget->node->children->data);
	
	/* If child not shown, do nothing */
	if (!child->show)
		return;
	
	if (child->xfill)
	{
		child->width = widget->width - 
			(container->border_width + child->xpadding) * 2;
		child->col   = widget->col   +
			(container->border_width + child->xpadding);
	}
	else
	{
		child->width = child->min_width;
		child->col   = widget->col + (widget->width - child->width) / 2;
	}
	
	if (child->yfill)
	{
		child->height = widget->height - 
			(container->border_width + child->ypadding) * 2;
		child->row    = widget->row    +
			(container->border_width + child->ypadding);
	}
	else
	{
		child->height = child->min_height;
		child->row    = widget->row + (widget->height - child->height) / 2;
	}
}

void ctk_bin_set_default_child_flags(CtkContainer* container, CtkWidget* child)
{
	CtkWidget* self = CTK_WIDGET(container);
	
	ctk_container_set_default_child_flags(container, child);
	if (self->node && self->node->children)
	{
		ctk_close();
		g_error("ctk_bin_set_default_child_flags: container already has child");
	}
	
	/* By default, a bin will give all it's space to the child */
	
	child->xfill = TRUE;
	child->yfill = TRUE;
	child->xexpand = TRUE;
	child->yexpand = TRUE;
	
	child->xpadding = 0;
	child->ypadding = 0;
}

void ctk_bin_init(CtkBin *bin)
{
	ctk_container_init(&bin->container);
	
	((CtkContainer*)bin)->set_child_flags = &ctk_bin_set_default_child_flags;
	
	((CtkWidget*)bin)->set_min_size  = &ctk_bin_min_size;
	((CtkWidget*)bin)->set_real_size = &ctk_bin_real_size;
}
