#if !defined (__FACADE_HPP)
#define __FACADE_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif
  

namespace corelinux
{

   DECLARE_CLASS( Facade );

   /**
   Structuring a system into subsystems helps reduce complexity. A
   common design goal is to minimize the communication and dependencies
   between subsystems. A Facade defines a higher-level interface that
   makes the subsystem easier to use. This is also called a fat
   interface in some cases, and delegation model.
   */

   class Facade : public CoreLinuxObject
   {
   public:

                           /// Default Constructor

                           Facade( void );

                           /** Copy Constructor
                           @param Facade const reference
                           */

                           Facade( FacadeCref );

                           /// Virtual Destructor  

      virtual              ~Facade( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Facade const reference
               @return Facade reference to self
               */
            
               FacadeRef  operator=( FacadeCref );

               /**
               Equality operator overload
               @param Facade const reference
               @return true if equal, false otherwise
               */

               bool        operator==( FacadeCref ) const;

               /**
               Non-equality operator overload
               @param Facade const reference
               @return false if equal, true otherwise
               */

               bool        operator!=( FacadeCref ) const;

   };

}
          
#endif   // if !defined(__FACADE_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/


