#if   !defined(__SUBJECTOBSERVER_HPP)
#define __SUBJECTOBSERVER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__SUBJECT_HPP)
#include <corelinux/Subject.hpp>
#endif

#if   !defined(__OBSERVER_HPP)
#include <corelinux/Observer.hpp>
#endif

#if !defined(__MAP_HPP)
#include <corelinux/Map.hpp>
#endif

DECLARE_CLASS( SubjectObserver );

/**
SubjectObserver maintains the observer list and definitions for
subject. Because we have the need for all of our subjects to also
be observers, this factors the behavior as well.
*/

class SubjectObserver : public CORELINUX( Subject ), CORELINUX( Observer )
{
   CORELINUX_MULTIMAP
      ( 
         DwordIdentifier, 
         CORELINUX(ObserverPtr), 
         less<DwordIdentifier>,
	 ObserverMap
      );

public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        SubjectObserver( void );

                        /// Virtual destructor

   virtual              ~SubjectObserver( void );

   //
   // Operator overloads
   //
            /// Equality operator

            bool  operator=( SubjectObserverCref ) const;
            
   //
   // Mutators
   //

            /**
            Add an observer for a specific event
            @param Event the type of event interested in
            @exception NullPointer exception if event is null
            */

   virtual  void  addObserver
               ( 
                  CORELINUX( ObserverPtr ), 
                  CORELINUX( Event<corelinux::Identifier> ) * 
               ) 
               throw ( CORELINUX( NullPointerException ) ) ;

            /**
            Remove an observer from all event notifications
            @param Observer to remove
            @exception NullPointer exception Observer is null
            */

   virtual  void  removeObserver( CORELINUX( ObserverPtr ) ) 
               throw ( CORELINUX( NullPointerException ) ) ;

            /**
            Remove an observer from specific event notifications
            @param Observer to remove
            @exception NullPointer exception Observer or Event is null
            */

   virtual  void  removeObserver
               ( 
                  CORELINUX( ObserverPtr ), 
                  CORELINUX( Event<corelinux::Identifier> ) * 
               ) 
               throw ( CORELINUX( NullPointerException ) ) ;

   //
   // Iterator Factory methods
   //
            /**
            Create a iterator for all observers
            @return Iterator
            */

   virtual  CORELINUX(Iterator< corelinux::ObserverPtr >) 
               *createIterator( void );

            /**
            Create a iterator for observers of this event
            @param Event defines the event type predicate
            @return Iterator
            @exception NullPointerException if event null
            */

   virtual  CORELINUX(Iterator< corelinux::ObserverPtr >)  *createIterator
               ( 
                  CORELINUX( Event<corelinux::Identifier> ) * 
               ) 
               throw ( CORELINUX( NullPointerException ) ) ;

            /**
            Deletes the iterator instance
            @param Iterator
            @exception NullPointerException if iterator null
            */

   virtual  void destroyIterator
               ( 
                  CORELINUX(Iterator< corelinux::ObserverPtr >) * 
               ) 
               throw ( CORELINUX( NullPointerException ) ) ;

protected:

                        /// Copy constructor
                     
                        SubjectObserver( SubjectObserverCref ) 
                           throw ( CORELINUX( Assertion ) );

            /// Assignment operator

            SubjectObserverRef operator=( SubjectObserverCref )
               throw ( CORELINUX( Assertion ) );

private:
            /// Maps event identifiers to interested observers
         
            ObserverMap        theObserverMap;

};


#endif // if !defined(__SUBJECTOBSERVER_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/

