#if !defined (__IDENTIFIER_HPP)
#define __IDENTIFIER_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined IN_COMMON_HPP
   #error Identifier.hpp is included by Common.hpp only.
#endif

namespace corelinux
{

   DECLARE_CLASS( Identifier );

   /**
   An Identifier is a abstract representation of identity. Derivations
   implement ConcreteIdentifiers (Strings, Widgets, UUID, whatever).
   The logical operators call virtual methods which derivations
   should define.as all the defaults return true.
   */

   class Identifier : public CoreLinuxObject
   {
   public:

                           /// Default Constructor

                           Identifier( void );

                           /** Copy Constructor
                           @param Identifier const reference
                           */

                           Identifier( IdentifierCref );

                           /// Virtual Destructor  

      virtual              ~Identifier( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Identifier const reference
               @return Identifier reference to self
               */
            
               IdentifierRef  operator=( IdentifierCref );

               /**
               Equality operator overload calls isEqual
               virtual method.
               @param Identifier const reference
               @return true if equal, false otherwise
               */

               bool        operator==( IdentifierCref ) const;

               /**
               Non-equality operator overload returns
               !isEqual(aRef)
               @param Identifier const reference
               @return false if equal, true otherwise
               */

               bool        operator!=( IdentifierCref ) const;

               /**
               Less than operator overload. Calls isLessThan 
               virtual method.
               @param Identifier const reference
               @return true if less than, false otherwise
               */

               bool        operator<( IdentifierCref ) const;

               /**
               Less than or equal operator overload. Calls 
               isLessThanOrEqual virtual method.
               @param Identifier const reference
               @return true if less than or equal, false otherwise
               */

               bool        operator<=( IdentifierCref ) const;

               /**
               Greater than operator overload. Calls isGreaterThan
               virtual method.
               @param Identifier const reference
               @return true if greater than, false otherwise
               */

               bool        operator>( IdentifierCref ) const;

               /**
               Greater than or equal operator overload. Calls 
               isGreaterThanOrEqual virtual method.
               @param Identifier const reference
               @return true if greater than or equal, false otherwise
               */

               bool        operator>=( IdentifierCref ) const;

   protected:

               /**
               Equality method
               @param Identifier const reference
               @return true if equal, false otherwise
               */
         
      virtual  bool        isEqual( IdentifierCref ) const ;
         
               /**
               Less than method
               @param Identifier const reference
               @return true if less than, false otherwise
               */
         
      virtual  bool        isLessThan( IdentifierCref ) const ;
         
               /**
               Less than or equal method.
               @param Identifier const reference
               @return true if less than or equal, false otherwise
               */
         
      virtual  bool        isLessThanOrEqual( IdentifierCref ) const ;
         
               /**
               Greater than method.
               @param Identifier const reference
               @return true if greater than, false otherwise
               */
         
      virtual  bool        isGreaterThan( IdentifierCref ) const ;
         
               /**
               Greater than or equal method.
               @param Identifier const reference
               @return true if greater than or equal, false otherwise
               */

      virtual  bool        isGreaterThanOrEqual( IdentifierCref ) const ;

   };

}
          
#endif   // if !defined(__IDENTIFIER_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/



