#if !defined (__COMMON_HPP)
#define __COMMON_HPP

/*
   CoreLinux++ 
   Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

/**
   Common header file to libcorelinux. This header declares many
   helpful macros to enhance the readability of user object declaration
   and use.
   This header also pre-includes a number of core class declarations.
*/

// Used by the component headers to determine
// that they are indeed being included by
// Common.hpp

#define IN_COMMON_HPP

//
// Some standard information
//

// TEXT identifies that the following text
// string may be either UNICODE or ANSI
//
// TEXT("The quick brown fox jumped over the lazy dog!")
//
// will make the string UNICODE charactes if __UNICODE is defined
// and ANSI characters if not.

#if defined( __UNICODE )
   #if defined(__GNUC__)
      #include    <wchar.h>
      #define _STDTEXT(text) L##text
   #else
      #define _STDTEXT(text) text
   #endif
#else
   #define _STDTEXT(text) text
#endif

#define TEXT(text) _STDTEXT(text)

#define __STDFILE__ TEXT( __FILE__ )


/**
LOCATION is a shorthand for __FILE__, __LINE__.
It is used mainly in  exceptions i.e.
throw Exception( "some reason", LOCATION );
*/

#define LOCATION __STDFILE__, __LINE__

/**
IGNORE_RETURN is an indicator that the return
value for a function is ignored.
i.e   IGNORE_RETURN getSomething( ... );
Eliminates a lint warning.
*/

#define IGNORE_RETURN (void)

/**
Declare a new type and its pointer,
const pointer, reference, and const reference types. For example
DECLARE_TYPE( Dword, VeryLongTime );
@param mydecl The base type
@param mytype The new type
*/

#define DECLARE_TYPE( mydecl, mytype )  \
typedef mydecl         mytype;         \
typedef mytype *       mytype ## Ptr;  \
typedef const mytype * mytype ## Cptr; \
typedef mytype &       mytype ## Ref;  \
typedef const mytype & mytype ## Cref;

/**
Declare class , class pointer , 
const pointer, class reference 
and const class reference types for classes. For example
DECLARE_CLASS( Exception );
@param tag The class being declared
*/

#define DECLARE_CLASS( tag )            \
   class   tag;                        \
   typedef tag *       tag ## Ptr;     \
   typedef const tag * tag ## Cptr;    \
   typedef tag &       tag ## Ref;     \
   typedef const tag & tag ## Cref;

/// Define corelinux namespace macro

#define CORELINUX( tag ) \
    corelinux::tag

/// Forward reference the various common classes.

namespace corelinux
{
   DECLARE_CLASS( CoreLinuxObject   );    // Base class
   DECLARE_CLASS( AbstractString    );    // Dispatching virtual
   DECLARE_CLASS( StringUtf8        );    // Utf8 Implementation
   DECLARE_CLASS( Exception         );    // Basic Exception *temporary!!!
   DECLARE_CLASS( NullPointerException ); // NullPointerException
   DECLARE_CLASS( Assertion         );    // Thank you B. Meyers
   DECLARE_CLASS( Synchronized      );    // 
   DECLARE_CLASS( Thread            );    //
   DECLARE_CLASS( SemaphoreGroup    );    // 
   DECLARE_CLASS( AbstractInteger   );    // 
   DECLARE_CLASS( AbstractReal      );    // 
}

#include <cstddef>                             // size_t, wchar_t, NULL

// Non class types.  Must be the first
// include file in this module.

#include <Types.hpp>

// Size and value limits for the types in
// types.hpp

#include <Limits.hpp>

// Common class types.

#include <Exception.hpp>                  // Class Exception 
#include <CoreLinuxObject.hpp>            // Base support class
#include <AbstractString.hpp>             // Base Abstraction *temp!!!
#include <StringUtf8.hpp>                 // CoreLinux++ Default String
#include <NullPointerException.hpp>       // NullPointerException
#include <Assertion.hpp>                  // Class Assertion
#include <AccessRights.hpp>               // General Access Settings
#include <Identifier.hpp>                 // Base Identifier
#include <ScalarIdentifiers.hpp>          // Various identifiers
#include <Synchronized.hpp>
#include <Thread.hpp>
#include <Environment.hpp>

//#include <AbstractException.hpp>
//#include <AbstractSubject.hpp>
//#include <AbstractObserver.hpp>
//#include <AbstractInteger.hpp>
//#include <AbstractReal.hpp>
// Pre-included collections (STL)

#if   defined(__INCLUDE_COLLECTIONS)
#include <Pair.hpp>
#include <List.hpp>
#include <Queue.hpp>
#include <Stack.hpp>
#include <Vector.hpp>
#include <Map.hpp>
#include <Set.hpp>
#endif


// Do not add code after the next line.

#undef IN_COMMON_HPP

#endif  // !defined __COMMON_HPP

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.7 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/

