/***************************************************************************
 $RCSfile: ctcore.h,v $
                             -------------------
    cvs         : $Id: ctcore.h,v 1.11 2003/04/22 22:59:24 aquamaniac Exp $
    begin       : Fri Nov 22 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTDRIVER_H
#define CTDRIVER_H

#ifdef __cplusplus
extern "C" {
#endif


#include <chameleon/error.h>
#include <chameleon/conf.h>
#include <ctcore_public.h>

#define CT_READERS_PER_CLIENT 16



typedef struct CTREADERSTRUCT CTREADERTABLE;
typedef struct CTDRIVERSTRUCT CTDRIVERTABLE;
typedef struct CTCLIENTSTRUCT CTCLIENTTABLE;
typedef struct CTCORESTRUCT CTCORETABLE;


/* driver functions */
typedef ERRORCODE (*CTDRIVER_ALLOCTERMPTR)(CTREADERTABLE *rt);
typedef ERRORCODE (*CTDRIVER_RELEASETERMPTR)(CTREADERTABLE *rt);
typedef ERRORCODE (*CTDRIVER_CONNTERMPTR)(CTREADERTABLE *rt,
					  char *atrbuffer,
					  int *atrbufferlen);
typedef ERRORCODE (*CTDRIVER_DISCONNTERMPTR)(CTREADERTABLE *rt);
typedef ERRORCODE (*CTDRIVER_STATUSPTR)(CTREADERTABLE *rt,
					char *atrbuffer,
					int *atrbufferlen);
typedef ERRORCODE (*CTDRIVER_COMMANDPTR)(CTREADERTABLE *rt,
					 const char *sendBuffer,
					 int sendBufferLength,
					 char *recvBuffer,
					 int *recvBufferLength);

typedef CTREADERDESCRIPTION* (*CTDRIVER_ENUMTERMSPTR)(CTDRIVERTABLE *dt);
typedef ERRORCODE (*CTDRIVER_CLOSEPTR)(CTDRIVERTABLE *dt);



struct CTREADERSTRUCT {
  CTREADERTABLE *next;
  int lockedByClient;
  int usageCount;
  int openCount;
  unsigned int lastStatus;
  unsigned int deltaStatus;
  unsigned int softDeltaStatus;
  int cardChanged;
  char atr[256];
  int atrlen;
  CTREADERDESCRIPTION *descr;
  CTDRIVERTABLE *driver;
  void *driverData;
  unsigned int cardId;
  unsigned int lockedSince;
};


struct CTDRIVERSTRUCT {
  CTDRIVERTABLE *next;
  int usageCount;
  char name[256];
  void *driverData;
  CONFIGGROUP *driverDescription;
  CTDRIVER_CLOSEPTR closeDriver;
  CTDRIVER_ALLOCTERMPTR allocTerm;
  CTDRIVER_RELEASETERMPTR releaseTerm;
  CTDRIVER_STATUSPTR statTerm;
  CTDRIVER_CONNTERMPTR connectTerm;
  CTDRIVER_DISCONNTERMPTR disconnectTerm;
  CTDRIVER_ENUMTERMSPTR enumTerms;
  CTDRIVER_COMMANDPTR commandTerm;
};


struct CTCLIENTSTRUCT {
  CTCLIENTTABLE *next;
  int id;
  CTREADERTABLE* readers[CT_READERS_PER_CLIENT];
};


struct CTCORESTRUCT {
  int nextReaderId;
  int nextClientId;
  CTREADERDESCRIPTION *readerDescriptions;
  CTCLIENTTABLE *clients;
  CTDRIVERTABLE *drivers;
  CTREADERTABLE *readers;
  CONFIGGROUP *driverDescriptions;
};


// CTCore



CTREADERTABLE *CTCore_Reader_new();
void CTCore_Reader_free(CTREADERTABLE *rt);

CTDRIVERTABLE *CTCore_Driver_new();
void CTCore_Driver_free(CTDRIVERTABLE *dt);

CTCLIENTTABLE *CTCore_Client_new();
void CTCore_Client_free(CTCLIENTTABLE *ct);

CTCORETABLE *CTCore_new();
void CTCore_free(CTCORETABLE *ct);


/* Application Programming Interface */

int CTCore_RegisterClient(CTCORETABLE *ct);
void CTCore_UnregisterClient(CTCORETABLE *ct, int id);

/* translate a reader number to a reader id */
int CTCore_GetClientReaderId(CTCORETABLE *ct, int id, int tid);


/**
 * @return terminal id (-1 on error)
 */
int CTCore_AllocTerminal(CTCORETABLE *ct, int cid, int tid,
			 CTREADERDESCRIPTION **descr);
void CTCore_ReleaseTerminal(CTCORETABLE *ct, int cid, int tid);

ERRORCODE CTCore_ConnectTerminal(CTCORETABLE *ct, int cid, int tid,
				 char *atrbuffer,
				 int *atrbufferlen);
ERRORCODE CTCore_DisconnectTerminal(CTCORETABLE *ct, int cid, int tid);

ERRORCODE CTCore_CommandTerminal(CTCORETABLE *ct, int cid, int tid,
				 const char *sendBuffer,
				 int sendBufferLength,
				 char *recvBuffer,
				 int *recvBufferLength);

/**
 * Takes over ownership of driverDescriptions if result is ok
 */
ERRORCODE CTCore_Init(CTCORETABLE *ct, CONFIGGROUP *driverDescriptions);
ERRORCODE CTCore_Fini(CTCORETABLE *ct);

/**
 * Adds a reader description to the internal list.
 * This functions does not take over ownership of this description !
 * It makes a copy instead, if appropriate.
 * The given description will be updated (at least the id field).
 */
ERRORCODE CTCore_AddReader(CTCORETABLE *ct, CTREADERDESCRIPTION *rd);


/**
 * This must be called once per program. It initialized static data
 * (such as registering CTCore's error class etc).
 */
ERRORCODE CTCore_ModuleInit();

/**
 * This must be called once per program. It deinitialized static data
 * (such as unregistering CTCore's error class etc).
 */
ERRORCODE CTCore_ModuleFini();

/**
 * Checks the status of all currently used readers.
 * This especially updates the lastStatus and deltaStatus fields of the
 * readers.
 */
void CTCore_WalkTerminals(CTCORETABLE *ct);

/**
 * Actually retrieves the reader status from the driver.
 * Use this in test programs to really check the status.
 */
ERRORCODE CTCore_CheckReaderStatus(CTCORETABLE *ct, int cid, int tid,
				   unsigned int *status,
				   char *atrbuffer,
				   int *atrbufferlen);

/**
 * Returns the last status retrieved upon @ref CTCore_WalkTerminals().
 * Does no immediate communication with the driver.
 */
ERRORCODE CTCore_GetReaderStatus(CTCORETABLE *ct, int cid, int tid,
				 unsigned int *status,
				 char *atrbuffer,
				 int *atrbufferlen);


#ifdef __cplusplus
}
#endif


#endif /* CTDRIVER_H */


