/***************************************************************************
 $RCSfile: ctgeldkarte.h,v $
 -------------------
 cvs         : $Id: ctgeldkarte.h,v 1.4 2003/04/24 01:43:29 aquamaniac Exp $
 begin       : Sat Dec 21 2002
 copyright   : (C) 2002 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/





#ifndef CTGELDKARTE_H
#define CTGELDKARTE_H "$Id: ctgeldkarte.h,v 1.4 2003/04/24 01:43:29 aquamaniac Exp $"

#include <chipcard/ctprocessorcard.h>

/**
 *
 * @ingroup scards
 */
class CTGeldKarte: public CTProcessorCard {
public:
  /**
   * This class describes a Geldkarte.
   * @author Martin Preuss<martin@libchipcard.de>
   */
  class CHIPCARD_API CardData {
  private:
    unsigned char _industrialkey;
    unsigned int _shortinstcode;
    string _cardnumber;
    unsigned char _bestuntil_year;
    unsigned char _bestuntil_month;
    unsigned char _active_year;
    unsigned char _active_month;
    unsigned char _active_day;
    unsigned short _countrycode;
    string _currency;
    unsigned char _value;

  public:
    CardData();
    CardData(const string &s);
    ~CardData();

    /**
     * "Branchenhauptschluessel", dont know what that means but it has
     * always value 67.
     */
    int industrialKey() const { return _industrialkey;};
    /**
     * Short institute code of card delivering institute.
     */
    unsigned int shortInstituteCode() const { return _shortinstcode;};
    /**
     * ASCII-String cardnumber.
     */
    const string &cardNumber() const { return _cardnumber;};
    /**
     * Card is valid until THIS year.
     */
    int bestuntil_year() const { return _bestuntil_year;};
    /**
     * Card is valid until THIS month.
     */
    int bestuntil_month() const { return _bestuntil_month;};
    /**
     * Year of the card's activation.
     */
    int active_year() const { return _active_year;};
    /**
     * Month of the card's activation.
     */
    int active_month() const { return _active_month;};
    /**
     * Day of the card's activation.
     */
    int active_day() const { return _active_day;};
    /**
     * Country code (280 stands for Germany).
     */
    int countryCode() const { return _countrycode;};
    /**
     * Currency string ("DEM", "EUR").
     */
    const string &currency() const { return _currency;};

    /**
     * Returns the value of the currency. Possible values are:
     * <ul>
     *  <li>0x01: 10^-2 (cents or "Pfennige")</li>
     *  <li>0x02: 10^-1</li>
     *  <li>0x04: 10^0</li>
     *  <li>0x08: 10^1</li>
     *  <li>0x10: 10^2</li>
     *  <li>0x20: 10^3</li>
     * </ul>
     */
    int value() const { return _value;};

  };


private:
  CardData _ef_id;

  string _cmdReadRecord;
  CTError _openCard();


public:
  /** @name Constructors/Destructor
   *
   */
  //@{
  /**
   *
   */
  CTGeldKarte(const CTCard &c);

  virtual ~CTGeldKarte();
  //@}

  /** @name Opening and closing operations
   *
   * Methods to connect and disconnect the card. Most other methods
   * only work if the card is open.
   */
  //@{
  /**
   * When this method is called normally the card is already opened by
   * means of @ref openCard(). However, it is likely that openCard() has
   * been called assuming this card is only a CTCard() object, nothing
   * special. You may then call THIS method here on all known card classes
   * to check for the type of this card.
   * This method must assume that any file on the card is already selected,
   * so it is in most cases a good idea to select the MF as the first action
   * of this method.
   * If the executing class finds that the card inserted is not of a type
   * it can handle then it MUST return an error.
   */
  virtual CTError reopenCard();
  //@}

  /** @name Informational methods
   *
   * These methods tell you about the type and the status of the card.
   */
  //@{
  /**
   * This method returns a short name of the class which handles this card.
   * A HBCI card for example returns "HBCICard". So you can use this method
   * to check for the type of the card.
   */
  virtual string cardType();

  /**
   * This method returns a comma separated list of all card types this card
   * inherits including the type of this card, e.g. a HBCI card would
   * return "CTProcessorCard, HBCICard". If you overload this method in your
   * own class (you SHOULD) you simply have to call this method of the
   * class it directly inherits. That class will then do the same, so that
   * there is a list upon return.
   */
  virtual string cardTypes();
  //@}

  /** @name Opening and closing operations
   *
   * Methods to connect and disconnect the card. Most other methods
   * only work if the card is open.
   */
  //@{
  /**
   * Opens the card for usage.
   * This way the card is powered on.
   * This method does some basic checks and retrieves basic information
   * about the card (whether it is a memory card or a processor card,
   * the size of the memory etc).
   * When this method successfully returns the card may be used.
   * @author Martin Preuss<martin@libchipcard.de>
   * @return CTError object that holds the result (call isOk() to see if
   * there was an error)
   */
  virtual CTError openCard();
  // @}

  const CardData &cardData() const { return _ef_id;};

  /**
   * Returns the amount of money loaded onto the card.
   * This value is adapted according to the setting in EF_ID, so you may
   * use this value returned directly. The currency is stored in the
   * CardData object which you can get via @ref cardData().
   */
  double readLoadedValue();

  /**
   * Returns the maximum amount of money which can be stored on this card.
   * Please see @ref readLoadedValue() for details.
   */
  double readMaxLoadedValue();

  /**
   * Returns the maximum amount of money which can be transfered in one
   * setting with this card.
   * Please see @ref readLoadedValue() for details.
   */
  double readMaxTransactionValue();

};




#endif



