/***************************************************************************
 *   Copyright (C) 2003 by Miguel Revilla Rodrguez                        *
 *   yo@miguelrevilla.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
 
#include "libcdg123.h"
 
int cdgTileBlockXOR(struct cdgStream *stream, struct cdgTileBlockStruct *data) {
 
	int row,column ;
	int color0, color1 ;
	int i,j ;
	int tmprow ;
	int colorvalue ;
	
	row = data->row & SC_ROW_MASK ;
	column = data->column & SC_COLUMN_MASK ;
	
	color0 = data->color0 & SC_COLOR_MASK ;
	color1 = data->color1 & SC_COLOR_MASK ;
	
	for(i=0; i<12; i++) {
		tmprow = data->tilePixels[i] ;
		for(j=5; j>=0; j--) {
			colorvalue = tmprow % 2 ? color1 : color0 ; 
			stream->pixelMatrix[(row*CDG_FRAMEWIDTH*12)+(column*6)+j+(i*CDG_FRAMEWIDTH)] ^= colorvalue ;
			tmprow = tmprow >> 1 ;
		}
	}
	
	return 0 ;
}
