/*-------------------------------------------------------------------------------

Copyright (c) 2001 CerebraSoft

Module Name:

	eventLog.cpp

Abstract:

	NT event log related functions

License:

   All rights reserved.

   This product includes software developed at The Center for
   Networking and Distributed Systems at The Johns Hopkins University
   for use in the Backhand project (http://www.cnds.jhu.edu/backhand).
     Creator: Theo Schlossnagle 
     Guidance: Yair Amir

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer. 
 
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
 
  3. All advertising materials mentioning features or use of this
     software must display the following acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  4. The names "Backhand Broadcaster" and "NT Backhand Broadcaster" must
     not be used to endorse or promote products derived from this
     software without prior written permission. For written permission,
     please contact www.cerebrasoft.com.
 
  5. Products derived from this software may not be called "Backhand Broadcaster"
     or "NT Backhand Broadcaster" nor may "Backhand Broadcaster" or
     "NT Backhand Broadcaster" appear in their names without prior written
     permission. For written permission, please contact www.cerebrasoft.com.
 
  6. Redistributions of any form whatsoever must retain the following
     acknowledgment:
     "This product includes software developed by Cerebrasoft
     (http://www.cerebrasoft.com).
        Creator: Rob Butler"

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
  ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
  OF THE POSSIBILITY OF SUCH DAMAGE.

---------------------------------------------------------------------------------*/

#include <windows.h>			// needed for all sorts of things
#include "eventLog.h"			// header for this file

/*-------------------------------------------------------------------------------

bool logAppMsg(char *appName, WORD type, char *msg)

	writes message to NT application event log.
	returns true if successful, false otherwise

	appName - Application name
	type - type of event
	msg - message to be logged
---------------------------------------------------------------------------------*/

bool logAppMsg(char *appName, WORD type, char *msg){

	HANDLE eventSource = RegisterEventSource(NULL, appName);
	const char **msgArr = (const char**) &msg;
	DWORD msgType;

	switch(type){
		case EVENTLOG_ERROR_TYPE: 
			msgType = AppErrMsg;
			break;
		case EVENTLOG_WARNING_TYPE:
			msgType = AppWarnMsg;
			break;
		case EVENTLOG_INFORMATION_TYPE:
			msgType = AppInfoMsg;
			break;
		default:
			msgType = AppSuccessMsg;
			break;
	}
	if(eventSource != NULL){
		ReportEvent(eventSource, type, 0, msgType, NULL, 1, 0, msgArr, NULL);
		DeregisterEventSource(eventSource);
		return true;
	}
	return false;
}

/*-------------------------------------------------------------------------------

bool logAppMsg(char *appName, WORD type, int numMsgs, ...)

	writes message to NT application event log.
	returns true if successful, false otherwise

	appName - Application name
	type - type of event
	numMsgs - number of messages to be logged.
	... - NULL terminated strings to be logged
---------------------------------------------------------------------------------*/

bool logAppMsg(char *appName, WORD type, int numMsgs, ...){

	va_list pList;
	DWORD len = 0;
	char *tmp = NULL;
	int i;

	va_start(pList, numMsgs);

		// calculate string length
	for(i = 0; i < numMsgs; i++){
		tmp = va_arg(pList, char *);
		if(tmp != NULL)
			len += strlen(tmp); 
	}

	char *msg = (char*) malloc(len + 1);

	if(msg == NULL)
		return false;

	va_start(pList, numMsgs);	// restart

	msg[0] = NULL; //(need to terminate non-existant string)

		// concatonate all strings
	for(i = 0; i < numMsgs; i++){
		tmp = va_arg(pList, char *);
		if(tmp != NULL)
			strcat(msg, tmp);
	}

	return logAppMsg(appName, type, msg);

}