/***************************************************************************
                          dataDir.cpp  -  description
                             -------------------
    begin                : Sam M� 1 2003
    copyright            : (C) 2003 by Andr Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "datadir.h"

using namespace std;

bool DataDir::searchDataDir(const string &userDefinedDir){
#ifndef _WIN32

  bool found = false;
  //falls kein Datenverzeichnis angegeben, startIndex auf 1 setzen
  int searchStartIndex=(userDefinedDir.empty());

  string possibleDirs[] ={ userDefinedDir,
                         #ifdef CUSTOM_INSTALL_DIR
                           CUSTOM_INSTALL_DIR,
                         #endif
                           "/usr/share/highlight/"
                         };

  for (int i=searchStartIndex;i<
       #ifdef CUSTOM_INSTALL_DIR
       3
       #else
       2
       #endif
       ;i++)
    {
      if (fileExists(possibleDirs[i]))
        {
          dataDir=possibleDirs[i];
          found = true;
        }
      if (found) {
       break;
      }
      else {
        if (!searchStartIndex)
         cerr << "highlight: directory "
              << userDefinedDir
              << " specified by data-dir option not found.\n"
              << "           Searching another standard directory.\n";

      }
    }
  return found;
#else
  dataDir=userDefinedDir;
  return true;
#endif

}

DataDir::DataDir()
{
}

void DataDir::setAdditionalDataDir(const string& dir){
  additionalDataDir=dir;
}

const string &DataDir::getDir()
{
  return dataDir;
}

const string DataDir::getLangDefDir()
{
  return dataDir+"langDefs"+Platform::pathSeparator;
}

const string DataDir::getThemeDir()
{
  return dataDir+"themes"+Platform::pathSeparator;
}

const string DataDir::getIndentSchemesDir()
{
  return dataDir+"indentSchemes"+Platform::pathSeparator;
}


const string DataDir::getAdditionalLangDefDir()
{
  return additionalDataDir+"langDefs"+Platform::pathSeparator;
}

const string DataDir::getAdditionalThemeDir()
{
  return additionalDataDir+"themes"+Platform::pathSeparator;
}
const string DataDir::getAdditionalIndentSchemesDir()
{
  return additionalDataDir+"indentSchemes"+Platform::pathSeparator;
}


const string DataDir::getHelpMsgDir()
{
  return dataDir+"helpmsg"+Platform::pathSeparator;
}

const string DataDir::searchForLangDef(const string & langDef){
    if (!additionalDataDir.empty()){
       string path=getAdditionalLangDefDir()+langDef;
       if (fileExists(path)){
          return path;
       }
    }
    return getLangDefDir()+langDef;
}

const string DataDir::searchForTheme(const string & theme){
    if (!additionalDataDir.empty()){
       string path=getAdditionalThemeDir()+theme;
       if (fileExists(path)){
          return path;
       }
    }
    return getThemeDir()+theme;
}

const string DataDir::searchForIndentScheme(const string & scheme){
    if (!additionalDataDir.empty()){
       string path=getAdditionalIndentSchemesDir()+scheme;
       if (fileExists(path)){
          return path;
       }
    }
    return getIndentSchemesDir()+scheme;
}


bool DataDir::fileExists(const string&f){
  ifstream file(f.c_str());
  bool exists=!file.fail();
  file.close();
  return exists;
}
