// Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
// 
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://cs.unibo.it/~lpadovan/mml-widget, or send a mail to
// <luca.padovani@cs.unibo.it>

#include <config.h>
#include <assert.h>
#include <stddef.h>

#include "MathEngine.hh"
#include "MathMLDocument.hh"
#include "DocumentElement.hh"

#if defined(HAVE_MINIDOM)
MathMLDocument::MathMLDocument(mDOMDocRef doc)
#elif defined(HAVE_GMETADOM)
MathMLDocument::MathMLDocument(const GMetaDOM::Document& doc)
#endif
  : MathMLContainerElement(0)
  , DOMdoc(doc)
{
  assert(doc != 0);
}

MathMLDocument::~MathMLDocument()
{
  DOMdoc = 0;
}

void
MathMLDocument::Normalize()
{
  if (content.GetSize() == 0 || content.GetSize() > 1) {
    DocumentElement* doc = new DocumentElement(NULL);
    doc->SetParent(this);
    while (content.GetSize() > 0) {
      MathMLElement* elem = content.RemoveFirst();
      elem->SetParent(doc);
      doc->content.Append(elem);
    }
    content.Append(doc);
  } 

  MathMLContainerElement::Normalize();
}

MathMLElement*
MathMLDocument::GetRoot(void) const
{
  assert(content.GetSize() == 1);
  assert(content.GetFirst() != NULL);
  return content.GetFirst();
}

bool
MathMLDocument::IsDocument() const
{
  return true;
}
