/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <gnome.h>
#include <libbonobo.h>
#include <libbonoboui.h>

#include <libxklavier/xklavier_config.h>

#include "xkb_capplet.h"

static void XkbCappletPreviewUnrealized( GtkWidget * bonoboWindow,
                                         XkbCapplet * gswic )
{
  XklDebug( 150, "UNREALIZED\n" );
  g_object_set_data( G_OBJECT( gswic->capplet ),
                     PREVIEW_BONOBO_WINDOW_PROPERTY, NULL );
}

static void XkbCappletPreviewRealized( GtkWidget * bonoboWidget,
                                       XkbCapplet * gswic )
{
  GtkWidget *bonoboWindow;
  XklDebug( 150, "REALIZED\n" );
  bonoboWindow =
    GTK_WIDGET( g_object_get_data
                ( G_OBJECT( gswic->capplet ),
                  PREVIEW_BONOBO_WINDOW_PROPERTY ) );

  bonobo_control_frame_control_activate( bonobo_widget_get_control_frame
                                         ( BONOBO_WIDGET( bonoboWidget ) ) );
}

gboolean XkbCappletIsPreviewAvailable( void )
{
  Bonobo_ServerInfoList *servers =
    bonobo_activation_query( "repo_ids.has('IDL:Bonobo/Control:1.0') "
                             " AND bonobo:supported_mime_types.has('application/postscript')",
                             NULL, NULL );
  return ( servers != NULL && ( servers->_length > 0 ) );
}

void XkbCappletPreviewClicked( GtkButton * button, XkbCapplet * gswic )
{
  gpointer bw;
  GtkWidget *bonoboWindow;
  char *home = getenv( "HOME" );
  char psFileMoniker[PATH_MAX + 6];
  Bool dumpResult;
  GtkWidget *newChild;
  BonoboControlFrame *frame;
  BonoboUIContainer *uiContainer;

  if( !XkbCappletIsPreviewAvailable(  ) )
  {
    GtkWidget *msg = gtk_message_dialog_new( NULL,
                                             GTK_DIALOG_MODAL,
                                             GTK_MESSAGE_ERROR,
                                             GTK_BUTTONS_CLOSE,
                                             _
                                             ( "Postscript preview component is not available" ) );
    gtk_dialog_run( GTK_DIALOG( msg ) );
    gtk_widget_destroy( msg );
    return;
  }
  g_snprintf( psFileMoniker, sizeof( psFileMoniker ),
              "file:/%s/.gnome_private/xkbpreview.ps", home );
  XkbCappletUpdateConfigFromGui( gswic );
  dumpResult = GSwitchItXkbConfigDumpSettings( &gswic->xkbConfig, psFileMoniker + 6 );  // just skip the prefix
  if( !dumpResult )
  {
    XkbCappletActivationError( GTK_WINDOW( gswic->capplet ) );
    return;
  }

  bw =
    g_object_get_data( G_OBJECT( gswic->capplet ),
                       PREVIEW_BONOBO_WINDOW_PROPERTY );
  if( bw == NULL )
  {
    // New bonobo window
    XklDebug( 150, "Creating new bonobo window\n" );
    bonoboWindow =
      bonobo_window_new( "Preview", _( "Keyboard layout preview" ) );
    g_object_set_data( G_OBJECT( gswic->capplet ),
                       PREVIEW_BONOBO_WINDOW_PROPERTY, bonoboWindow );

    gtk_window_resize( GTK_WINDOW( bonoboWindow ), 400, 400 );
    g_signal_connect( G_OBJECT( bonoboWindow ), "unrealize",
                      G_CALLBACK( XkbCappletPreviewUnrealized ), gswic );

    gtk_window_set_transient_for( GTK_WINDOW( bonoboWindow ),
                                  GTK_WINDOW( gswic->capplet ) );
    gtk_window_set_destroy_with_parent( GTK_WINDOW( bonoboWindow ), TRUE );
    uiContainer =
      bonobo_window_get_ui_container( BONOBO_WINDOW( bonoboWindow ) );
  } else
  {
    BonoboUIEngine *uiEngine;
    // Existing bonobo window
    XklDebug( 150, "Reusing existing bonobo window\n" );
    bonoboWindow = GTK_WIDGET( bw );
    bonobo_window_set_contents( BONOBO_WINDOW( bonoboWindow ), NULL );
    uiContainer = bonobo_ui_container_new(  );
    uiEngine = bonobo_window_get_ui_engine( BONOBO_WINDOW( bonoboWindow ) );
    bonobo_ui_container_set_engine( uiContainer, uiEngine );
  }

  newChild =
    bonobo_widget_new_control( psFileMoniker, BONOBO_OBJREF( uiContainer ) );
  //bonobo_widget_new_control( "file://archive/Docs/dsohowto.pdf", BONOBO_OBJREF( uiContainer ) );

  if( newChild == NULL )
  {
    GtkWidget *msg = gtk_message_dialog_new( NULL,
                                             GTK_DIALOG_MODAL,
                                             GTK_MESSAGE_ERROR,
                                             GTK_BUTTONS_CLOSE,
                                             _( "Bonobo Error" ) );
    gtk_dialog_run( GTK_DIALOG( msg ) );
    gtk_widget_destroy( msg );

    g_object_set_data( G_OBJECT( gswic->capplet ),
                       PREVIEW_BONOBO_WINDOW_PROPERTY, NULL );
    gtk_widget_destroy( bonoboWindow );
    return;
  }

  g_signal_connect( G_OBJECT( newChild ), "realize",
                    G_CALLBACK( XkbCappletPreviewRealized ), gswic );
  bonobo_window_set_contents( BONOBO_WINDOW( bonoboWindow ), newChild );
  gtk_widget_show_all( bonoboWindow );

  gtk_window_present( GTK_WINDOW( bonoboWindow ) );
}
