#!/usr/bin/python
#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""Print Yes if SSH public keys from launchpad are available locally."""

# Import standard python libs
import sys
import getpass
from GroundControl.launchpadweb import LaunchpadWeb

import locale
locale.setlocale(locale.LC_ALL, '')
import gettext
gettext.install("groundcontrol")

if __name__ == '__main__':
    myself = LaunchpadWeb()
    password = getpass.getpass(_("New Password: "))
    passcheck = getpass.getpass(_("Confirm Password: "))
    if password == passcheck:
        myself.genSshKey(password)
    else:
        print _("Passwords didn't match!")
    sys.exit(0)
