
#include <ctype.h>
#include "strutil.h"

const char *
left_trimmed (const char * s)
{
  const char * p;

  for (p = s; *p != 0 && isspace (*p); p++);

  return p;
}

void
trim_right (char * s)
{
  char * p;
  char * herep;
  enum { BLANKS, NONBLANKS } state = NONBLANKS;

  for (herep = 0, p = s; *p != 0; p++)
    {
      switch (state)
        {
        case BLANKS:
          if (!isspace (*p))
            state = NONBLANKS;
          break;
        case NONBLANKS:
          if (isspace (*p))
            {
              herep = p;
              state = BLANKS;
            }
        }
    }
  if (state == BLANKS)
    *herep = 0;
}

#ifdef TESTMAIN

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void
printout (const char * s)
{
  printf("\"%s\"\n", s);
}

int
main (void)
{
  static const char * teststrings [] = { 
    "autoksiko",
    " autoksiko",
    "autoksiko ",
    " autoksiko ",
    "autoksiko           teen",
    "         autoksiko  teen",
    "autoksiko teen          ",
    "      autoksiko teen    ",
    " miljoona miljoona ruusua ",
    0 };
  int i;

  for (i = 0; teststrings [i] != 0; i++)
    {
      char * ts;
      char * orig_ts;

      orig_ts = ts = strdup (teststrings [i]);
      if (ts == 0)
        exit (EXIT_FAILURE);

      printf ("Plain: ");
      printout (ts);

      printf ("Left-trimmed: ");
      printout (left_trimmed (ts));

      printf ("Right-trimmed: ");
      trim_right (ts);
      printout (ts);

      printf ("Completely trimmed: ");
      printout (left_trimmed (ts));

      puts ("");
      free (orig_ts);
    }
  return 0;
}
#endif /* TESTMAIN */
