/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  callbacks.c: Some misc. GUI callbacks for Gnome Predict.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <math.h>
#include "satdata.h"  /* needs to be included before engine.h - go figure... */
#include "engine.h"
#include "timeout.h"
#include "satlog.h"
#include "satprint.h"
#include "callbacks.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

extern GtkWidget *app;

/* dummy callback */
gint a_callback (GtkWidget *button, gpointer data)
{
	satlog_log (SAT_LOG_INFO, _("Pressed button does not work yet."));
	return 0;
}


gint not_finished (GtkWidget *widget, gpointer data)
{
	gnome_app_message (GNOME_APP (app),
			   _("This code is not finished. Please contact the\n"\
		           "project administrator if you wish to contribute."));
	return 0;
}



/* Function to stop the tracking of satellites in gpredict.
   The predict server will continue tracking, but the client
   will stop sending queries about satellite data. */
void timer_stop_callback (GtkWidget *widget, gpointer data)
{
	gnome_app_flash (GNOME_APP (app), _("Tracking engine stopped"));
	//satlist_timer_stop ();
	engine_stop ();
	/* add more functions here when available */
}

/* Function to resume tracking of satellites. */
void timer_start_callback (GtkWidget *widget, gpointer data)
{
	gnome_app_flash (GNOME_APP (app), _("Tracking engine started"));
	//satlist_timer_start ();
	engine_start ();
}

/* Server info button/menuitem pressed */
void server_info_callback ()
{

}

/* Print the main Sat List             */
void print_main_satlist (GtkWidget *widget, gpointer data)
{
#ifdef HAVE_GNOME_PRINT
  gnome_app_flash (GNOME_APP (app), _("Printing Satellite list"));
  sat_print_current();
#endif
}

/*** About callback  ***/
void about_callback (GtkWidget *widget, gpointer data)
{
	const gchar *authors[] = {
		"Alexandru Csete, <csete@users.sourceforge.net>.",
		"Ran Hadary, <hadary@users.sourceforge.net>.",
		"John Magliacane, <kd2bd@amsat.org>.",
		NULL
	};
	GtkWidget *about,*hbox,*home,*proj;
	GtkTooltips *kooltip;
	gchar *tmp=NULL;

/*	tmp = g_strconcat (PACKAGE_PIXMAPS_DIR,"/gpredict-logo.png", NULL);*/
	about = gnome_about_new ("Gnome Predict", VERSION,
				 "(C) 2001-2003  Alexandru Csete",
				 (const gchar **) authors,
				 _("Gnome Predict is a real-time satellite tracking "\
				   "program based on Predict's tracking engine. Gnome "\
				   "Predict is licensed under the GNU General Public "\
				   "License (GPL)."),
				 tmp );
	/* URL link buttons */
	home = gnome_href_new ("http://groundstation.sourceforge.net/",
			       _("Gnome Predict Home Page"));
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltip, home,
			      _("General info about the Groundstation Software Suite "\
				"including other software modules and references."),
			      NULL);
	proj = gnome_href_new ("http://sourceforge.net/projects/groundstation/",
			       _("Gnome Predict Project Page"));
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltip, proj,
			      _("Coordination of the development of the Groundstation "\
				"Software Suite including bug trackers, discussion "\
				"forums and feature request trackers."),
			      NULL);
	/* hbox */
	hbox = gtk_hbox_new (TRUE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), home, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), proj, FALSE, FALSE, 0);

	/* add to About Box */
	gtk_box_pack_start_defaults (GTK_BOX (GNOME_DIALOG (about)->vbox), hbox);

	gtk_widget_show_all (about);
/*	g_free (tmp);*/
}
