require 'mkmf'

libs = [["X11", "XOpenDisplay"], ["Xi", "XOpenDevice"],
        ["Xext", "XextFindDisplay"], ["Xmu", "XmuInternAtom"]]
funcs = ["g_print", "gtk_init", "applet_widget_init"]

libs.each do |lib|
  dir_config(lib[0])
end

config_cmd = with_config('gnome-config', 'gnome-config')
rbgtk_dir = with_config("ruby-gtk", File.dirname(__FILE__)+"/../gtk")

unless FileTest.exist?(rbgtk_dir)
  raise "directry #{rbgtk_dir} not found.  Please specify Ruby-GTK source dir."
end

rbgnome_dir = with_config("ruby-gnome", File.dirname(__FILE__)+"/../gnome")
unless FileTest.exist?(rbgnome_dir)
  raise "directry #{rbgnome_dir} not found.  Please specify Ruby-GNOME source dir."
end

$CFLAGS += " -I#{rbgtk_dir}/src -I#{rbgnome_dir}/src " + `#{config_cmd} --cflags applets`.chomp
$libs += " " + `#{config_cmd} --libs applets`.chomp

libs.each do |lib|
  unless have_library(*lib)
    puts "\n***"
    puts "Could not find lib#{lib[0]}."
    puts "You can specify its path using --with-#{lib[0]}-lib=/path/"
    exit
  end
end

funcs.each do |func|
  unless have_func(func)
    puts "\n***"
    puts "Could not find #{func}."
    exit
  end
end

create_makefile('panel_applet')
