require 'mkmf'

rubygtk_dir = "../gtk"
rubygtk_dir = ARGV[0] if ARGV[0]
unless FileTest.exist?(rubygtk_dir)
  raise "directry #{rubygtk_dir} not found.  Please specify Ruby/Gtk source dir."
end
gtklib_dir = []
`gtk-config --libs`.split(' ').each do |e|
  if e=~ /^-L/ then
    gtklib_dir.push(e)
  end
end

$CFLAGS = "-I#{rubygtk_dir}/src " + `gdk-pixbuf-config --cflags`.chomp
$LDFLAGS = `gdk-pixbuf-config --libs`.chomp

have_library("X11", "XOpenDisplay") &&
have_library("Xi", "XOpenDevice") &&
have_library("Xext", "XextFindDisplay") &&
have_library("Xmu", "XmuInternAtom") &&
have_library("glib", "g_print") &&
have_library("gdk", "gdk_init") &&
have_library("gdk_pixbuf", "gdk_pixbuf_new") &&

create_makefile('gdk_pixbuf')
