% FUNCTION F=gf_precond(name_of_preconditioner, args)
% The preconditioners may store REAL or COMPLEX values. They accept
%  getfem sparse matrices and Matlab sparse matrices.
% 
%   * gf_precond('identity')
%     Create a REAL identity precondioner.
%  * gf_precond('cidentity')
%     Create a COMPLEX identity precondioner.
%  * gf_precond('diagonal', vec D)
%     Create a diagonal precondioner.
%  * gf_precond('ildlt', Spmat m)
%     Create an ILDLT (Cholesky) preconditioner for the (symmetric)
%     sparse matrix `m`. This preconditioner has the same sparsity
%     pattern than `m` (no fill-in).
%  * gf_precond('ilu', Spmat m)
%     Create an ILU (Incomplete LU) preconditioner for the sparse
%     matrix `m`. This preconditioner has the same sparsity pattern
%     than `m` (no fill-in).
%  * gf_precond('ildltt', Spmat m[, int fillin[, scalar threshold]])
%     Create an ILDLT (Cholesky with filling) preconditioner for the
%     (symmetric) sparse matrix `m`. The preconditioner may add at most
%     `fillin` additional non-zero entries on each line. The default
%     value for `fillin` is 10, and the default threshold is1e-7.
%  * gf_precond('ilut', Spmat m[, int fillin[, scalar threshold]])
%     Create an ILUT (Incomplete LU with filling) preconditioner for the
%     sparse matrix `m`. The preconditioner may add at most `fillin`
%     additional non-zero entries on each line. The default value for
%     `fillin` is 10, and the default threshold is 1e-7.
%  * gf_precond('superlu', Spmat m)
%     Uses SuperLU to build an exact factorization of the sparse matrix
%     `m`. This preconditioner is only available if the getfem-interface
%     was built with SuperLU support. Note that LU factorization is likely
%     to eat all your memory for 3D problems. * gf_precond('spmat', Spmat M)
%     ???
function [varargout]=gf_precond(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('precond',varargin{:});
  else
    gf_matlab('precond',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
