% FUNCTION [x] = gf_mesh_fem_set(meshfem MF, operation [, args])
% 
%   General function for modifying mesh_fem objects.
% 
%   * gf_mesh_fem_set(MF,'fem,'Fem f[, ivec CVids])
%   Set the Finite Element Method.  Assign a FEM `f` to all convexes whose #ids
%   are listed in `CVids`. If `CVids` is not given, the integration is assigned to
%   all convexes.  See the help of gf_fem to obtain a list of available FEM
%   methods.
% 
%   * gf_mesh_fem_set(MF,'classical_fem,'int k[, ivec CVids])
%   Assign a classical (Lagrange polynomial) fem of order `k` to the MeshFem.
%   Uses FEM_PK for simplexes, FEM_QK for parallelepipeds etc.
% 
%   * gf_mesh_fem_set(MF,'classical_discontinuous_fem,'int K, [int IM_DEGREE [,ivec
%   CVIDX]])
%   Assigns a classical (Lagrange polynomial) discontinuous fem or order K.
%   Similar to gf_mesh_fem_set(MF,'classical_fem') except that
%   FEM_PK_DISCONTINUOUS is used.
% 
%   * gf_mesh_fem_set(MF,'qdim,'int Q)
%   Change the `Q` dimension of the field that is interpolated by the MeshFem.  `Q
%   = 1` means that the MeshFem describes a scalar field, `Q = N` means that the
%   MeshFem describes a vector field of dimension N.
% 
%   * gf_mesh_fem_set(MF,'reduction,'int s)
%   Set or unset the use of the reduction/extension matrices.
% 
%   * gf_mesh_fem_set(MF,'reduction_matrices,'mat R,mat E)
%   Set the reduction and extension matrices and valid their use.
% 
%   * gf_mesh_fem_set(MF,'dof_partition,'ivec DOFP)
%   Change the 'dof_partition' array.  `DOFP` is a vector holding a integer value
%   for each convex of the MeshFem. See gf_mesh_fem_get(MF,'dof_partition') for a
%   description of "dof partition".
% 
% 
%   $Id: gf_mesh_fem_set.cc 3008 2009-05-16 14:08:01Z renard $
function [varargout]=gf_mesh_fem_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem_set',varargin{:});
  else
    gf_matlab('mesh_fem_set',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
