% FUNCTION M = gf_mdstate('complex' | 'real')
%   General constructor for mdstate objects. Return a getfem handle to the newly
%   created object.
% 
%   ``Model State'' variables store the state data for a set of model
%   bricks. This includes the global tangent matrix, the right hand side
%   and the constraints. There are two sorts of model states, the
%   ``real'' and the ``complex'' models states.
% 
%   * MDS=gf_model_state(mdbrick B)
%   Build a modelstate for the brick B (selects the real or
%   complex state from the complexity of B).
% 
%   * MDS = gf_mdstate('real')
%   Build a model state for real unknowns.
% 
%   * MDS = gf_mdstate('complex')
%   Build a model state for complex unknowns.
% 
% 
%   $Id: gf_mdstate.cc 2869 2009-01-08 01:12:35Z lsaavedr $
function [varargout]=gf_mdstate(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdstate',varargin{:});
  else
    gf_matlab('mdstate',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
