% FUNCTION I = gf_cvstruct_get(cs, ...)
%     General function for querying information about convex_structure objects.
% 
%   * n = gf_cvstruct_get(CVS,'nbpts')
%   Get the number of points of the convex structure.
% 
%   * d = gf_cvstruct_get(CVS,'dim')
%   Get the dimension of the convex structure.
% 
%   * cs = gf_cvstruct_get(CVS,'basic_structure')
%   Get the simplest convex structure.  For example, the 'basic structure' of the
%   6-node triangle, is the canonical 3-noded triangle.
% 
%   * cs = gf_cvstruct_get(CVS,'face',int F)
%   Return the convex structure of the face `F`.
% 
%   * I = gf_cvstruct_get(CVS,'facepts',int F)
%   Return the list of point indices for the face `F`.
% 
function [varargout]=gf_cvstruct_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('cvstruct_get',varargin{:});
  else
    gf_matlab('cvstruct_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
