/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007-2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#ifndef CRON_FUNCTIONS_H
#define CRON_FUNCTIONS_H

gchar *sanitize_backup_name(gchar *backup_name);
gchar *mk_backup_script_path(gchar *backup_name);
gchar *mk_backup_at_shutdown_script_path(gchar *backup_name);
gchar *mk_restore_script_path();
gchar *mk_log_path(gchar *backup_name);
gchar *mk_extended_log_path(gchar *backup_name);

void add_to_system_shutdown(gchar *backup_name);
void remove_from_system_shutdown(gchar *backup_name);

void schedule_cron(gchar *cron_line, gchar *backup_name);
void add_cron(gchar *cron_line, gchar *script_path);
void del_cron(gchar *script_path);

#endif
