/****************************************************************************
                            Hyper's CD Catalog
	A multiplatform qt and xml based catalog program
 
Author    : Christoph Thielecke <crissi99@gmx.de>
License   : GPL
Copyright : (C) 2003 Christoph Thielecke
****************************************************************************/


#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qmessagebox.h>
#include <qtextstream.h>
#include <qapplication.h>
#include <qstring.h>
#include <qregexp.h>
#include <iostream>

#include "icons.h"
#include "cdcat.h"
#include "exportcdcatdb.h"
#include "adddialog.h"

using namespace std;

/*
 *  Constructs a exportCdcatDB as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
exportCdcatDB::exportCdcatDB( QApplication *appp,DataBase *db, QWidget* parent, const char* name, bool modal, WFlags fl ) : QDialog( parent, name, modal, fl ) 
{
	p = db;
	app = appp;
	pww = NULL;

	if ( !name )
		setName( "exportCdcatDB" );
	setSizeGripEnabled( TRUE );

	this->setCaption( tr ("Export database..."));

	exportCdcatDBLayout = new QGridLayout( this, 1, 1, 12, 6, "exportCdcatDBLayout" );

	layout32 = new QVBoxLayout( 0, 0, 6, "layout32" );
	layout21 = new QHBoxLayout( 0, 0, 6, "layout21" );
	layout10_2 = new QVBoxLayout( 0, 0, 6, "layout10_2" );
	textLabel2 = new QLabel( this, "textLabel2" );
	layout10_2->addWidget( textLabel2 );

	listAllMedia = new QListBox( this, "listAllMedia" );
	listAllMedia->setSelectionMode( QListBox::Extended );

	layout10_2->addWidget( listAllMedia );
	layout21->addLayout( layout10_2 );

	layout19 = new QVBoxLayout( 0, 0, 6, "layout19" );
	QSpacerItem* spacer = new QSpacerItem( 20, 180, QSizePolicy::Minimum, QSizePolicy::Expanding );
	layout19->addItem( spacer );

	layout10 = new QHBoxLayout( 0, 0, 6, "layout10" );

	buttonRemove = new QPushButton( this, "buttonRemove" );
	buttonRemove->setMinimumSize( QSize( 50, 23 ) );
	buttonRemove->setMaximumSize( QSize( 50, 23 ) );
	buttonRemove->setPixmap( *get_t_remove_export_icon() );
	layout10->addWidget( buttonRemove );

	buttonAdd = new QPushButton( this, "buttonAdd" );
	buttonAdd->setMinimumSize( QSize( 50, 23 ) );
	buttonAdd->setMaximumSize( QSize( 50, 23 ) );
	buttonAdd->setPixmap( *get_t_add_export_icon() );
	layout10->addWidget( buttonAdd );
	layout19->addLayout( layout10 );
	QSpacerItem* spacer_2 = new QSpacerItem( 20, 210, QSizePolicy::Minimum, QSizePolicy::Expanding );
	layout19->addItem( spacer_2 );
	layout21->addLayout( layout19 );

	layout10_2_2 = new QVBoxLayout( 0, 0, 6, "layout10_2_2" );

	textLabel2_2 = new QLabel( this, "textLabel2_2" );
	layout10_2_2->addWidget( textLabel2_2 );

	listSelectedMedia = new QListBox( this, "listSelectedMedia" );
	listSelectedMedia->setSelectionMode( QListBox::Extended );
	layout10_2_2->addWidget( listSelectedMedia );
	layout21->addLayout( layout10_2_2 );
	layout32->addLayout( layout21 );

	layout27 = new QHBoxLayout(0,0,4,"layout27");

	checkAllMedia = new QCheckBox( this, "checkAllMedia" );
	layout27->addWidget( checkAllMedia );
	
	layout32->addLayout( layout27 );

	buttonGroup1 = new QButtonGroup( 3, Qt::Horizontal, tr("Type"),this, "buttonGroup1" );
	layout26 = new QHBoxLayout( 0, 0, 6, "layout26" );

	radioCsv = new QRadioButton( buttonGroup1, "radioCsv" );

	seperatorLabel = new QLabel( buttonGroup1, "seperatorLabel" );

	separatorInput = new QLineEdit( buttonGroup1, "separatorInput" );

	separatorInput->setMaximumSize( QSize( 25, 32767 ) );

	radioHtml = new QRadioButton( buttonGroup1, "radioHtml" );
	layout26->addWidget( radioHtml );

	checkOnlyMediaName = new QCheckBox( buttonGroup1, "checkOnlyMediaName");

	seperatorLabel->setAlignment(Qt::AlignRight);

	QSpacerItem* spacer_4 = new QSpacerItem( 130, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout26->addItem( spacer_4 );

	layout32->addWidget( buttonGroup1 );

	buttonGroupFields = new QButtonGroup(2, Qt::Horizontal,tr( "What to export") ,this,"buttonGroupFields");

	checkExportTitle = new QCheckBox(buttonGroupFields,"checkExportTitle");
	buttonGroupFields->insert(checkExportTitle);

	checkExportTableHeader	= new QCheckBox(buttonGroupFields,"checkExportTableHeader");
	buttonGroupFields->insert(checkExportTableHeader);

	checkExportMediaName = new	QCheckBox(buttonGroupFields,"checkExportMediaName");
	buttonGroupFields->insert(checkExportMediaName);

	checkExportPath = new QCheckBox(buttonGroupFields,"checkExportPath");
	buttonGroupFields->insert(checkExportPath);


	checkExportSize = new QCheckBox(buttonGroupFields,"checkExportSize");
	buttonGroupFields->insert(checkExportSize);

	checkExportDate = new QCheckBox(buttonGroupFields,"checkExportDate");
	buttonGroupFields->insert(checkExportDate);

	checkExportComment = new QCheckBox(buttonGroupFields,"checkExportComment");
	buttonGroupFields->insert(checkExportComment);

	layout32->addWidget( buttonGroupFields );

	layout29 = new QHBoxLayout( 0, 0, 6, "layout29" );

	textLabel3 = new QLabel( this, "textLabel3" );
	layout29->addWidget( textLabel3 );

	fileName = new QLineEdit( this, "fileName" );
	layout29->addWidget( fileName );

	buttonFile = new QPushButton( this, "buttonFile" );
	layout29->addWidget( buttonFile );
	layout32->addLayout( layout29 );

	layout4 = new QHBoxLayout( 0, 0, 6, "layout4" );
	QSpacerItem* spacer_6 = new QSpacerItem( 163, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout4->addItem( spacer_6 );

	buttonOk = new QPushButton( this, "buttonOk" );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	layout4->addWidget( buttonOk );

	buttonCancel = new QPushButton( this, "buttonCancel" );
	buttonCancel->setAutoDefault( TRUE );
	layout4->addWidget( buttonCancel );
	QSpacerItem* spacer_5 = new QSpacerItem( 163, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout4->addItem( spacer_5 );
	layout32->addLayout( layout4 );

	exportCdcatDBLayout->addLayout( layout32, 0, 0 );
	languageChange();
	resize( QSize( 418, 389 ).expandedTo( minimumSizeHint() ) );
	clearWState( WState_Polished );

	// signals and slots connections
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( ok() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( cancel() ) );
	connect( buttonAdd, SIGNAL( clicked() ), this, SLOT( addMedia() ) );
	connect( buttonRemove, SIGNAL( clicked() ), this, SLOT( removeMedia() ) );
	connect( checkAllMedia, SIGNAL( toggled( bool ) ), this, SLOT( listAllMediaToggled() ) );
	connect( buttonFile, SIGNAL( clicked() ), this, SLOT ( browseFile() ) );
	connect( radioCsv, SIGNAL ( clicked() ), this, SLOT ( exportTypeToggled() ) );
	connect( radioHtml, SIGNAL ( clicked() ), this, SLOT ( exportTypeToggled() ) );

	connect( checkOnlyMediaName, SIGNAL ( clicked() ), this, SLOT ( checkOnlyMediaNameToggled() ) );

	connect( checkExportTitle, SIGNAL (clicked()), this, SLOT (checkExportToggled()));
	connect( checkExportTableHeader, SIGNAL (clicked()), this, SLOT (checkExportToggled()));
	connect( checkExportMediaName, SIGNAL (clicked()), this, SLOT (checkExportToggled()));
	connect( checkExportPath, SIGNAL (clicked()), this, SLOT (checkExportToggled()));
	connect( checkExportSize, SIGNAL (clicked()), this, SLOT (checkExportToggled()));
	connect( checkExportDate, SIGNAL (clicked()), this, SLOT (checkExportToggled()));
	connect( checkExportComment, SIGNAL (clicked()), this, SLOT (checkExportToggled()));

	separatorInput->setText( ";" );
	separatorInput->setEnabled(false);
	seperatorLabel->setEnabled(false);
	radioHtml->setChecked( true );

#ifndef _WIN32

	if (p != NULL)
		fileName->setText(QString(getenv( "HOME" ))+"/"+QString((( DBCatalog * ) (( p->getRootNode())->data))->name)+".html");
#endif

	checkOnlyMediaName->setChecked( false );

	checkExportTableHeader->setChecked(true);
	checkExportTitle->setChecked(true);
	checkExportMediaName->setChecked(true);
	checkExportPath->setChecked(true);
	checkExportSize->setChecked(true);
	checkExportDate->setChecked(true);
	checkExportComment->setChecked(true);



	outstring = "";
	medianame = "";
	currentpath = "";
	lastMedianame="";
	out1 = NULL;
	out2 = NULL;
	out3 = NULL;
	out4 = NULL;
	out5 = NULL;

	fillMedia();
}

/*
 *  Destroys the object and frees any allocated resources
 */
exportCdcatDB::~exportCdcatDB() {
	// no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void exportCdcatDB::languageChange() {
	
	textLabel2->setText( tr( "Availiable media" ) );
	QToolTip::add
		( listAllMedia, tr( "Add media" ) );
	buttonRemove->setText( QString::null );
	QToolTip::add
		( buttonRemove, tr( "Remove media" ) );
	buttonAdd->setText( QString::null );
	QToolTip::add
		( buttonAdd, tr( "Add media" ) );
	textLabel2_2->setText( tr( "Media to export" ) );
	QToolTip::add
		( listSelectedMedia, tr( "Media to export" ) );
	checkAllMedia->setText( tr( "All media" ) );
	checkOnlyMediaName->setText( tr( "Only media name" ) );
	//spinColsLabel->setText( tr( "columns:" ) );
	buttonGroup1->setTitle( tr( "Type" ) );
	radioHtml->setText( tr( "export as HTML" ) );
	radioCsv->setText( tr( "export as CSV" ) );

	seperatorLabel->setText( tr( "separator:" ) );
	textLabel3->setText( tr( "File to export:" ) );
	buttonFile->setText( tr( "..." ) );
	buttonOk->setText( tr( "&OK" ) );
	checkExportMediaName->setText( tr( "Media name" ) );
	checkExportPath->setText( tr( "Path" ) );
	//	checkExportFile->setText( tr( "export file" ) );
	checkExportSize->setText( tr( "Size" ) );
	checkExportDate->setText( tr( "Date" ) );
	checkExportComment->setText( tr( "Comment" ) );
	//	checkExportMp3Tag->setText( tr( "export mp3 tag" ) );
	checkExportTitle->setText( tr( "HTML headline" ) );
	checkExportTableHeader->setText( tr("table header"));

#ifndef _WIN32

	buttonOk->setAccel( QKeySequence( QString::null ) );
#endif

	buttonCancel->setText( tr( "&Cancel" ) );

#ifndef _WIN32

	buttonCancel->setAccel( QKeySequence( QString::null ) );
#endif
}

void exportCdcatDB::fillMedia() {
	if ( p == NULL ) {
		buttonOk ->setEnabled( false );
		;
		listAllMedia ->setEnabled( false );
		listSelectedMedia->setEnabled( false );
		buttonAdd->setEnabled( false );
		buttonRemove ->setEnabled( false );
		buttonFile ->setEnabled( false );
		fileName ->setEnabled( false );
		checkAllMedia->setEnabled( false );
		return ;
	}
	Node *source = p->getRootNode();
	setCaption( tr( "Export CdCat database: " ) + ( ( DBCatalog * ) ( source->data ) ) ->name );
	Node *tmp;
	tmp = source->child;

	while ( tmp != NULL ) {
		if ( tmp->type != HC_MEDIA ) {
			tmp = tmp->next;
			continue;
		}

		this->listAllMedia->insertItem( QString( tmp->getNameOf() ) );
		tmp = tmp->next;
	}

	listAllMedia->sort();
}

bool exportCdcatDB::doHtmlExport() {
	//fileName->setText("/data/test.html");
	return true;
}

bool exportCdcatDB::doCsvExport() {
	//fileName->setText("/data/test.txt");
	return true;
}

void exportCdcatDB::ok() 
{
	/* === header === */
	if ( radioHtml->isChecked() ) {
		outstring += "<html>\n";
		outstring += " <!-- This file was generated by CdCat ";
		outstring += HOMEPAGE;
		outstring += " -->\n";
		outstring += "<head>\n";
		outstring += "<title> "+ tr( "Export from cdcat:" ) + " " + ( ( DBCatalog * ) ( ( p->getRootNode() ) ->data ) ) ->name + "</title>\n";
		outstring += "<style>\n";	// we're gonna define style for our html document		
		outstring += ".m { color: red; }\n"; // m - media
		outstring += ".f { color: blue; }\n"; // f - file
		outstring += ".d { color: green; }\n"; // d - date
		outstring += ".c { color: darkgray; }\n"; // c - comment	
		outstring += "table { border-collapse: collapse; }"; // extremely usefull table feature, 
		// this causes table border to collapse into 1px wide border
		// and there is no need 4 putting "&nbsp;" instead " " (space) to display empty cells correcty
		//  (in mozilla/ie.. konqueror does seem to handle this)
		outstring += "</style>\n";		

		outstring += "</head>\n";
		outstring += "<body>\n";
		if (checkExportTitle->isChecked())
			outstring += "<h1>" + tr( "Export from cdcat:" ) + " " + ( ( DBCatalog * ) ( ( p->getRootNode() ) ->data ) ) ->name + "</h1>\n";

		outstring += "<table border=\"1\">";
		if (checkExportTableHeader->isChecked()) {
			if (!checkOnlyMediaName->isChecked()) {
				outstring += "<tr>";
				if( checkExportMediaName->isChecked())
					outstring += "<th>" + tr( "Media" ) + "</th>";
				if( checkExportPath->isChecked())
					outstring += "<th>" + tr( "File" )+ "</th>";
				;
				if( checkExportSize->isChecked())
					outstring += "<th>" + tr( "Size" ) + "</th>";
				if( checkExportDate->isChecked())
					outstring += "<th>" + tr( "Date" ) + "</th>";
				if( checkExportComment->isChecked())
					outstring += "<th>" + tr( "Comment" ) + "</th>";

				outstring += "</tr>\n";
			} else {
				outstring += "<tr><td><strong>" + tr( "Media" ) + "</strong></td></tr>\n";
			}
		}

	}
	if ( radioCsv->isChecked() ) {}
        
	/* header end */

	if ( ( fileName->text() ).isEmpty() )
		QMessageBox::critical( 0, tr( "Filename missing" ), tr( "Please enter a filename!" ) );
	else if ( ( separatorInput->text() ).isEmpty() )
		QMessageBox::critical( 0, tr( "Separator missing" ), tr( "Please enter a separator!" ) );
	else {
		//QApplication::setOverrideCursor( waitCursor );

		separator = separatorInput->text();

		/*extension correction:*/
		if ( radioHtml->isChecked() &&
		        !( ( ( fileName->text() ).right( 5 ) ).lower() == ".html" ||
		           ( ( fileName->text() ).right( 4 ) ).lower() == ".htm" ) ) {
			QString q( fileName->text() );
			fileName->setText( q.append( ".html" ) );
		}

		if ( radioCsv->isChecked() &&
		        ( ( fileName->text() ).right( 4 ) ).lower() != ".csv" ) {
			QString q( fileName->text() );
			fileName->setText( q.append( ".csv" ) );
		}


		f.setName( fileName->text() );

		int overwrite=0;
		if (f.exists()) {
			//QApplication::restoreOverrideCursor();
			QMessageBox mb( tr("Overwrite?"),
			                tr("Do you want overwrite this file?"),
			                QMessageBox::Critical,
			                QMessageBox::Yes,
			                QMessageBox::Cancel | QMessageBox::Escape | QMessageBox::Default,
			                0 );
			mb.setButtonText( QMessageBox::Yes, tr("Yes") );
			mb.setButtonText( QMessageBox::Cancel, tr("Discard") );
			overwrite = mb.exec();
		}
		
		
		pww = new PWw(this,app);
		progress(pww);

		if (!f.exists() || overwrite == QMessageBox::Yes) {
			//QApplication::setOverrideCursor( waitCursor );
			if ( f.open( IO_WriteOnly ) ) {
				QTextStream str( &f );    // we will serialize the data into file f
				str.setEncoding( QTextStream::Latin1 );
				//str << " # output generated by cdcat" << endl;
				writeDown( p->getRootNode() );

				/* === footer === */
				if ( radioHtml->isChecked() )
					outstring += "</table></body></html>";

				/* footer end */

				str << outstring;
				f.close();

				//QApplication::restoreOverrideCursor();

			} else {
				//QApplication::restoreOverrideCursor();
				QMessageBox::critical( 0, tr( "Error during write config..." ), tr( "I can't create or rewrite the file" ), tr( "Ok" ), 0 );
			}
			close();
		} else {
			//QApplication::restoreOverrideCursor();
		}
	}

  pww->end();
  delete pww;
}

void exportCdcatDB::cancel() 
{
	close();
}

void exportCdcatDB::addMedia() 
{
	uint i;
	for ( i = 0; i < listAllMedia->count();i++ )
		if ( listAllMedia->isSelected( i ) )
			listSelectedMedia->insertItem( listAllMedia->text( i ) );


	for ( i = 0; i < listAllMedia->count();i++ )
		while ( i < listAllMedia->count() && listAllMedia->isSelected( i ) )
			listAllMedia->removeItem( i );
	listAllMedia->sort();
	listSelectedMedia->sort();

}

void exportCdcatDB::removeMedia() 
{
	uint i;
	for ( i = 0; i < listSelectedMedia->count();i++ )
		if ( listSelectedMedia->isSelected( i ) )
			listAllMedia->insertItem( listSelectedMedia->text( i ) );


	for ( i = 0; i < listSelectedMedia->count();i++ )
		while ( i < listSelectedMedia->count() && listSelectedMedia->isSelected( i ) )
			listSelectedMedia->removeItem( i );
	listAllMedia->sort();
	listSelectedMedia->sort();

}

void exportCdcatDB::browseFile() 
{
	QString s;
	s = QFileDialog::getSaveFileName( QString::null, tr( "All files (*.*)" ), this,
	                                  tr( "file chooser" ), tr( "Choose a file!" ) );
	if ( !s.isEmpty() )
		fileName->setText( s );
}

int exportCdcatDB::writeDown( Node *source ) 
{
	int i = 0;
	progress(pww);
	switch ( source->type ) {
	case HC_UNINITIALIZED:
		return 1;
	case HC_CATALOG:
		i = writeCatalog( source );
		break;
	case HC_MEDIA:
		i = writeMedia( source );
		break;
	case HC_DIRECTORY:
		i = writeDirectory( source );
		break;
	case HC_FILE:
		i = writeFile( source );
		break;
	case HC_MP3TAG:
		i = writeMp3Tag( source );
		break;
	}
	return i;
}

int exportCdcatDB::writeCatalog( Node *source ) 
{

	if ( source->child != NULL )
		writeDown( source->child );

	if ( source->next != NULL )
		writeDown( source->next );

	return 0;
}

int exportCdcatDB::writeMedia( Node *source ) 
 {
    
	bool inList = false;
	medianame = QString( recode( ( ( DBMedia * ) ( source->data ) ) ->name , &out1 ) );


	if (checkAllMedia->isChecked()) 
	      inList = true;
	else 
		// need to check if in listSelectedMedia
		for ( uint i = 0; i < listSelectedMedia->count();i++ ) 
			if ( listSelectedMedia->text( i ) == medianame ) 
			 {
				inList = true;
				break;
			 }


	if (radioHtml->isChecked() && checkOnlyMediaName->isChecked())
	 {
	   if ( inList ) 
	      outstring += "<tr><td class=\"m\">" + medianame + "</td></tr>";  
         }	      
        else
 	    if ( inList ) 
		if ( source->child != NULL )
			writeDown( source->child );


	if ( source->next != NULL )
		writeDown( source->next );

	return 0;
}

int exportCdcatDB::writeDirectory( Node *source ) 
{
	if ( source->child != NULL )
		writeDown( source->child );

	if ( source->next != NULL )
		writeDown( source->next );

	return 0;
}

int exportCdcatDB::writeFile( Node *source ) 
 {
   double tsize=0;

   //==== CSV ===========
   if ( radioCsv->isChecked())
     {
     	   outstring += medianame + getFilePath( source );
	   outstring += separator;
   
           tsize = ( ( DBFile * ) ( source->data ) ) ->size;
	   switch( ( ( DBFile * ) ( source->data ) ) ->sizeType )
	    {
	     case 0:                            break;
	     case 1:  tsize *= 1024;            break;	     
	     case 2:  tsize *= 1024*1024;       break;	     
	     case 3:  tsize *= 1024*1024*1024;  break;	     
	    }
	   
	   outstring += QString().setNum( (long int)tsize );
	   outstring += separator;
	   outstring += QString( recode( ( ( DBFile * ) ( source->data ) ) ->modification, &out3 ) );
           outstring += "\n";  
     }
     
   //==== HTML ===========
   if ( radioHtml->isChecked())     
     {
	   outstring += "<tr>";  

	      //======== items ==========		   
                if (checkExportMediaName->isChecked())
  		      outstring += "<td class=\"m\">" + medianame + "</td>";  
		
		if (checkExportPath->isChecked()) 
		      outstring += "<td class=\"f\">" + getFilePath( source ) + "</td>";

		if (checkExportSize->isChecked()) 
		{
	              outstring += "<td>";
                      outstring += QString().setNum( ( ( DBFile * ) ( source->data ) ) ->size );
		      outstring +=" ";
		      outstring += QString( getSType( ( ( ( DBFile * ) ( source->data ) ) ->sizeType ) ) );
                      outstring += "</td>";
		}

		if (checkExportDate->isChecked()) 
		{
		      outstring += "<td class=\"d\">";
                      outstring += QString( recode( ( ( DBFile * ) ( source->data ) ) ->modification, &out3 ) );
                      outstring += "</td>";
		}

		if (checkExportComment->isChecked() ) 
		{
		         
                      outstring += "<td class=\"c\">";
		      if(((DBFile*)(source->data))->comment != NULL)
                        outstring += QString((( DBFile * ) ( source->data ) )->comment)
			                       .replace(QRegExp("#"),"\n");
		      else
		       	outstring += "";
		      outstring += "</td>";
		}

	   outstring += "</tr>";  
     }
  
  
	if ( source->child != NULL )
		writeDown( source->child );

	if ( ( ( DBFile * ) ( source->data ) ) ->prop != NULL )
		writeDown( ( ( DBFile * ) ( source->data ) ) ->prop );

	if ( source->next != NULL )
		writeDown( source->next );

	return 0;
}

int exportCdcatDB::writeMp3Tag( Node* ) 
{
	return 0;
}

QString exportCdcatDB::getFilePath( Node *current ) 
{

	Node * up = current;
	QString a( "" );
	if ( up != NULL ) {
		while ( up != NULL && QString( up->getNameOf() ) != medianame ) {
			a.prepend( up->getNameOf() );
			a.prepend( "/" );
			up = up->parent;
		}
	}
	return a;

}

void exportCdcatDB::checkExportToggled() 
{
	if (!checkExportTitle->isChecked() && !checkExportTableHeader->isChecked() && !checkExportPath->isChecked() &&
	        !checkExportMediaName->isChecked() && !checkExportDate->isChecked() && !checkExportSize->isChecked() && !checkExportComment->isChecked()) {
		buttonOk->setEnabled(false);
	} else {
		buttonOk->setEnabled(true);
	}

}


void exportCdcatDB::listAllMediaToggled() 
{
	if ( checkAllMedia->isChecked() ) {
		listAllMedia->setEnabled( false );
		listSelectedMedia->setEnabled( false );
		buttonAdd->setEnabled( false );
		buttonRemove->setEnabled( false );
	} else {
		listAllMedia->setEnabled( true );
		listSelectedMedia->setEnabled( true );
		buttonAdd->setEnabled( true );
		buttonRemove->setEnabled( true );
	}
}

void exportCdcatDB::exportTypeToggled() 
{
	if (radioHtml->isChecked()) 
	 {
		seperatorLabel->setEnabled( false );
		separatorInput->setEnabled( false );
	
		checkOnlyMediaName->setEnabled( true );

		checkExportTitle->setEnabled( true );;
		checkExportTableHeader->setEnabled( true );;
		checkExportMediaName->setEnabled(true);
		checkExportPath->setEnabled(true);
		checkExportDate->setEnabled(true);
		checkExportSize->setEnabled(true);
		checkExportComment->setEnabled(true);
		checkOnlyMediaNameToggled();
#ifndef _WIN32
		if (p != NULL)
			fileName->setText(QString(getenv( "HOME" ))+"/"+QString((( DBCatalog * ) (( p->getRootNode())->data))->name)+".html");
#endif

         }

        if (radioCsv->isChecked()) 
	 {
	        seperatorLabel->setEnabled( true );
		separatorInput->setEnabled( true );
		checkOnlyMediaName->setEnabled( false );

    		checkExportTitle->setEnabled( false );
		checkExportTableHeader->setEnabled( false );
		checkExportMediaName->setEnabled(false);
		checkExportPath->setEnabled(false);
		checkExportDate->setEnabled(false);
		checkExportSize->setEnabled(false);
		checkExportComment->setEnabled(false);
#ifndef _WIN32

		if (p != NULL)
			fileName->setText(QString(getenv( "HOME" ))+"/"+QString((( DBCatalog * ) (( p->getRootNode())->data))->name)+".csv");
#endif

	 }
}

void exportCdcatDB::checkOnlyMediaNameToggled() {
	if (checkOnlyMediaName->isChecked() && radioHtml->isChecked()) {

		checkExportMediaName->setEnabled(false);
		checkExportPath->setEnabled(false);
		checkExportDate->setEnabled(false);
		checkExportSize->setEnabled(false);
		checkExportComment->setEnabled(false);

	} else {

		checkExportMediaName->setEnabled(true);
		checkExportPath->setEnabled(true);
		checkExportDate->setEnabled(true);
		checkExportSize->setEnabled(true);
		checkExportComment->setEnabled(true);
	}
}
