;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/type.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan  8 08:52:32 1995                          */
;*    Last change :  Thu May 17 06:33:39 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type description                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __type
   
   (use __error
	__bigloo
	__tvector
	__ucs2
	__unicode
	__r4_numbers_6_5_fixnum
	__r4_booleans_6_1
	__r4_characters_6_6
	__r4_pairs_and_lists_6_3
	__r4_vectors_6_8
	__r4_numbers_6_5_flonum
	__r4_symbols_6_4
	__r4_strings_6_7
	__evenv)
   
   (type
    ;; all type declaration
    
    (magic magic "obj_t" bigloo)
    (magic _     "_"     bigloo)
    
    ;; we start by the obj hierarchy
    (obj     "obj_t" bigloo)
    (cnst*   "obj_t" bigloo)
    
    (subtype procedure    "obj_t"           (obj))
    (subtype pair         "obj_t"           (obj))
    (subtype epair        "obj_t"           (obj))
    (subtype nil          "obj_t"           (obj))
    ;; There is a relationship that exists between pair-nil, nil and
    ;; pair which is nil > pair-nil and pair > pair-nil. This has introduced
    ;; a bug into one compiler optimization that attempts to statically
    ;; reduce runtime type check. I have not been able to find a better
    ;; solution than to hard code this relation into the compiler.
    ;; @ref ../../comptime/Reduce/typec.scm:pair-nil subtyping@
    ;; @label pair-nil subtyping@
    (subtype pair-nil     "obj_t"           (obj))
    (subtype bint         "obj_t"           (obj))
    (subtype blong        "obj_t"           (obj))
    (subtype belong       "obj_t"           (obj))
    (subtype bllong       "obj_t"           (obj))
    (subtype bbool        "obj_t"           (obj))
    (subtype cnst         "obj_t"           (obj))
    (subtype bstring      "obj_t"           (obj))
    (subtype ucs2string   "obj_t"           (obj))
    (subtype bchar        "obj_t"           (obj))
    (subtype bucs2        "obj_t"           (obj))
    (subtype real         "obj_t"           (obj))
    (subtype vector       "obj_t"           (obj))
    (subtype tvector      "obj_t"           (obj))
    (subtype struct       "obj_t"           (obj))
    (subtype tstruct      "obj_t"           (obj))
    (subtype output-port  "obj_t"           (obj))
    (subtype input-port   "obj_t"           (obj))
    (subtype binary-port  "obj_t"           (obj))
    (subtype unspecified  "obj_t"           (obj))
    (subtype symbol       "obj_t"           (obj))
    (subtype keyword      "obj_t"           (obj))
    (subtype cell         "obj_t"           (obj))
    (subtype exit         "obj_t"           (obj))
    (subtype foreign      "obj_t"           (obj))
    (subtype process      "obj_t"           (obj))
    (subtype socket       "obj_t"           (obj))
    (subtype custom       "obj_t"           (obj))
    (subtype opaque       "obj_t"           (obj))
    
    ;; we give now the foreign hierarchy
    (cobj "long" C)
    (subtype char         "char"            (cobj))
    (subtype ucs2         "ucs2_t"          (cobj))
    (subtype uchar        "unsigned char"   (cobj))
    (subtype schar        "signed char"     (cobj))
    (subtype short        "short"           (cobj))
    (subtype ushort       "unsigned short"  (cobj))
    (subtype int          "int"             (cobj))
    (subtype uint         "unsigned int"    (cobj))
    (subtype long         "long"            (cobj))
    (subtype llong        "long long"       (cobj))
    (subtype ulong        "unsigned long"   (cobj))
    (subtype bool         "bool_t"          (cobj))
    (subtype string       "char *"          (cobj))
    (subtype file         "FILE *"          (cobj))
    (subtype double       "double"          (cobj))
    (subtype float        "float"           (cobj))
    (subtype void         "void"            (cobj))
    (subtype void*        "void *"          (cobj))
    (subtype function     "(long *)()"      (cobj))
    
    ;; debugging traces (used by `the_failure')
    (trace "struct trace *" _)
    
    ;; obj -> magic
    (coerce obj magic          ()               ())
    
    ;; obj -> trace
    (coerce obj trace          ()               ())
    
    ;; first of all obj <-> cobj
    (coerce obj cobj           ()               (c-obj->cobj))
    (coerce cobj obj           ()               (cobj->obj))
    
    ;; unspecified <-> obj
    (coerce unspecified obj    ()               ())
    (coerce obj unspecified    ()               ((lambda (x) #unspecified)))
    
    ;; boolean types
    (coerce bbool obj          ()               ())
    (coerce obj bbool          (c-boolean?)     ())
    (coerce obj bool           ()               (obj->bool))
    
    (coerce cobj bool          ()               ())
    (coerce bool cobj          ()               ())
    
    (coerce bbool bool         ()               (bbool->bool))
    (coerce bool bbool         ()               (bool->bbool))
    
    ;; character types
    (coerce bchar obj          ()               ())
    (coerce obj bchar          (c-char?)        ())
    
    (coerce char bool          ()               ((lambda (x::char) #t)))
    (coerce uchar bool         ()               ((lambda (x::uchar) #t)))
    
    (coerce cobj char          ()               ())
    (coerce char cobj          ()               ())
    (coerce cobj uchar         ()               ())
    (coerce uchar cobj         ()               ())
    
    (coerce bchar char         ()               (bchar->char))
    (coerce char bchar         ()               (char->bchar))
    (coerce bchar uchar        ()               (bchar->uchar))
    (coerce uchar bchar        ()               (uchar->bchar))
    (coerce uchar char         ()               (uchar->char))
    (coerce char uchar         ()               (char->uchar))
    
    ;; ucs2 types
    (coerce bucs2 obj          ()               ())
    (coerce obj bucs2          (c-ucs2?)        ())
    
    (coerce ucs2 bool          ()               ((lambda (x::char) #t)))
    
    (coerce cobj ucs2          ()               ())
    (coerce ucs2 cobj          ()               ())
    (coerce bucs2 ucs2         ()               (bucs2->ucs2))
    (coerce ucs2 bucs2         ()               (ucs2->bucs2))
    
    ;; integer types
    (coerce bint obj           ()               ())
    (coerce obj bint           (c-fixnum?)      ())
    (coerce blong obj          ()               ())
    (coerce obj blong          (c-fixnum?)      ())
    
    (coerce belong obj         ()               ())
    (coerce obj belong         (c-elong?)       ())
    (coerce bllong obj         ()               ())
    (coerce obj bllong         (c-llong?)       ())
    
    (coerce cobj schar         ()               ())
    (coerce schar cobj         ()               ())
    (coerce cobj short         ()               ())
    (coerce short cobj         ()               ())
    (coerce cobj ushort        ()               ())
    (coerce ushort cobj        ()               ())
    (coerce cobj int           ()               ())
    (coerce int cobj           ()               ())
    (coerce cobj uint          ()               ())
    (coerce uint cobj          ()               ())
    (coerce cobj long          ()               ())
    (coerce long cobj          ()               ())
    (coerce cobj ulong         ()               ())
    (coerce ulong cobj         ()               ())
    
    (coerce cobj llong         ()               ())
    (coerce llong cobj         ()               ())
    (coerce long llong         ()               ())
    
    (coerce llong bllong       ()               (llong->bllong))
    (coerce bllong llong       ()               (bllong->llong))
    
    (coerce long magic         ()               (long->bint))
    
    (coerce schar bool         ()               ((lambda (x::schar) #t)))
    (coerce short bool         ()               ((lambda (x::short) #t)))
    (coerce ushort bool        ()               ((lambda (x::ushort) #t)))
    (coerce int bool           ()               ((lambda (x::int) #t)))
    (coerce uint bool          ()               ((lambda (x::uint) #t)))
    (coerce long bool          ()               ((lambda (x::long) #t)))
    (coerce ulong bool         ()               ((lambda (x::ulong) #t)))
    
    (coerce bint schar         ()               (bint->schar))
    (coerce bint char          ()               (bint->char))
    (coerce bint uchar         ()               (bint->uchar))
    (coerce bint short         ()               (bint->short))
    (coerce bint ushort        ()               (bint->ushort))
    (coerce bint int           ()               (bint->int))
    (coerce bint uint          ()               (bint->uint))
    (coerce bint long          ()               (bint->long))
    (coerce bint ulong         ()               (bint->ulong))
    
    (coerce blong schar        ()               (blong->schar))
    (coerce blong char         ()               (blong->char))
    (coerce blong uchar        ()               (blong->uchar))
    (coerce blong short        ()               (blong->short))
    (coerce blong ushort       ()               (blong->ushort))
    (coerce blong int          ()               (blong->int))
    (coerce blong uint         ()               (blong->uint))
    (coerce blong long         ()               (blong->long))
    
    (coerce schar bint         ()               (schar->bint))
    (coerce short bint         ()               (short->bint))
    (coerce ushort bint        ()               (ushort->bint))
    (coerce int bint           ()               (int->bint))
    (coerce uint bint          ()               (uint->bint))
    (coerce long bint          ()               (long->bint))
    (coerce ulong bint         ()               (ulong->bint))
    
    (coerce schar blong        ()               (schar->blong))
    (coerce short blong        ()               (short->blong))
    (coerce ushort blong       ()               (ushort->blong))
    (coerce int blong          ()               (int->blong))
    (coerce uint blong         ()               (uint->blong))
    (coerce long blong         ()               (long->blong))
    (coerce ulong blong        ()               (ulong->blong))
    
    (coerce schar short        ()               (schar->short))
    (coerce schar ushort       ()               (schar->ushort))
    (coerce schar int          ()               (schar->int))
    (coerce schar uint         ()               (schar->uint))
    (coerce schar long         ()               (schar->long))
    (coerce schar ulong        ()               (schar->ulong))
    
    (coerce short schar        ()               (short->schar))
    (coerce short ushort       ()               (short->ushort))
    (coerce short int          ()               (short->int))
    (coerce short uint         ()               (short->uint))
    (coerce short long         ()               (short->long))
    (coerce short ulong        ()               (short->ulong))
    
    (coerce ushort schar       ()               (ushort->schar))
    (coerce ushort short       ()               (ushort->short))
    (coerce ushort int         ()               (ushort->int))
    (coerce ushort uint        ()               (ushort->uint))
    (coerce ushort long        ()               (ushort->long))
    (coerce ushort ulong       ()               (ushort->ulong))
    
    (coerce int schar          ()               (int->schar))
    (coerce int short          ()               (int->short))
    (coerce int ushort         ()               (int->ushort))
    (coerce int uint           ()               (int->uint))
    (coerce int long           ()               (int->long))
    (coerce int ulong          ()               (int->ulong))
    
    (coerce uint schar         ()               (uint->schar))
    (coerce uint short         ()               (uint->short))
    (coerce uint ushort        ()               (uint->ushort))
    (coerce uint int           ()               (uint->int))
    (coerce uint long          ()               (uint->long))
    (coerce uint ulong         ()               (uint->ulong))
    
    (coerce long schar         ()               (long->schar))
    (coerce long char          ()               (long->char))
    (coerce long uchar         ()               (long->uchar))
    (coerce long short         ()               (long->short))
    (coerce long ushort        ()               (long->ushort))
    (coerce long int           ()               (long->int))
    (coerce long uint          ()               (long->uint))
    (coerce long ulong         ()               (long->ulong))
    
    (coerce ulong schar        ()               (ulong->schar))
    (coerce ulong char         ()               (ulong->char))
    (coerce ulong uchar        ()               (ulong->uchar))
    (coerce ulong short        ()               (ulong->short))
    (coerce ulong ushort       ()               (ulong->ushort))
    (coerce ulong int          ()               (ulong->int))
    (coerce ulong uint         ()               (ulong->uint))
    (coerce ulong long         ()               (ulong->long))
    
    ;; symbol <-> obj
    (coerce symbol obj         ()               ())
    (coerce obj symbol         (c-symbol?)      ())
    
    ;; keyword <-> obj
    (coerce keyword obj        ()               ())
    (coerce obj keyword        (c-keyword?)     ())
    
    ;; string -> cobj
    (coerce cobj string        ()               ())
    (coerce string cobj        ()               ())
    ;; bstring <-> obj
    (coerce string bool        ()               ((lambda (x::string) #t)))
    (coerce bstring obj        ()               ())
    (coerce obj bstring        (c-string?)      ())
    ;; bstring <-> string
    (coerce bstring string     ()               (bstring->string))
    (coerce string bstring     ()               (string->bstring))
    
    ;; ucs2string <-> obj
    (coerce ucs2string obj     ()               ())
    (coerce obj ucs2string     (c-ucs2-string?) ())
    
    ;; double -> cobj
    (coerce cobj double        ()               ())
    (coerce double cobj        ()               ())
    ;; real <-> obj
    (coerce double bool        ()               ((lambda (x::double) #t)))
    (coerce real obj           ()               ())
    (coerce obj real           (c-flonum?)      ())
    ;; real <-> double
    (coerce real double        ()               (real->double))
    (coerce double real        ()               (double->real))
    ;; float <-> double
    (coerce double float       ()               (double->float))
    (coerce float double       ()               (float->double))
    
    ;; real <-> obj
    (coerce float bool         ()               ((lambda (x::float) #t)))
    ;; float -> cobj
    (coerce cobj float         ()               ())
    (coerce float cobj         ()               ())
    ;; real <-> float
    (coerce real float         ()               (real->float))
    (coerce float real         ()               (float->real))
    
    ;; vector <-> obj
    (coerce vector obj         ()               ())
    (coerce obj vector         (c-vector?)      ())
    
    ;; tvector <-> obj
    (coerce tvector obj        ()               ())
    (coerce obj tvector        (c-tvector?)     ())
    
    ;; bool
    (coerce int bool           ()               ())
    
    ;; procedure
    (coerce procedure obj      ()               ())
    (coerce obj procedure      (c-procedure?)   ())
    
    ;; struct
    (coerce struct obj         ()               ())
    (coerce obj struct         (c-struct?)      ())
    
    ;; tstruct
    (coerce tstruct obj        ()               ())
    (coerce obj tstruct        (c-tstruct?)     ())
    
    ;; pair
    (coerce pair obj           ()               ())
    (coerce obj pair           (c-pair?)        ())
    
    (coerce epair obj          ()               ())
    (coerce obj epair          (c-epair?)       ())
    
    (coerce epair pair         ()               ())
    (coerce pair epair         (c-epair?)       ())
    
    ;; nil
    (coerce nil obj            ()               ())
    (coerce obj nil            (c-null?)        ())
    
    ;; pair-nil
    (coerce pair-nil obj       ()               ())
    (coerce obj pair-nil       (pair-or-null?)  ())
    
    (coerce pair-nil pair      (pair?)          ())
    (coerce pair pair-nil      ()               ())
    
    (coerce pair-nil epair     (epair?)         ())
    (coerce epair pair-nil     ()               ())
    
    (coerce pair-nil nil       (null?)          ())
    (coerce nil pair-nil       ()               ())
    
    ;; cell
    (coerce cell obj           ()               ())
    (coerce obj cell           ()               ())
    
    ;; exit
    (coerce exit obj           ()               ())
    (coerce obj exit           ()               ())
    
    ;; file <-> cobj
    (coerce file cobj          ()               ())
    (coerce cobj file          ()               ())
    
    ;; obj <-> input-port
    (coerce input-port obj     ()               ())
    (coerce obj input-port     (c-input-port?)  ())
    (coerce file input-port    ()               (file->input-port))
    
    ;; obj <-> output-port
    (coerce output-port obj    ()               ())
    (coerce obj output-port    (c-output-port?) ())
    (coerce file output-port   ()               (file->output-port))
    (coerce output-port file   ()               (output-port->file))
    
    ;; obj <-> binary-port
    (coerce binary-port obj    ()               ())
    (coerce obj binary-port    (c-binary-port?) ())
    (coerce binary-port file   ()               (binary-port->file))
    
    ;; void <-> cobj
    (coerce void cobj          ()               ())
    (coerce cobj void          ()               ())
    
    ;; void* <-> cobj
    (coerce void* cobj         ()               ())
    (coerce cobj void*         ()               ())
    (coerce void* obj          ()               (void*->obj))
    (coerce obj void*          (c-foreign?)     (obj->void*))
    
    ;; foreign <-> obj
    (coerce foreign obj        ()               ())
    (coerce obj foreign        (c-foreign?)     ())
    
    ;; process <-> obj
    (coerce process obj        ()               ())
    (coerce obj process        (c-process?)     ())
    
    ;; socket <-> obj
    (coerce socket obj         ()               ())
    (coerce obj socket         (c-socket?)      ())
    
    ;; custom <-> obj
    (coerce custom obj         ()               ())
    (coerce obj custom         (c-custom?)      ())
    
    ;; custom <-> obj
    (coerce opaque obj         ()               ())
    (coerce obj opaque         (c-opaque?)      ())
    
    ;; bool (all Bigloo's type have to be explicitly coerce to bool)
    (coerce procedure    bool  ()             ((lambda (x) #t)))
    (coerce bint         bool  ()             ((lambda (x) #t)))
    (coerce pair         bool  ()             ((lambda (x) #t)))
    (coerce epair        bool  ()             ((lambda (x) #t)))
    (coerce pair-nil     bool  ()             ((lambda (x) #t)))
    (coerce nil          bool  ()             ((lambda (x) #t)))
    (coerce cnst         bool  ()             ((lambda (x) #t)))
    (coerce bstring      bool  ()             ((lambda (x) #t)))
    (coerce ucs2string   bool  ()             ((lambda (x) #t)))
    (coerce real         bool  ()             ((lambda (x) #t)))
    (coerce tvector      bool  ()             ((lambda (x) #t)))
    (coerce vector       bool  ()             ((lambda (x) #t)))
    (coerce struct       bool  ()             ((lambda (x) #t)))
    (coerce tstruct      bool  ()             ((lambda (x) #t)))
    (coerce output-port  bool  ()             ((lambda (x) #t)))
    (coerce input-port   bool  ()             ((lambda (x) #t)))
    (coerce binary-port  bool  ()             ((lambda (x) #t)))
    (coerce symbol       bool  ()             ((lambda (x) #t)))
    (coerce keyword      bool  ()             ((lambda (x) #t)))
    (coerce cell         bool  ()             ((lambda (x) #t)))
    (coerce unspecified  bool  ()             ((lambda (x) #t)))
    (coerce bchar        bool  ()             ((lambda (x) #t)))
    (coerce bucs2        bool  ()             ((lambda (x) #t)))
    (coerce process      bool  ()             ((lambda (x) #t)))
    (coerce socket       bool  ()             ((lambda (x) #t)))
    (coerce custom       bool  ()             ((lambda (x) #t)))
    (coerce opaque       bool  ()             ((lambda (x) #t))))
   
   (extern
    (macro bool->bbool::bbool (::bool) "BBOOL")
    (macro obj->bool::bool (::obj) "CBOOL")
    (macro bbool->bool::bool (::bbool) "CBOOL")
    
    (macro schar->bint::bint (::schar) "BINT")
    (macro uchar->bint::bint (::uchar) "BINT")
    (macro short->bint::bint (::short) "BINT")
    (macro ushort->bint::bint (::ushort) "BINT")
    (macro int->bint::bint (::int) "BINT")
    (macro uint->bint::bint (::uint) "BINT")
    (macro long->bint::bint (::long) "BINT")
    (macro ulong->bint::bint (::ulong) "BINT")
    
    (macro schar->blong::blong (::schar) "BINT")
    (macro uchar->blong::blong (::uchar) "BINT")
    (macro short->blong::blong (::short) "BINT")
    (macro ushort->blong::blong (::ushort) "BINT")
    (macro int->blong::blong (::int) "BINT")
    (macro uint->blong::blong (::uint) "BINT")
    (macro long->blong::blong (::long) "BINT")
    (macro ulong->blong::blong (::ulong) "BINT")
    
    (macro bint->schar::schar (::bint) "(signed char)CINT")
    (macro bint->char::char (::bint) "(signed char)CINT")
    (macro bint->uchar::uchar (::bint) "(unsigned char)CINT")
    (macro bint->short::short (::bint) "(short)CINT")
    (macro bint->ushort::ushort (::bint) "(unsigned short)CINT")
    (macro bint->int::int (::bint) "CINT")
    (macro bint->uint::uint (::bint) "(unsigned int)CINT")
    (macro bint->long::long (::bint) "(long)CINT")
    (macro bint->ulong::ulong (::bint) "(unsigned long)CINT")
    
    (macro blong->schar::schar (::blong) "(signed char)CINT")
    (macro blong->char::char (::blong) "(signed char)CINT")
    (macro blong->uchar::uchar (::blong) "(unsigned char)CINT")
    (macro blong->short::short (::blong) "(short)CINT")
    (macro blong->ushort::ushort (::blong) "(unsigned short)CINT")
    (macro blong->int::int (::blong) "CINT")
    (macro blong->uint::uint (::blong) "(unsigned int)CINT")
    (macro blong->long::long (::blong) "(long)CINT")
    (macro blong->ulong::ulong (::blong) "(unsigned long)CINT")
    
    (macro uchar->short::short (::uchar) "(short)")
    (macro uchar->ushort::ushort (::uchar) "(unsigned short)")
    (macro uchar->int::int (::uchar) "(int)")
    (macro uchar->uint::uint (::uchar) "(unsigned int)")
    (macro uchar->long::long (::uchar) "(long)")
    (macro uchar->ulong::ulong (::uchar) "(unsigned long)")
    
    (macro schar->short::short (::schar) "(short)")
    (macro schar->ushort::ushort (::schar) "(unsigned short)")
    (macro schar->int::int (::schar) "(int)")
    (macro schar->uint::uint (::schar) "(unsigned int)")
    (macro schar->long::long (::schar) "(long)")
    (macro schar->ulong::ulong (::schar) "(unsigned long)")
    
    (macro short->schar::schar (::short) "(signed char)")
    (macro short->ushort::ushort (::short) "(unsigned short)")
    (macro short->int::int (::short) "(int)")
    (macro short->uint::uint (::short) "(unsigned int)")
    (macro short->long::long (::short) "(long)")
    (macro short->ulong::ulong (::short) "(unsigned long)")
    
    (macro ushort->schar::schar (::ushort) "(signed char)")
    (macro ushort->short::short (::ushort) "(short)")
    (macro ushort->int::int (::ushort) "(int)")
    (macro ushort->uint::uint (::ushort) "(unsigned int)")
    (macro ushort->long::long (::ushort) "(long)")
    (macro ushort->ulong::ulong (::ushort) "(unsigned long)")
    
    (macro int->schar::schar (::int) "(signed char)")
    (macro int->short::short (::int) "(short)")
    (macro int->ushort::ushort (::int) "(unsigned short)")
    (macro int->uint::uint (::int) "(unsigned int)")
    (macro int->long::long (::int) "(long)")
    (macro int->ulong::ulong (::int) "(unsigned long)")
    
    (macro uint->schar::schar (::uint) "(signed char)")
    (macro uint->short::short (::uint) "(short)")
    (macro uint->ushort::ushort (::uint) "(unsigned short)")
    (macro uint->int::uint (::uint) "(int)")
    (macro uint->long::long (::uint) "(long)")
    (macro uint->ulong::ulong (::uint) "(unsigned long)")
    
    (macro long->schar::schar (::long) "(signed char)")
    (macro long->char::char (::long) "(signed char)")
    (macro long->uchar::uchar (::long) "(unsigned char)")
    (macro long->short::short (::long) "(short)")
    (macro long->ushort::ushort (::long) "(unsigned short)")
    (macro long->int::int (::long) "(int)")
    (macro long->uint::uint (::long) "(unsigned int)")
    (macro long->ulong::ulong (::long) "(unsigned long)")
    
    (macro ulong->schar::schar (::ulong) "(signed char)")
    (macro ulong->char::char (::ulong) "(signed char)")
    (macro ulong->uchar::uchar (::ulong) "(unsigned char)")
    (macro ulong->short::short (::ulong) "(short)")
    (macro ulong->ushort::ushort (::ulong) "(unsigned short)")
    (macro ulong->int::int (::ulong) "(int)")
    (macro ulong->uint::uint (::ulong) "(unsigned int)")
    (macro ulong->long::long (::ulong) "(long)")
    
    (string->bstring::bstring (::string) "string_to_bstring")
    (macro bstring->string::string (::bstring) "BSTRING_TO_STRING")
    
    (macro char->bchar::bchar (::char) "BCHAR")
    (macro uchar->bchar::bchar (::uchar) "BCHAR")
    (macro bchar->char::char (::bchar) "CCHAR")
    (macro bchar->uchar::uchar (::bchar) "(unsigned char)CCHAR")
    (macro double->real::real (::double) "DOUBLE_TO_REAL")
    (macro real->double::double (::real) "REAL_TO_DOUBLE")
    (macro float->real::real (::float) "FLOAT_TO_REAL")
    (macro real->float::float (::real) "REAL_TO_FLOAT")
    (macro double->float::float (::double) "(float)")
    (macro float->double::double (::float) "(double)")
    
    (macro ucs2->bucs2::bucs2 (::ucs2) "BUCS2")
    (macro bucs2->ucs2::ucs2 (::bucs2) "CUCS2")
    
    (macro output-port->file::file (::output-port) "OUTPUT_PORT_TO_FILE")
    (macro file->output-port::output-port (::file) "FILE_TO_OUTPUT_PORT")
    
    (file->input-port::input-port (::file) "file_to_input_port")
    
    (macro binary-port->file::file (::binary-port) "BINARY_PORT_TO_FILE")
    
    (macro cobj->obj::obj (::cobj) "(obj_t)")
    (macro c-obj->cobj::cobj (::obj) "obj_to_cobj")
    
    (macro uchar->char::char (::uchar) "(char)")
    (macro char->uchar::uchar (::char) "(unsigned char)")
    
    (macro belong->long::long (::belong) "BELONG_TO_LONG")
    (macro long->belong::belong (::long) "LONG_TO_BELONG")
    (macro bllong->llong::llong (::bllong) "BLLONG_TO_LLONG")
    (macro llong->bllong::bllong (::llong) "LLONG_TO_BLLONG")
    (macro long->bllong::bllong (::long) "LONG_TO_BLLONG")
    (macro long->llong::llong (long) "LONG_TO_LLONG")
    
    (macro obj->void*::cobj (::foreign) "FOREIGN_TO_COBJ")
    (void*->obj::foreign (::void*) "void_star_to_obj"))
   
   (java
    (abstract-class foreign
       (method static bool->bbool::bbool (::bool) "BBOOL")
       (method static obj->bool::bool (::obj) "CBOOL")
       (method static bbool->bool::bool (::bbool) "CBOOL")
       
       (method static schar->bint::bint (::schar) "BINT")
       (method static uchar->bint::bint (::uchar) "BINT")
       (method static short->bint::bint (::short) "BINT")
       (method static ushort->bint::bint (::ushort) "BINT")
       (method static int->bint::bint (::int) "BINT")
       (method static uint->bint::bint (::uint) "BINT")
       (method static long->bint::bint (::long) "BINT")
       (method static ulong->bint::bint (::ulong) "BINT")
       
       (method static schar->blong::blong (::schar) "BINT")
       (method static uchar->blong::blong (::uchar) "BINT")
       (method static short->blong::blong (::short) "BINT")
       (method static ushort->blong::blong (::ushort) "BINT")
       (method static int->blong::blong (::int) "BINT")
       (method static uint->blong::blong (::uint) "BINT")
       (method static long->blong::blong (::long) "BINT")
       (method static ulong->blong::blong (::ulong) "BINT")
       
       (method static bint->schar::schar (::bint) "BINT_TO_SCHAR")
       (method static bint->char::char (::bint) "BINT_TO_CHAR")
       (method static bint->uchar::uchar (::bint) "BINT_TO_UCHAR")
       (method static bint->short::short (::bint) "BINT_TO_SHORT")
       (method static bint->ushort::ushort (::bint) "BINT_TO_USHORT")
       (method static bint->int::int (::bint) "CINT")
       (method static bint->uint::uint (::bint) "BINT_TO_UINT")
       (method static bint->long::long (::bint) "BINT_TO_LONG")
       (method static bint->ulong::ulong (::bint) "BINT_TO_ULONG")
       
       (method static blong->schar::schar (::blong) "BLONG_TO_SCHAR")
       (method static blong->char::char (::blong) "BLONG_TO_CHAR")
       (method static blong->uchar::uchar (::blong) "BLONG_TO_UCHAR")
       (method static blong->short::short (::blong) "BLONG_TO_SHORT")
       (method static blong->ushort::ushort (::blong) "BLONG_TO_USHORT")
       (method static blong->int::int (::blong) "CINT")
       (method static blong->uint::uint (::blong) "BLONG_TO_UINT")
       (method static blong->long::long (::blong) "BLONG_TO_LONG")
       (method static blong->ulong::ulong (::blong) "BLONG_TO_ULONG")
       
       (method static uchar->short::short (::uchar) "UCHAR_TO_SHORT")
       (method static uchar->ushort::ushort (::uchar) "UCHAR_TO_USHORT")
       (method static uchar->int::int (::uchar) "UCHAR_TO_INT")
       (method static uchar->uint::uint (::uchar) "UCHAR_TO_INT")
       (method static uchar->long::long (::uchar) "UCHAR_TO_LONG")
       (method static uchar->ulong::ulong (::uchar) "UCHOAR_TO_ULONG")
       
       (method static schar->short::short (::schar) "SCHAR_TO_SHORT")
       (method static schar->ushort::ushort (::schar) "SCHAR_TO_USHORT")
       (method static schar->int::int (::schar) "SCHAR_TO_INT")
       (method static schar->uint::uint (::schar) "SCHAR_TO_UINT")
       (method static schar->long::long (::schar) "SCHAR_TO_LONG")
       (method static schar->ulong::ulong (::schar) "SCHAR_TO_ULONG")
       
       (method static short->schar::schar (::short) "SHORT_TO_SCHAR")
       (method static short->ushort::ushort (::short) "SHORT_TO_USHORT")
       (method static short->int::int (::short) "SHORT_TO_INT")
       (method static short->uint::uint (::short) "SHORT_TO_UINT")
       (method static short->long::long (::short) "SHORT_TO_LONG")
       (method static short->ulong::ulong (::short) "SHORT_TO_ULONG")
       
       (method static ushort->schar::schar (::ushort) "USHORT_TO_SCHAR")
       (method static ushort->short::short (::ushort) "USHORT_TO_SHORT")
       (method static ushort->int::int (::ushort) "USHORT_TO_INT")
       (method static ushort->uint::uint (::ushort) "USHORT_TO_UINT")
       (method static ushort->long::long (::ushort) "USHORT_TO_LONG")
       (method static ushort->ulong::ulong (::ushort) "USHORT_TO_ULONG")
       
       (method static int->schar::schar (::int) "INT_TO_SCHAR")
       (method static int->short::short (::int) "INT_TO_SHORT")
       (method static int->ushort::ushort (::int) "INT_TO_USHORT")
       (method static int->uint::uint (::int) "INT_TO_UINT")
       (method static int->long::long (::int) "INT_TO_LONG")
       (method static int->ulong::ulong (::int) "INT_TO_ULONG")
       
       (method static uint->schar::schar (::uint) "UINT_TO_")
       (method static uint->short::short (::uint) "UINT_TO_SHORT")
       (method static uint->ushort::ushort (::uint) "UINT_TO_USHORT")
       (method static uint->int::uint (::uint) "UINT_TO_INT")
       (method static uint->long::long (::uint) "UINT_TO_LONG")
       (method static uint->ulong::ulong (::uint) "UINT_TO_ULONG")
       
       (method static long->schar::schar (::long) "LONG_TO_SCHAR")
       (method static long->char::char (::long) "LONG_TO_CHAR")
       (method static long->uchar::uchar (::long) "LONG_TO_UCHAR")
       (method static long->short::short (::long) "LONG_TO_SHORT")
       (method static long->ushort::ushort (::long) "LONG_TO_USHORT")
       (method static long->int::int (::long) "LONG_TO_INT")
       (method static long->uint::uint (::long) "LONG_TO_UINT")
       (method static long->ulong::ulong (::long) "LONG_TO_ULONG")
       
       (method static ulong->schar::schar (::ulong) "ULONG_TO_SCHAR")
       (method static ulong->char::char (::ulong) "ULONG_TO_CHAR")
       (method static ulong->uchar::uchar (::ulong) "ULONG_TO_UCHAR")
       (method static ulong->short::short (::ulong) "ULONG_TO_SHORT")
       (method static ulong->ushort::ushort (::ulong) "ULONG_TO_USHORT")
       (method static ulong->int::int (::ulong) "ULONG_TO_INT")
       (method static ulong->uint::uint (::ulong) "ULONG_TO_UINT")
       (method static ulong->long::long (::ulong) "ULONG_TO_LONG")
       
       (method static string->bstring::bstring (::string) "string_to_bstring")
       (method static bstring->string::string (::bstring) "BSTRING_TO_STRING")
       
       (method static char->bchar::bchar (::char) "BCHAR")
       (method static uchar->bchar::bchar (::uchar) "BCHAR")
       (method static bchar->char::char (::bchar) "CCHAR")
       (method static bchar->uchar::uchar (::bchar) "BCHAR_TO_UCHAR")
       (method static double->real::real (::double) "DOUBLE_TO_REAL")
       (method static real->double::double (::real) "REAL_TO_DOUBLE")
       (method static float->real::real (::float) "FLOAT_TO_REAL")
       (method static real->float::float (::real) "REAL_TO_FLOAT")
       (method static double->float::float (::double) "DOUBLE_TO_FLOAT")
       (method static float->double::double (::float) "FLOAT_TO_DOUBLE")
       
       (method static ucs2->bucs2::bucs2 (::ucs2) "BUCS2")
       (method static bucs2->ucs2::ucs2 (::bucs2) "CUCS2")
       
       (method static output-port->file::file (::output-port) "OUTPUT_PORT_TO_FILE")
       (method static file->output-port::output-port (::file) "FILE_TO_OUTPUT_PORT")
       
       (method static file->input-port::input-port (::file) "file_to_input_port")
       
       (method static binary-port->file::file (::binary-port) "BINARY_PORT_TO_FILE")
       
       (method static cobj->obj::obj (::cobj) "COBJ_TO_OBJ")
       (method static c-obj->cobj::cobj (::obj) "obj_to_cobj")
       
       (method static uchar->char::char (::uchar) "UCHAR_TO_CHAR")
       (method static char->uchar::uchar (::char) "CHAR_TO_UCHAR")
       
       (method static belong->long::long (::belong) "BELONG_TO_LONG")
       (method static long->belong::belong (::long) "LONG_TO_BELONG")
       (method static bllong->llong::llong (::bllong) "BLLONG_TO_LLONG")
       (method static llong->bllong::bllong (::llong) "LLONG_TO_BLLONG")
       
       (method static long->bllong::bllong (::long) "LONG_TO_BLLONG")
       (method static long->bllong::bllong (::long) "LONG_TO_BLLONG")
       (method static long->llong::llong (::long) "LONG_TO_LLONG")
       
       (method static obj->void*::cobj (::foreign) "FOREIGN_TO_COBJ")
       (method static void*->obj::foreign (::void*) "void_star_to_obj")))
   
   (pragma
    (bool->bbool side-effect-free nesting)
    (bbool->bool side-effect-free nesting)
    (obj->bool side-effect-free nesting)
    (schar->bint side-effect-free nesting)
    (uchar->bint side-effect-free nesting)
    (short->bint side-effect-free nesting)
    (ushort->bint side-effect-free nesting)
    (int->bint side-effect-free nesting)
    (uint->bint side-effect-free nesting)
    (long->bint side-effect-free nesting)
    (ulong->bint side-effect-free nesting)
    (schar->blong side-effect-free nesting)
    (uchar->blong side-effect-free nesting)
    (short->blong side-effect-free nesting)
    (ushort->blong side-effect-free nesting)
    (int->blong side-effect-free nesting)
    (uint->blong side-effect-free nesting)
    (long->blong side-effect-free nesting)
    (ulong->blong side-effect-free nesting)
    (bint->schar side-effect-free nesting)
    (bint->uchar side-effect-free nesting)
    (bint->short side-effect-free nesting)
    (bint->ushort side-effect-free nesting)
    (bint->int side-effect-free nesting)
    (bint->uint side-effect-free nesting)
    (bint->long side-effect-free nesting)
    (bint->ulong side-effect-free nesting)
    (blong->schar side-effect-free nesting)
    (blong->uchar side-effect-free nesting)
    (blong->short side-effect-free nesting)
    (blong->ushort side-effect-free nesting)
    (blong->int side-effect-free nesting)
    (blong->uint side-effect-free nesting)
    (blong->long side-effect-free nesting)
    (blong->ulong side-effect-free nesting)
    (uchar->short side-effect-free nesting)
    (uchar->ushort side-effect-free nesting)
    (uchar->int side-effect-free nesting)
    (uchar->uint side-effect-free nesting)
    (uchar->long side-effect-free nesting)
    (uchar->ulong side-effect-free nesting)
    (schar->short side-effect-free nesting)
    (schar->ushort side-effect-free nesting)
    (schar->int side-effect-free nesting)
    (schar->uint side-effect-free nesting)
    (schar->long side-effect-free nesting)
    (schar->ulong side-effect-free nesting)
    (short->schar side-effect-free nesting)
    (short->ushort side-effect-free nesting)
    (short->int side-effect-free nesting)
    (short->uint side-effect-free nesting)
    (short->long side-effect-free nesting)
    (short->ulong side-effect-free nesting)
    (ushort->schar side-effect-free nesting)
    (ushort->short side-effect-free nesting)
    (ushort->int side-effect-free nesting)
    (ushort->uint side-effect-free nesting)
    (ushort->long side-effect-free nesting)
    (ushort->ulong side-effect-free nesting)
    (int->schar side-effect-free nesting)
    (int->short side-effect-free nesting)
    (int->ushort side-effect-free nesting)
    (int->uint side-effect-free nesting)
    (int->long side-effect-free nesting)
    (int->ulong side-effect-free nesting)
    (uint->schar side-effect-free nesting)
    (uint->short side-effect-free nesting)
    (uint->ushort side-effect-free nesting)
    (uint->int side-effect-free nesting)
    (uint->long side-effect-free nesting)
    (uint->ulong side-effect-free nesting)
    (long->schar side-effect-free nesting)
    (long->short side-effect-free nesting)
    (long->ushort side-effect-free nesting)
    (long->int side-effect-free nesting)
    (long->uint side-effect-free nesting)
    (long->ulong side-effect-free nesting)
    (ulong->schar side-effect-free nesting)
    (ulong->short side-effect-free nesting)
    (ulong->ushort side-effect-free nesting)
    (ulong->int side-effect-free nesting)
    (ulong->uint side-effect-free nesting)
    (ulong->long side-effect-free nesting)
    (bstring->string side-effect-free nesting)
    (string->bstring side-effect-free nesting)
    (char->bchar side-effect-free nesting)
    (uchar->bchar side-effect-free nesting)
    (bchar->char side-effect-free nesting)
    (bchar->uchar side-effect-free nesting)
    (ucs2->bucs2 side-effect-free nesting)
    (bucs2->ucs2 side-effect-free nesting)
    (double->real side-effect-free)
    (real->double side-effect-free)
    (double->float side-effect-free nesting)
    (float->double side-effect-free nesting)
    (float->real side-effect-free)
    (real->float side-effect-free nesting)
    (cobj->obj side-effect-free nesting)
    (c-obj->cobj side-effect-free nesting)
    (uchar->char side-effect-free nesting)
    (char->uchar side-effect-free nesting)
    (long->belong side-effect-free)
    (belong->long side-effect-free nesting)
    (llong->bllong side-effect-free)
    (bllong->llong side-effect-free nesting)
    (obj->void* side-effect-free nesting)
    (void*->obj side-effect-free nesting)))
    

