;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/os.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Tue Aug  5 10:57:59 1997                          */
;*    Last change :  Mon Nov 12 06:00:53 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Os dependant variables (setup by configure).                     */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/body.texi@                                */
;*       @node Operating System Interface@                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __os
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __r4_numbers_6_5_fixnum
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_vectors_6_8
	    __r4_control_features_6_9
	    __r4_pairs_and_lists_6_3
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_strings_6_7
	    __r4_ports_6_10_1
	    __foreign
	    __evenv
	    __r4_ports_6_10_1
	    __r4_output_6_10_3)
   
   (extern  (c-signal::obj (::int ::procedure) "c_signal")
	    (c-get-signal-handler::obj (::int) "get_signal_handler")
	    (*the-command-line*::obj "command_line")
	    (*the-executable-name*::string "executable_name")
	    (macro c-getenv?::bool (::string) "(long)getenv")
	    (macro c-getenv::string (::string) "(char *)getenv")
	    (macro c-system::int  (::string) "system")
	    (c-date::string () "c_date")
	    (macro c-chdir::int (::string) "chdir")
	    (macro c-getcwd::string (::string ::int) "(char *)(long)getcwd")
	    (macro c-chmod::bool (::string ::bool ::bool ::bool) "bgl_chmod")
	    
	    (macro configure-os-class::string "OS_CLASS")
	    (macro configure-os-name::string "OS_NAME")
	    (macro configure-os-arch::string "OS_ARCH")
	    (macro configure-os-version::string "OS_VERSION")
	    (macro configure-os-tmp::string "OS_TMP")
	    (macro configure-file-separator::char "FILE_SEPARATOR")
	    (macro configure-path-separator::char "PATH_SEPARATOR")
	    (macro configure-static-library-suffix::string "STATIC_LIB_SUFFIX")
	    (macro configure-shared-library-suffix::string "SHARED_LIB_SUFFIX")
	    (macro %dload-init-sym::string "BGL_DYNAMIC_LOAD_INIT")
	    (%dload::int (::string ::string) "bgl_dload")
	    (%dload-error::string () "bgl_dload_error"))
    
   (java    (class foreign
	       (field static *the-command-line*::obj
		      "command_line")
	       (field static *the-executable-name*::string
		      "executable_name")
	       (method static c-signal::obj (::int ::procedure)
		       "c_signal")
	       (method static c-get-signal-handler::obj (::int)
		       "get_signal_handler")
	       (method static c-getenv?::bool (::string)
		       "getenv_exists")
	       (method static c-getenv::string (::string)
		       "getenv")
	       (method static c-system::int  (::string)
		       "system")
	       (method static c-date::string ()
		       "c_date")
	       (method static c-chdir::int (::string)
		       "chdir")
	       (method static c-getcwd::string (::string ::int)
		       "getcwd")
	       (method static c-chmod::bool (::string ::bool ::bool ::bool)
		       "bgl_chmod")
	       (field static %dload-init-sym::string
		      "BGL_DYNAMIC_LOAD_INIT")
	       (method static %dload::int (::string ::string)
		       "bgl_dload")
	       (method static %dload-error::string ()
		       "bgl_dload_error"))
	    
	    (class configure
	       (field static os-class::string
		      "OS_CLASS")
	       (field static os-name::string
		      "OS_NAME")
	       (field static os-arch::string
		      "OS_ARCH")
	       (field static os-version::string
		      "OS_VERSION")
	       (field static os-tmp::string
		      "OS_TMP")
	       (field static file-separator::char
		      "FILE_SEPARATOR")
	       (field static path-separator::char
		      "PATH_SEPARATOR")
	       (field static static-library-suffix::string
		      "STATIC_LIB_SUFFIX")
	       (field static shared-library-suffix::string
		      "SHARED_LIB_SUFFIX")
	       "bigloo.configure"))
   
   (export  (signal num::int thunk::procedure)
	    (get-signal-handler::obj num::int)
	    
	    (inline getenv string::string)
	    (date::string)
	    (inline chdir string::string)
	    (system . strings)
	    (pwd)
	    (command-line)
	    (executable-name::string)
	    (basename::bstring ::bstring)
	    (dirname::bstring ::bstring)
	    (prefix::bstring ::bstring)
	    (suffix::bstring ::bstring)
	    (chmod::bool ::bstring . opts)
	    (make-file-name::bstring ::bstring ::bstring)
	    (find-file/path ::bstring ::obj)
	    (make-static-library-name::bstring ::bstring)
	    (make-shared-library-name::bstring ::bstring)
	    (os-class)
            (os-name)
	    (os-arch)
	    (os-version)
	    (os-tmp)
	    (file-separator)
	    (path-separator)
	    *dynamic-load-path*
	    *default-java-package*
	    (dynamic-load ::bstring . opt)
	    (unix-path->list::pair-nil ::bstring)))

;*---------------------------------------------------------------------*/
;*    Variables setup ...                                              */
;*---------------------------------------------------------------------*/
(define (os-class) configure-os-class)
(define (os-name) configure-os-name)
(define (os-arch) configure-os-arch)
(define (os-version) configure-os-version)
(define (os-tmp) configure-os-tmp)
(define (file-separator) configure-file-separator)
(define (path-separator) configure-path-separator)

;*---------------------------------------------------------------------*/
;*    command-line ...                                                 */
;*---------------------------------------------------------------------*/
(define (command-line)
   *the-command-line*)

;*---------------------------------------------------------------------*/
;*    executable-name ...                                              */
;*---------------------------------------------------------------------*/
(define (executable-name)
   *the-executable-name*)

;*---------------------------------------------------------------------*/
;*    signal ...                                                       */
;*---------------------------------------------------------------------*/
(define (signal num proc)
   (cond
      ((not (=fx (procedure-arity proc) 1))
       (error "signal" "Wrong number of arguments" proc))
      ((or (<fx num 0) (>fx num 31))
       (error "signal" "Illegal signal" num))
      (else
       (c-signal num proc))))

;*---------------------------------------------------------------------*/
;*    get-signal-handler ...                                           */
;*---------------------------------------------------------------------*/
(define (get-signal-handler num)
   (c-get-signal-handler num))

;*---------------------------------------------------------------------*/
;*    getenv ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (getenv string)
   (if (c-getenv? string)
       (c-getenv string)
       #f))

;*---------------------------------------------------------------------*/
;*    system ...                                                       */
;*---------------------------------------------------------------------*/
(define (system . strings)
   (cond
      ((null? strings)
       #f)
      ((null? (cdr strings))
       (c-system (car strings)))
      (else
       (c-system (apply string-append strings)))))
   
;*---------------------------------------------------------------------*/
;*    date ...                                                         */
;*---------------------------------------------------------------------*/
(define (date)
   (let* ((dt (c-date))
	  (len (string-length dt)))
      (if (char=? (string-ref dt (-fx len 1)) #\Newline)
	  (substring dt 0 (-fx len 1))
	  dt)))

;*---------------------------------------------------------------------*/
;*    chdir ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (chdir dirname)
   (c-chdir dirname))

;*---------------------------------------------------------------------*/
;*    pwd ...                                                          */
;*---------------------------------------------------------------------*/
(define (pwd)
   (let ((string (make-string 1024)))
      (c-getcwd string 1024)))
	  
;*---------------------------------------------------------------------*/
;*    basename ...                                                     */
;*---------------------------------------------------------------------*/
(define (basename string)
   (let* ((len   (-fx (string-length string) 1))
	  (start (if (and (>fx len 0)
			  (char=? (string-ref string len)
				  configure-file-separator))
		     (-fx len 1)
		     len)))
      (let loop ((index start))
	 (cond
	    ((=fx index -1)
	     string)
	    ((char=? (string-ref string index) configure-file-separator)
	     (substring string (+fx index 1) (+fx start 1)))
	    (else
	     (loop (-fx index 1)))))))

;*---------------------------------------------------------------------*/
;*    prefix ...                                                       */
;*---------------------------------------------------------------------*/
(define (prefix string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((e len)
                 (s len))
         (cond
            ((<=fx s 0)
             (substring string 0 (+fx 1 e)))
            (else
             (if (and (eq? (string-ref string s) #\.)
                      (=fx e len))
                 (loop (-fx s 1) (-fx s 1))
                 (loop e (-fx s 1))))))))

;*---------------------------------------------------------------------*/
;*    dirname ...                                                      */
;*---------------------------------------------------------------------*/
(define (dirname string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((read len))
	 (cond
	    ((<=fx read 0)
	     (if (char=? (string-ref string read) configure-file-separator)
		 (make-string 1 configure-file-separator)
		 "."))
	    ((char=? (string-ref string read) configure-file-separator)
	     (substring string 0 read))
	    (else
	     (loop (-fx read 1)))))))

;*---------------------------------------------------------------------*/
;*    suffix ...                                                       */
;*---------------------------------------------------------------------*/
(define (suffix string)
   (let* ((len (string-length string))
          (len-1 (-fx len 1)))
      (let loop ((read len-1))
         (cond
            ((<fx read 0)
             "")
            ((char=? (string-ref string read) configure-file-separator)
	     "")
            ((char=? (string-ref string read) #\.)
             (cond
                ((=fx read len-1)
                 "")
                (else
                 (substring string (+fx read 1) len))))
            (else
             (loop (-fx read 1)))))))

;*---------------------------------------------------------------------*/
;*    chmod ...                                                        */
;*---------------------------------------------------------------------*/
(define (chmod file::bstring . mode)
   (let loop ((mode mode)
	      (read? #f)
	      (write? #f)
	      (exec? #f))
      (cond
	 ((null? mode)
	  (c-chmod file read? write? exec?))
	 ((eq? (car mode) 'read)
	  (loop (cdr mode)
		#t
		write?
		exec?))
	 ((eq? (car mode) 'write)
	  (loop (cdr mode)
		read?
		#t
		exec?))
	 ((eq? (car mode) 'execute)
	  (loop (cdr mode)
		read?
		write?
		#t))
	 (else
	  (error "chmod" "Unknown mode" mode)))))
	     
;*---------------------------------------------------------------------*/
;*    @deffn make-file-name@ ...                                       */
;*    -------------------------------------------------------------    */
;*    This function build a absolute file name from a path and a       */
;*    relative file-name.                                              */
;*---------------------------------------------------------------------*/
(define (make-file-name directory::bstring file::bstring)
   (if (=fx (string-length directory) 0)
       file
       (let* ((ldir  (string-length directory))
	      (lfile (string-length file))
	      (len   (+fx ldir (+fx lfile 1)))
	      (str   (make-string len configure-file-separator)))
	  (blit-string-ur! directory 0 str 0 ldir)
	  (blit-string-ur! file 0 str (+fx 1 ldir) lfile)
	  str)))

;*---------------------------------------------------------------------*/
;*    @deffn find-file/path@ ...                                       */
;*---------------------------------------------------------------------*/
(define (find-file/path file-name path)
   (cond
      ((=fx (string-length file-name) 0)
       #f)
      ((char=? (string-ref file-name 0) configure-file-separator)
       (if (file-exists? file-name)
           file-name
           #f))
      (else
       (let loop ((path path))
	  (if (null? path)
	      #f
	      (let ((fname (make-file-name (car path) file-name)))
		 (if (file-exists? fname)
		     fname
		     (loop (cdr path)))))))))

;*---------------------------------------------------------------------*/
;*    make-static-library-name ...                                     */
;*    -------------------------------------------------------------    */
;*    This function, adds the proper static library extension.         */
;*---------------------------------------------------------------------*/
(define (make-static-library-name libname::bstring)
   (string-append libname "." configure-static-library-suffix))

;*---------------------------------------------------------------------*/
;*    make-shared-library-name ...                                     */
;*    -------------------------------------------------------------    */
;*    This function, adds the proper shared library extension.         */
;*---------------------------------------------------------------------*/
(define (make-shared-library-name libname::bstring)
   (string-append libname "." configure-shared-library-suffix))

;*---------------------------------------------------------------------*/
;*    *dynamic-load-path* ...                                          */
;*---------------------------------------------------------------------*/
(define *dynamic-load-path* '("" "."))

;*---------------------------------------------------------------------*/
;*    *default-java-package* ...                                       */
;*    -------------------------------------------------------------    */
;*    The default package for non qualified imported Java definitions. */
;*    -------------------------------------------------------------    */
;*    See the -pckg-java compiler option.                              */
;*---------------------------------------------------------------------*/
(define *default-java-package* "bigloo.foreign")

;*---------------------------------------------------------------------*/
;*    dynamic-load ...                                                 */
;*---------------------------------------------------------------------*/
(define (dynamic-load lib . inits)
    (define (err proc::obj msg obj)
      (error (if (string? proc)
		 (string-append "dynamic-load:" proc)
		 "dynamic-load")
	     msg obj))
   (let ((init (if (and (pair? inits) (string? (car inits)))
		   (car inits)
		   %dload-init-sym))
	 (flib  (find-file/path lib *dynamic-load-path*)))
      (if (not (string? flib))
	  (err #f "Can't find library" lib)
	  (case (%dload flib init)
	     ((1)
	      (err flib
		   (%dload-error)
		   #"A possible reason\nfor that error is that the application loading the library\nis not linked against Bigloo dynamic libraries"))
	     ((2)
	      (err "Can't find init symbol" init (%dload-error)))
	     ((3)
	      (err #f "Not supported on this architecture" #unspecified))))))
	 
	  
;*---------------------------------------------------------------------*/
;*    unix-path->list ...                                              */
;*---------------------------------------------------------------------*/
(define (unix-path->list str)
   (let ((stop (string-length str)))
      (let loop ((mark 0)
		 (r 0)
		 (res '()))
	 (cond
	    ((=fx stop r)
	     (let ((res (if (<fx mark r)
			    (cons (substring str mark r) res)
			    res)))
		(reverse! res)))
	    ((char=? (string-ref str r) #\:)
	     (if (<fx mark r)
		 (loop (+fx 1 r) (+fx 1 r) (cons (substring str mark r) res))
		 (loop (+fx 1 r) (+fx 1 r) res)))
	    (else
	     (loop mark (+fx 1 r) res))))))
	     
      
   
