;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/pairlist.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 09:58:09 1995                          */
;*    Last change :  Mon Jul  2 15:36:04 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.3. Pairs and Lists (page 15, r4)                               */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/body.texi@                                */
;*       @node Pairs And Lists@                                        */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_pairs_and_lists_6_3
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __r4_equivalence_6_2
	    __r4_vectors_6_8
	    __r4_numbers_6_5_fixnum
	    __r4_strings_6_7
	    __r4_symbols_6_4
	    __r4_booleans_6_1
	    
	    __evenv)
   
   (extern  (macro c-pair?::bool   (::obj)             "PAIRP")
	    (macro c-epair?::bool  (::obj)             "EXTENDED_PAIRP")
	    (macro c-cons::pair    (::obj ::obj)       "MAKE_PAIR")
	    (macro c-s-cons::pair  (::obj ::obj)       "MAKE_S_PAIR")
	    (macro c-econs::epair  (::obj ::obj ::obj) "MAKE_EXTENDED_PAIR")
	    (macro c-car::obj      (::pair)            "CAR")
	    (macro c-cdr::obj      (::pair)            "CDR")
	    (macro c-cer::obj      (::epair)           "CER")
	    (macro c-set-car!::obj (::pair ::obj)      "SET_CAR")
	    (macro c-set-cdr!::obj (::pair ::obj)      "SET_CDR")
	    (macro c-set-cer!::obj (::epair ::obj)     "SET_CER")
	    (macro c-null?::bool   (::obj)             "NULLP")
	    
	    (export length "bgl_list_length")
	    (export list-ref "bgl_list_ref")
	    (export append-2 "bgl_append2")
	    (export reverse "bgl_reverse"))
   
   (java    (class foreign
	       (method static c-pair?::bool (::obj)
		       "PAIRP")
	       (method static c-epair?::bool (::obj)
		       "EXTENDED_PAIRP")
	       (method static c-cons::pair (::obj ::obj)
		       "MAKE_PAIR")
	       (method static c-s-cons::pair (::obj ::obj)
		       "MAKE_S_PAIR")
	       (method static c-econs::epair (::obj ::obj ::obj)
		       "MAKE_EXTENDED_PAIR")
	       (method static c-car::obj (::pair)
		       "CAR")
	       (method static c-cdr::obj (::pair)
		       "CDR")
	       (method static c-cer::obj (::epair)
		       "CER")
	       (method static c-set-car!::obj (::pair ::obj)
		       "SET_CAR")
	       (method static c-set-cdr!::obj (::pair ::obj)
		       "SET_CDR")
	       (method static c-set-cer!::obj (::epair ::obj)
		       "SET_CER")
	       (method static c-null?::bool (::obj)
		       "NULLP")))
   
   (export  (inline pair?::bool         ::obj)
	    (inline epair?::bool        ::obj)
	    (inline pair-or-null?::bool ::obj)
	    (inline cons::pair          ::obj ::obj)
	    (inline econs::pair         ::obj ::obj ::obj)
	    (inline car                 ::pair)
	    (inline cdr                 ::pair)
	    (inline cer                 ::epair)
	    (inline caar                ::pair)
	    (inline cadr                ::pair) 
	    (inline cdar                ::pair)
	    (inline cddr                ::pair)
	    (inline caaar               ::pair)
	    (inline caadr               ::pair)
	    (inline cadar               ::pair)
	    (inline caddr               ::pair)
	    (inline cdaar               ::pair)
	    (inline cddar               ::pair)
	    (inline cdadr               ::pair)
	    (inline cdddr               ::pair)
	    (inline caaaar              ::pair)
	    (inline caaadr              ::pair)
	    (inline caadar              ::pair)
	    (inline cadaar              ::pair)
	    (inline cdaaar              ::pair)
	    (inline caaddr              ::pair)
	    (inline caddar              ::pair)
	    (inline cadadr              ::pair)
	    (inline cadddr              ::pair)
	    (inline cdaadr              ::pair)
	    (inline cdaddr              ::pair)
	    (inline cddaar              ::pair)
	    (inline cdadar              ::pair)
	    (inline cddadr              ::pair)
	    (inline cdddar              ::pair)
	    (inline cddddr              ::pair)
	    (inline set-car!            ::pair ::obj)
	    (inline set-cdr!            ::pair ::obj)
	    (inline set-cer!            ::epair ::obj)
	    (inline null?::bool         ::obj)
	    (list?::bool                ::obj)
	    (inline list::pair-nil      . obj)
	    (length::long               ::pair-nil)
	    (append-2                   ::pair-nil ::obj)
	    (eappend-2                  ::pair-nil ::obj)
	    (append::pair-nil           . obj)
	    (eappend::pair-nil          . obj)
	    (append!::pair-nil          ::pair-nil ::pair-nil)
	    (reverse::pair-nil          ::pair-nil)
	    (ereverse::pair-nil         ::pair-nil)
	    (list-tail::pair-nil        ::pair-nil ::long)
	    (list-ref                   ::pair-nil ::long)
	    (list-set!                  ::pair-nil ::long ::obj)
	    (last-pair::pair            ::pair)
	    (memq                       ::obj ::pair-nil)
	    (memv                       ::obj ::pair-nil)
	    (member                     ::obj ::pair-nil)
	    (assq                       ::obj ::pair-nil)
	    (assv                       ::obj ::pair-nil)
	    (assoc                      ::obj ::pair-nil)
	    (remq::pair-nil             ::obj ::pair-nil)
	    (delete::pair-nil           ::obj ::pair-nil)
	    (remq!::pair-nil            ::obj ::pair-nil)
	    (delete!::pair-nil          ::obj ::pair-nil)
	    (reverse!::pair-nil         ::pair-nil)
	    (cons*                      ::obj . obj))
   
   (pragma  (c-null? (predicate-of nil) no-cfa-top nesting)
	    (null? (predicate-of nil) no-cfa-top nesting)
	    (pair-or-null? (predicate-of pair-nil) no-cfa-top nesting)
	    (c-pair? (predicate-of pair) no-cfa-top nesting)
	    (pair? (predicate-of pair) no-cfa-top nesting)
	    (list? side-effect-free no-cfa-top nesting)
	    (c-car side-effect-free no-cfa-top nesting)
	    (car side-effect-free no-cfa-top nesting)
	    (c-cdr side-effect-free no-cfa-top nesting)
	    (cdr side-effect-free no-cfa-top nesting)
	    (c-cer side-effect-free no-cfa-top nesting)
	    (cer side-effect-free no-cfa-top nesting)
	    (length side-effect-free no-cfa-top nesting)
	    (append-2 side-effect-free nesting)
	    (eappend-2 side-effect-free nesting)
	    (append side-effect-free nesting)
	    (eappend side-effect-free nesting)
	    (reverse side-effect-free nesting)
	    (ereverse side-effect-free nesting)
	    (list-tail side-effect-free nesting)
	    (list-ref side-effect-free nesting)
	    (last-pair side-effect-free nesting)
	    (memq side-effect-free nesting)
	    (memv side-effect-free nesting)
	    (member side-effect-free nesting)
	    (assq side-effect-free nesting)
	    (assv side-effect-free nesting)
	    (assoc side-effect-free nesting)
	    (remq side-effect-free nesting)))

;*---------------------------------------------------------------------*/
;*    pair? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (pair? obj)
   (c-pair? obj))

;*---------------------------------------------------------------------*/
;*    epair? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (epair? obj)
   (c-epair? obj))

;*---------------------------------------------------------------------*/
;*    @deffn pair-or-null?@ ...                                        */
;*---------------------------------------------------------------------*/
(define-inline (pair-or-null? obj)
   (if (pair? obj)
       #t
       (null? obj)))
   
;*---------------------------------------------------------------------*/
;*    cons ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cons obj1 obj2)
   (c-cons obj1 obj2))

;*---------------------------------------------------------------------*/
;*    econs ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (econs obj1 obj2 obj3)
   (c-econs obj1 obj2 obj3))

;*---------------------------------------------------------------------*/
;*    car ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (car pair)
   (c-car pair))

;*---------------------------------------------------------------------*/
;*    cdr ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (cdr pair)
   (c-cdr pair))

;*---------------------------------------------------------------------*/
;*    cer ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (cer obj)
   (c-cer obj))

;*---------------------------------------------------------------------*/
;*    caar ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (caar pair)
   (car (car pair)))

;*---------------------------------------------------------------------*/
;*    cadr ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cadr pair)
   (car (cdr pair)))

;*---------------------------------------------------------------------*/
;*    cdar ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cdar pair)
   (cdr (car pair)))

;*---------------------------------------------------------------------*/
;*    cddr ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cddr pair)
   (cdr (cdr pair)))

;*---------------------------------------------------------------------*/
;*    caaar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (caaar pair)
   (car (car (car pair))))

;*---------------------------------------------------------------------*/
;*    caadr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (caadr pair)
   (car (car (cdr pair))))

;*---------------------------------------------------------------------*/
;*    cadar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cadar pair)
   (car (cdr (car pair))))

;*---------------------------------------------------------------------*/
;*    caddr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (caddr pair)
   (car (cdr (cdr pair))))

;*---------------------------------------------------------------------*/
;*    cdaar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cdaar pair)
   (cdr (car (car pair))))

;*---------------------------------------------------------------------*/
;*    cddar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cddar pair)
   (cdr (cdr (car pair))))

;*---------------------------------------------------------------------*/
;*    cdadr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cdadr pair)
   (cdr (car (cdr pair))))

;*---------------------------------------------------------------------*/
;*    cdddr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cdddr pair)
   (cdr (cdr (cdr pair))))

;*---------------------------------------------------------------------*/
;*    caaaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caaaar pair)
   (car (car (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    caaadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caaadr pair)
   (car (car (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    caadar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caadar pair)
   (car (car (cdr (car pair)))))

;*---------------------------------------------------------------------*/
;*    cadaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cadaar pair)
   (car (cdr (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    cdaaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdaaar pair)
   (cdr (car (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    caaddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caaddr pair)
   (car (car (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    caddar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caddar pair)
   (car (cdr (cdr (car pair)))))

;*---------------------------------------------------------------------*/
;*    cadadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cadadr pair)
   (car (cdr (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cadddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cadddr pair)
   (car (cdr (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cdaadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdaadr pair)
   (cdr (car (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cdaddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdaddr pair)
   (cdr (car (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cddaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cddaar pair)
   (cdr (cdr (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    cddadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cddadr pair)
   (cdr (cdr (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cdadar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdadar pair)
   (cdr (car (cdr (car pair)))))

;*---------------------------------------------------------------------*/
;*    cdddar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdddar pair)
   (cdr (cdr (cdr (car pair)))))


;*---------------------------------------------------------------------*/
;*    cddddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cddddr pair)
   (cdr (cdr (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    set-car! ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (set-car! pair obj)
   (c-set-car! pair obj))

;*---------------------------------------------------------------------*/
;*    set-cdr! ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (set-cdr! pair obj)
   (c-set-cdr! pair obj))

;*---------------------------------------------------------------------*/
;*    set-cer! ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (set-cer! epair obj)
   (c-set-cer! epair obj)) 

;*---------------------------------------------------------------------*/
;*    null? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (null? obj)
   (c-null? obj))

;*---------------------------------------------------------------------*/
;*    list ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (list::pair-nil . l)
   l)

;*---------------------------------------------------------------------*/
;*    lists? ...                                                       */
;*---------------------------------------------------------------------*/
(define (list? x)
   (labels ((l1 (x prev)
		(cond ((null? x)
		       #t)
		      ((pair? x)
		       (if (eq? x prev)
			   #f
			   (l2 (cdr x) prev)))
		      (else #f)))
	    (l2 (x prev)
		(cond ((null? x)
		       #t)
		      ((pair? x)
		       (if (eq? x prev)
			   #f
			   (l1 (cdr x) (cdr prev))))
		      (else #f))))
      (cond ((null? x)
	     #t)
	    ((pair? x)
	     (l1 (cdr x) x))
	    (else
	     #f))))

;*---------------------------------------------------------------------*/
;*    append-2                                                         */
;*---------------------------------------------------------------------*/
(define (append-2 l1 l2)
   (let ((head (cons '() l2)))
      (labels ((loop (prev tail)
		     (if (null? tail)
			 '()
			 (let ((new-prev (cons (car tail) l2)))
			    (set-cdr! prev new-prev)
			    (loop new-prev (cdr tail))))))
	 (loop head l1)
	 (cdr head))))

;*---------------------------------------------------------------------*/
;*    eappend-2                                                        */
;*---------------------------------------------------------------------*/
(define (eappend-2 l1 l2)
   (let ((head (if (epair? l2)
		   (econs '() l2 (cer l2))
		   (cons '() l2))))
      (labels ((loop (prev tail)
		     (if (null? tail)
			 '()
			 (let ((new-prev (if (epair? tail)
					     (econs (car tail) l2 (cer tail))
					     (cons (car tail) l2))))
			    (set-cdr! prev new-prev)
			    (loop new-prev (cdr tail))))))
	 (loop head l1)
	 (cdr head))))

;*---------------------------------------------------------------------*/
;*    append ...                                                       */
;*---------------------------------------------------------------------*/
(define (append . l)
   (labels ((append-list (l)
			 (let ((len (length l)))
			    (if (=fx len 0)
				'()
				(if (=fx len 1)
				    (car l)
				    (if (=fx len 2)
					(append-2 (car l)
						  (car (cdr l)))
					(append-2 (car l)
						  (append-list (cdr l)))))))))
      (append-list l)))

;*---------------------------------------------------------------------*/
;*    eappend ...                                                      */
;*---------------------------------------------------------------------*/
(define (eappend . l)
   (labels ((append-list (l)
			 (let ((len (length l)))
			    (if (=fx len 0)
				'()
				(if (=fx len 1)
				    (car l)
				    (if (=fx len 2)
					(eappend-2 (car l)
						   (car (cdr l)))
					(eappend-2 (car l)
						   (append-list (cdr l)))))))))
      (append-list l)))

;*---------------------------------------------------------------------*/
;*    append! ...                                                      */
;*---------------------------------------------------------------------*/
(define (append! x y)
  (if (null? x)
      y
      (do ((a x b)
           (b (cdr x) (cdr b)))
          ((null? b)
           (set-cdr! a y)
           x))))

;*---------------------------------------------------------------------*/
;*    length ...                                                       */
;*---------------------------------------------------------------------*/
(define (length list)
   (let loop ((l       list)
	      (res::long 0))
      (cond
	 ((null? l)
	  res)
	 (else
	  (loop (cdr l) (+fx 1 res))))))
 
;*---------------------------------------------------------------------*/
;*    reverse ...                                                      */
;*---------------------------------------------------------------------*/
(define (reverse l)
   (let loop ((l   l)
	      (acc '()))
      (if (null? l)
	  acc
	  (loop (cdr l) (cons (car l) acc)))))

;*---------------------------------------------------------------------*/
;*    ereverse ...                                                     */
;*---------------------------------------------------------------------*/
(define (ereverse l)
   (let loop ((l   l)
	      (acc '()))
      (if (null? l)
	  acc
	  (loop (cdr l)
		(if (epair? l)
		    (econs (car l) acc (cer l))
		    (cons (car l) acc))))))

;*---------------------------------------------------------------------*/
;*    list-tail ...                                                    */
;*---------------------------------------------------------------------*/
(define (list-tail list k)
   (if (zerofx? k)
       list
       (list-tail (cdr list) (-fx k 1))))

;*---------------------------------------------------------------------*/
;*    list-ref ...                                                     */
;*---------------------------------------------------------------------*/
(define (list-ref list k)
   (if (zerofx? k)
       (car list)
       (list-ref (cdr list) (-fx k 1))))

;*---------------------------------------------------------------------*/
;*    list-set! ...                                                    */
;*---------------------------------------------------------------------*/
(define (list-set! list k val)
   (if (zerofx? k)
       (set-car! list val)
       (list-set! (cdr list) (-fx k 1) val)))

;*---------------------------------------------------------------------*/
;*    last-pair ...                                                    */
;*---------------------------------------------------------------------*/
(define (last-pair x)
   (if (pair? (cdr x))
       (last-pair (cdr x))
       x))

;*---------------------------------------------------------------------*/
;*    memq ...                                                         */
;*---------------------------------------------------------------------*/
(define (memq obj list)
   (let loop ((list list))
      (if (pair? list)
	  (if (eq? (car list) obj)
	      list
	      (loop (cdr list)))
	  #f)))

;*---------------------------------------------------------------------*/
;*    memv ...                                                         */
;*---------------------------------------------------------------------*/
(define (memv obj list)
   (let loop ((list list))
      (if (pair? list)
	  (if (eqv? (car list) obj)
	      list
	      (loop (cdr list)))
	  #f)))

;*---------------------------------------------------------------------*/
;*    member ...                                                       */
;*---------------------------------------------------------------------*/
(define (member obj list)
   (let loop ((list list))
      (cond
	 ((not (pair? list)) #f)
	 ((equal? obj (car list)) list)
	 (else (loop (cdr list))))))
 
;*---------------------------------------------------------------------*/
;*    assq ...                                                         */
;*---------------------------------------------------------------------*/
(define (assq obj alist)
   (let loop ((alist alist))
      (if (pair? alist)
          (if (eq? (car (car alist)) obj)
              (car alist)
              (loop (cdr alist)))
          #f)))

;*---------------------------------------------------------------------*/
;*    assv ...                                                         */
;*---------------------------------------------------------------------*/
(define (assv obj alist)
   (let loop ((alist alist))
      (if (pair? alist)
          (if (eqv? (car (car alist)) obj)
              (car alist)
              (loop (cdr alist)))
	  #f)))

;*---------------------------------------------------------------------*/
;*    assoc ...                                                        */
;*---------------------------------------------------------------------*/
(define (assoc obj alist)
   (let loop ((alist alist))
      (if (pair? alist)
          (if (equal? (car (car alist)) obj)
              (car alist)
              (loop (cdr alist)))
	  #f)))

;*---------------------------------------------------------------------*/
;*    The following functions are not in the IEEE (nor r4).            */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    remq ...                                                         */
;*---------------------------------------------------------------------*/
(define (remq x y)
   (cond
      ((null? y) y)
      ((eq? x (car y)) (remq x (cdr y)))
      (else (cons (car y) (remq x (cdr y))))))

;*---------------------------------------------------------------------*/
;*    delete ...                                                       */
;*---------------------------------------------------------------------*/
(define (delete x y)
   (cond
      ((null? y) y)
      ((equal? x (car y)) (delete x (cdr y)))
      (else (cons (car y) (delete x (cdr y))))))

;*---------------------------------------------------------------------*/
;*    remq! ...                                                        */
;*---------------------------------------------------------------------*/
(define (remq! x y)
   (cond
      ((null? y) y)
      ((eq? x (car y)) (remq! x (cdr y)))
      (else (let loop ((prev y))
               (cond ((null? (cdr prev))
                      y)
                     ((eq? (cadr prev) x)
                      (set-cdr! prev (cddr prev))
                      (loop prev))
                     (else (loop (cdr prev))))))))

;*---------------------------------------------------------------------*/
;*    delete! ...                                                      */
;*---------------------------------------------------------------------*/
(define (delete! x y)
   (cond
      ((null? y) y)
      ((equal? x (car y)) (delete! x (cdr y)))
      (else (let loop ((prev y))
               (cond ((null? (cdr prev))
                      y)
                     ((equal? (cadr prev) x)
                      (set-cdr! prev (cddr prev))
                      (loop prev))
                     (else (loop (cdr prev))))))))

;*---------------------------------------------------------------------*/
;*    cons* ...                                                        */
;*---------------------------------------------------------------------*/
(define (cons* x . y)
   (labels ((cons*1 (x) (cond ((null? (cdr x))
			       (car x))
			      (else
			       (cons (car x) (cons*1 (cdr x)))))))
      (if (null? y)
	  x
          (cons x (cons*1 y)))))

;*---------------------------------------------------------------------*/
;*    reverse! ...                                                     */
;*---------------------------------------------------------------------*/
(define (reverse! l)
  (if (pair? l)
       (let nr ((l l)
		(r '()))
          (if (null? (cdr l))
              (begin
                 (set-cdr! l r)
                 l)
	      (let ((cdrl (cdr l)))
		 (nr cdrl
		     (begin (set-cdr! l r) l)))))
       l))

   
