;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/pragma.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  7 08:44:07 1996                          */
;*    Last change :  Sat Jul  7 07:44:32 2001 (serrano)                */
;*    Copyright   :  1996-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The pragma clause compilation                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_pragma
   (import module_module
	   tools_error
	   type_type
	   engine_param
	   ast_var
	   ast_env
	   ast_remove
	   type_env
	   (find-location tools_location))
   (export (make-pragma-compiler)
	   (pragma-finalizer)))

;*---------------------------------------------------------------------*/
;*    make-pragma-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-pragma-compiler)
   (instantiate::ccomp (id 'pragma)
		       (producer  (pragma-producer *module*))
		       (consumer  (lambda (m c)
				     ((pragma-producer m) c)))
		       (finalizer pragma-finalizer)))

;*---------------------------------------------------------------------*/
;*    pragma-producer ...                                              */
;*---------------------------------------------------------------------*/
(define (pragma-producer module)
   (lambda (clause)
      (match-case clause
	 ((?- . ?protos)
	  (for-each (lambda (proto) (pragma-parser proto module clause))
		    protos)
	  '())
	 (else
	  (user-error "Parse error"
		      (string-append "Illegal `pragma' clause")
		      clause
		      '())))))
   
;*---------------------------------------------------------------------*/
;*    pragma-parser ...                                                */
;*---------------------------------------------------------------------*/
(define (pragma-parser proto module clause)
   (match-case proto
      (((and ?id (? symbol?)) . ?prop)
       (set! *pragma-list* (cons (list id module prop clause) *pragma-list*)))
      (else
       (user-error "Parse error" "Illegal `pragma' clause" clause '()))))

;*---------------------------------------------------------------------*/
;*    *pragma-list* ...                                                */
;*---------------------------------------------------------------------*/
(define *pragma-list* '())

;*---------------------------------------------------------------------*/
;*    pragma-finalizer ...                                             */
;*---------------------------------------------------------------------*/
(define (pragma-finalizer)
   (for-each (lambda (pragma)
		(match-case pragma
		   ((?id ?module ?prop* ?clause)
		    (let ((global (let ((global (find-global/module id
								    module)))
				     (if (global? global)
					 global
					 (find-global/module id 'foreign)))))
		       (if (not (global? global))
			   (warning "pragma-finalizer"
				    "Can't find global variable -- "
				    `(@ ,id ,module))
			   (set-pragma-properties! global prop* clause))))
		   (else
		    (internal-error "pragma-finalizer"
				    "Illegal `pragma' finalizer form"
				    pragma))))
	     *pragma-list*)
   (set! *pragma-list* '())
   'void)

;*---------------------------------------------------------------------*/
;*    set-pragma-properties! ...                                       */
;*---------------------------------------------------------------------*/
(define (set-pragma-properties! global prop* clause)
   (for-each (lambda (prop) (set-pragma-property! global prop clause))
	     prop*))
 
;*---------------------------------------------------------------------*/
;*    set-pragma-property! ...                                         */
;*---------------------------------------------------------------------*/
(define (set-pragma-property! global prop clause)
   (match-case prop
      ((? symbol?)
       (case prop
	  ;; the side-effect-free pragma
	  ((side-effect-free)
	   (let ((value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "property is not concerning a function"
			      prop
			      '())
		  (fun-side-effect?-set! value #f))))
	  ;; the no-cfa-top pragma
	  ((no-cfa-top)
	   (let ((value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "property is not concerning a function"
			      prop
			      '())
		  (fun-top?-set! value #f))))
	  ;; this function is a generated allocator. That property is
	  ;; used when emit symbol tables for profiling
	  ((allocator)
	   (let ((value (global-value global)))
	      (if (not (sfun? value))
		  (user-error "pragma"
			      "property is not concerning a sfunction"
			      prop
			      '())
		  (sfun-property-set! value (cons prop
						  (sfun-property value))))))
	  ((no-trace)
	   (let ((value (global-value global)))
	      (if (not (sfun? value))
		  (user-error "pragma"
			      "property is not concerning a sfunction"
			      prop
			      '())
		  (sfun-property-set! value (cons prop
						  (sfun-property value))))))
	  ((nesting)
	   (let ((value (global-value global)))
	      (if (cfun? value)
		  (global-pragma-set! global
				      (cons 'nesting
					    (global-pragma global))))))
	  (else
	   (user-error "Parse error" "Illegal `pragma' form" clause '()))))
      (((and (? symbol?) ?key) (and (? symbol?) ?value))
       (case key
	  ;; the predicate-of pragma
	  ((predicate-of)
	   (let ((type  (use-type! value (find-location prop)))
		 (value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "predicate is not associated to a function"
			      prop
			      '())
		  (begin
		     (fun-predicate-of-set! value type)
		     ;; predicate cannot be remove until
		     ;; coercers introduction pass
		     (remove-var-from! 'coerce global)
		     ;; furthermore a predicate is _always_
		     ;; free of side effects
		     (fun-side-effect?-set! value #f)))))
	  (else
	   (user-error "Parse error" "Illegal `pragma' form" prop '()))))
      (else
       (user-error "Parse error"
		   "Illegal `pragma' form"
		   (if (pair? prop) prop clause)
		   '()))))
	 
