;; Compile a node and leave the results on the stack
(module jvm_expr
   (import type_type ast_var ast_node
	   object_class      ; tclass
	   jvm_env jvm_instr jvm_compiler )
   (export (generic compile-expr e::node env::env)) )

(define-generic (compile-expr e::node env::env))

(define-method (compile-expr e::atom env::env)
   (compiler-atom e env) )

(define-method (compile-expr e::var env::env)
   (compiler-var e env) )

(define-method (compile-expr e::let-var env::env)
   (compiler-let e env compile-expr) )

(define-method (compile-expr e::setq env::env)
   (compiler-setq e env)
   (_getstatic env (jlib-declare env 'unspecified)) )

(define-method (compile-expr e::sequence env::env)
   (compiler-sequence e env compile-expr) )

(define-method (compile-expr e::conditional env::env)
   (compiler-if e env compile-expr) )

(define-method (compile-expr e::select env::env)
   (compiler-select e env compile-expr) )

(define-method (compile-expr e::let-fun env::env)
   (compiler-labels e env compile-expr) )

(define-method (compile-expr e::app env::env)
   (compiler-app e env) )

(define-method (compile-expr e::app-ly env::env)
   (compiler-apply e env) )

(define-method (compile-expr e::funcall env::env)
   (compiler-funcall e env) )

(define-method (compile-expr e::pragma env::env)
   (compiler-pragma e env) )

(define-method (compile-expr e::getfield env::env)
   (compiler-getfield e env) )

(define-method (compile-expr e::setfield env::env)
   (compiler-setfield e env)
   (_getstatic env (jlib-declare env 'unspecified)) )

(define-method (compile-expr e::new env::env)
   (compiler-new e env) )

(define-method (compile-expr e::valloc env::env)
   (compiler-valloc e env) )

(define-method (compile-expr e::vref env::env)
   (compiler-vref e env) )

(define-method (compile-expr e::vset! env::env)
   (compiler-vset e env)
   (_getstatic env (jlib-declare env 'unspecified)) )

(define-method (compile-expr e::vlength env::env)
   (compiler-vlength e env) )

(define-method (compile-expr e::isa env::env)
   (compiler-isa e env) )

(define-method (compile-expr e::cast env::env)
   (compiler-cast e env compile-expr) )

(define-method (compile-expr e::set-ex-it env)
   (compiler-setexit e env compile-expr) )

(define-method (compile-expr e::jump-ex-it env::env)
   (compiler-jump-exit e env) )

(define-method (compile-expr e::fail env::env)
   (compiler-fail e env) )

(define-method (compile-expr e::make-box env::env)
   (compiler-make-box e env) )

(define-method (compile-expr e::box-ref env::env)
   (compiler-box-ref e env) )

(define-method (compile-expr e::box-set! env::env)
   (compiler-box-set! e env)
   (_getstatic env (jlib-declare env 'unspecified)) )
