// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package secretsmanager provides the client and types for making API
// requests to AWS Secrets Manager.
//
// AWS Secrets Manager is a web service that enables you to store, manage, and
// retrieve, secrets.
//
// This guide provides descriptions of the AWS Secrets Manager API. For more
// information about using this service, see the AWS Secrets Manager User Guide
// (http://docs.aws.amazon.com/http:/docs.aws.amazon.com/secretsmanager/latest/userguide/introduction.html).
//
// API Version
//
// This version of the AWS Secrets Manager API Reference documents the AWS Secrets
// Manager API version 2017-10-17.
//
// As an alternative to using the API directly, you can use one of the AWS SDKs,
// which consist of libraries and sample code for various programming languages
// and platforms (such as Java, Ruby, .NET, iOS, and Android). The SDKs provide
// a convenient way to create programmatic access to AWS Secrets Manager. For
// example, the SDKs take care of cryptographically signing requests, managing
// errors, and retrying requests automatically. For more information about the
// AWS SDKs, including how to download and install them, see Tools for Amazon
// Web Services (http://aws.amazon.com/tools/).
//
// We recommend that you use the AWS SDKs to make programmatic API calls to
// AWS Secrets Manager. However, you also can use the AWS Secrets Manager HTTP
// Query API to make direct calls to the AWS Secrets Manager web service. To
// learn more about the AWS Secrets Manager HTTP Query API, see Making Query
// Requests (http://docs.aws.amazon.com/secretsmanager/latest/userguide/orgs_query-requests.html)
// in the AWS Secrets Manager User Guide.
//
// AWS Secrets Manager supports GET and POST requests for all actions. That
// is, the API doesn't require you to use GET for some actions and POST for
// others. However, GET requests are subject to the limitation size of a URL.
// Therefore, for operations that require larger sizes, use a POST request.
//
// Signing Requests
//
// When you send HTTP requests to AWS, you must sign the requests so that AWS
// can identify who sent them. You sign requests with your AWS access key, which
// consists of an access key ID and a secret access key. We strongly recommend
// that you don't create an access key for your root account. Anyone who has
// the access key for your root account has unrestricted access to all the resources
// in your account. Instead, create an access key for an IAM user account that
// has the permissions required for the task at hand. As another option, use
// AWS Security Token Service to generate temporary security credentials, and
// use those credentials to sign requests.
//
// To sign requests, you must use Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
// If you have an existing application that uses Signature Version 2, you must
// update it to use Signature Version 4.
//
// When you use the AWS Command Line Interface (AWS CLI) or one of the AWS SDKs
// to make requests to AWS, these tools automatically sign the requests for
// you with the access key that you specify when you configure the tools.
//
// Support and Feedback for AWS Secrets Manager
//
// We welcome your feedback. Send your comments to awssecretsmanager-feedback@amazon.com
// (mailto:awssecretsmanager-feedback@amazon.com), or post your feedback and
// questions in the AWS Secrets Manager Discussion Forum (http://forums.aws.amazon.com/forum.jspa?forumID=296).
// For more information about the AWS Discussion Forums, see Forums Help (http://forums.aws.amazon.com/help.jspa).
//
// How examples are presented
//
// The JSON that AWS Secrets Manager returns as a response to your requests
// is a single long string without line breaks or white space formatting. Both
// line breaks and white space are included in the examples in this guide to
// improve readability. When example input parameters would also result in long
// strings that extend beyond the screen, we insert line breaks to enhance readability.
// You should always submit the input as a single JSON text string.
//
// Logging API Requests
//
// AWS Secrets Manager supports AWS CloudTrail, a service that records AWS API
// calls for your AWS account and delivers log files to an Amazon S3 bucket.
// By using information that's collected by AWS CloudTrail, you can determine
// which requests were successfully made to AWS Secrets Manager, who made the
// request, when it was made, and so on. For more about AWS Secrets Manager
// and its support for AWS CloudTrail, see Logging AWS Secrets Manager Events
// with AWS CloudTrail (http://docs.aws.amazon.com/secretsmanager/latest/userguide/orgs_cloudtrail-integration.html)
// in the AWS Secrets Manager User Guide. To learn more about CloudTrail, including
// how to turn it on and find your log files, see the AWS CloudTrail User Guide
// (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
//
// See https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17 for more information on this service.
//
// See secretsmanager package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/secretsmanager/
//
// Using the Client
//
// To contact AWS Secrets Manager with the SDK use the New function to create
// a new service client. With that client you can make API requests to the service.
// These clients are safe to use concurrently.
//
// See the SDK's documentation for more information on how to use the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws.Config documentation for more information on configuring SDK clients.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the AWS Secrets Manager client SecretsManager for more
// information on creating client for this service.
// https://docs.aws.amazon.com/sdk-for-go/api/service/secretsmanager/#New
package secretsmanager
