// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateContactWithAddressBook = "AssociateContactWithAddressBook"

// AssociateContactWithAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the AssociateContactWithAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateContactWithAddressBook for more information on using the AssociateContactWithAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateContactWithAddressBookRequest method.
//    req, resp := client.AssociateContactWithAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook
func (c *AlexaForBusiness) AssociateContactWithAddressBookRequest(input *AssociateContactWithAddressBookInput) (req *request.Request, output *AssociateContactWithAddressBookOutput) {
	op := &request.Operation{
		Name:       opAssociateContactWithAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateContactWithAddressBookInput{}
	}

	output = &AssociateContactWithAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateContactWithAddressBook API operation for Alexa For Business.
//
// Associates a contact to a given address book.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateContactWithAddressBook for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook
func (c *AlexaForBusiness) AssociateContactWithAddressBook(input *AssociateContactWithAddressBookInput) (*AssociateContactWithAddressBookOutput, error) {
	req, out := c.AssociateContactWithAddressBookRequest(input)
	return out, req.Send()
}

// AssociateContactWithAddressBookWithContext is the same as AssociateContactWithAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateContactWithAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateContactWithAddressBookWithContext(ctx aws.Context, input *AssociateContactWithAddressBookInput, opts ...request.Option) (*AssociateContactWithAddressBookOutput, error) {
	req, out := c.AssociateContactWithAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateDeviceWithRoom = "AssociateDeviceWithRoom"

// AssociateDeviceWithRoomRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDeviceWithRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDeviceWithRoom for more information on using the AssociateDeviceWithRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDeviceWithRoomRequest method.
//    req, resp := client.AssociateDeviceWithRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom
func (c *AlexaForBusiness) AssociateDeviceWithRoomRequest(input *AssociateDeviceWithRoomInput) (req *request.Request, output *AssociateDeviceWithRoomOutput) {
	op := &request.Operation{
		Name:       opAssociateDeviceWithRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDeviceWithRoomInput{}
	}

	output = &AssociateDeviceWithRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateDeviceWithRoom API operation for Alexa For Business.
//
// Associates a device to a given room. This applies all the settings from the
// room profile to the device, and all the skills in any skill groups added
// to that room. This operation requires the device to be online, or a manual
// sync is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateDeviceWithRoom for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You are performing an action that would put you beyond your account's limits.
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom
func (c *AlexaForBusiness) AssociateDeviceWithRoom(input *AssociateDeviceWithRoomInput) (*AssociateDeviceWithRoomOutput, error) {
	req, out := c.AssociateDeviceWithRoomRequest(input)
	return out, req.Send()
}

// AssociateDeviceWithRoomWithContext is the same as AssociateDeviceWithRoom with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDeviceWithRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateDeviceWithRoomWithContext(ctx aws.Context, input *AssociateDeviceWithRoomInput, opts ...request.Option) (*AssociateDeviceWithRoomOutput, error) {
	req, out := c.AssociateDeviceWithRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSkillGroupWithRoom = "AssociateSkillGroupWithRoom"

// AssociateSkillGroupWithRoomRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSkillGroupWithRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSkillGroupWithRoom for more information on using the AssociateSkillGroupWithRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSkillGroupWithRoomRequest method.
//    req, resp := client.AssociateSkillGroupWithRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom
func (c *AlexaForBusiness) AssociateSkillGroupWithRoomRequest(input *AssociateSkillGroupWithRoomInput) (req *request.Request, output *AssociateSkillGroupWithRoomOutput) {
	op := &request.Operation{
		Name:       opAssociateSkillGroupWithRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSkillGroupWithRoomInput{}
	}

	output = &AssociateSkillGroupWithRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSkillGroupWithRoom API operation for Alexa For Business.
//
// Associates a skill group to a given room. This enables all skills in the
// associated skill group on all devices in the room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateSkillGroupWithRoom for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom
func (c *AlexaForBusiness) AssociateSkillGroupWithRoom(input *AssociateSkillGroupWithRoomInput) (*AssociateSkillGroupWithRoomOutput, error) {
	req, out := c.AssociateSkillGroupWithRoomRequest(input)
	return out, req.Send()
}

// AssociateSkillGroupWithRoomWithContext is the same as AssociateSkillGroupWithRoom with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSkillGroupWithRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateSkillGroupWithRoomWithContext(ctx aws.Context, input *AssociateSkillGroupWithRoomInput, opts ...request.Option) (*AssociateSkillGroupWithRoomOutput, error) {
	req, out := c.AssociateSkillGroupWithRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddressBook = "CreateAddressBook"

// CreateAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddressBook for more information on using the CreateAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAddressBookRequest method.
//    req, resp := client.CreateAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook
func (c *AlexaForBusiness) CreateAddressBookRequest(input *CreateAddressBookInput) (req *request.Request, output *CreateAddressBookOutput) {
	op := &request.Operation{
		Name:       opCreateAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddressBookInput{}
	}

	output = &CreateAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddressBook API operation for Alexa For Business.
//
// Creates an address book with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateAddressBook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   The resource being created already exists. HTTP Status Code: 400
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You are performing an action that would put you beyond your account's limits.
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook
func (c *AlexaForBusiness) CreateAddressBook(input *CreateAddressBookInput) (*CreateAddressBookOutput, error) {
	req, out := c.CreateAddressBookRequest(input)
	return out, req.Send()
}

// CreateAddressBookWithContext is the same as CreateAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateAddressBookWithContext(ctx aws.Context, input *CreateAddressBookInput, opts ...request.Option) (*CreateAddressBookOutput, error) {
	req, out := c.CreateAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContact = "CreateContact"

// CreateContactRequest generates a "aws/request.Request" representing the
// client's request for the CreateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContact for more information on using the CreateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContactRequest method.
//    req, resp := client.CreateContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact
func (c *AlexaForBusiness) CreateContactRequest(input *CreateContactInput) (req *request.Request, output *CreateContactOutput) {
	op := &request.Operation{
		Name:       opCreateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactInput{}
	}

	output = &CreateContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContact API operation for Alexa For Business.
//
// Creates a contact with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateContact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   The resource being created already exists. HTTP Status Code: 400
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You are performing an action that would put you beyond your account's limits.
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact
func (c *AlexaForBusiness) CreateContact(input *CreateContactInput) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	return out, req.Send()
}

// CreateContactWithContext is the same as CreateContact with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateContactWithContext(ctx aws.Context, input *CreateContactInput, opts ...request.Option) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProfileRequest method.
//    req, resp := client.CreateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile
func (c *AlexaForBusiness) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for Alexa For Business.
//
// Creates a new room profile with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You are performing an action that would put you beyond your account's limits.
//   HTTP Status Code: 400
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   The resource being created already exists. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile
func (c *AlexaForBusiness) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoom = "CreateRoom"

// CreateRoomRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoom for more information on using the CreateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRoomRequest method.
//    req, resp := client.CreateRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom
func (c *AlexaForBusiness) CreateRoomRequest(input *CreateRoomInput) (req *request.Request, output *CreateRoomOutput) {
	op := &request.Operation{
		Name:       opCreateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRoomInput{}
	}

	output = &CreateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoom API operation for Alexa For Business.
//
// Creates a room with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateRoom for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   The resource being created already exists. HTTP Status Code: 400
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You are performing an action that would put you beyond your account's limits.
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom
func (c *AlexaForBusiness) CreateRoom(input *CreateRoomInput) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	return out, req.Send()
}

// CreateRoomWithContext is the same as CreateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateRoomWithContext(ctx aws.Context, input *CreateRoomInput, opts ...request.Option) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSkillGroup = "CreateSkillGroup"

// CreateSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSkillGroup for more information on using the CreateSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSkillGroupRequest method.
//    req, resp := client.CreateSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup
func (c *AlexaForBusiness) CreateSkillGroupRequest(input *CreateSkillGroupInput) (req *request.Request, output *CreateSkillGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSkillGroupInput{}
	}

	output = &CreateSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSkillGroup API operation for Alexa For Business.
//
// Creates a skill group with a specified name and description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateSkillGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   The resource being created already exists. HTTP Status Code: 400
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You are performing an action that would put you beyond your account's limits.
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup
func (c *AlexaForBusiness) CreateSkillGroup(input *CreateSkillGroupInput) (*CreateSkillGroupOutput, error) {
	req, out := c.CreateSkillGroupRequest(input)
	return out, req.Send()
}

// CreateSkillGroupWithContext is the same as CreateSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateSkillGroupWithContext(ctx aws.Context, input *CreateSkillGroupInput, opts ...request.Option) (*CreateSkillGroupOutput, error) {
	req, out := c.CreateSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser
func (c *AlexaForBusiness) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Alexa For Business.
//
// Creates a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource in the request is already in use. HTTP Status Code: 400
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You are performing an action that would put you beyond your account's limits.
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser
func (c *AlexaForBusiness) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAddressBook = "DeleteAddressBook"

// DeleteAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAddressBook for more information on using the DeleteAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAddressBookRequest method.
//    req, resp := client.DeleteAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook
func (c *AlexaForBusiness) DeleteAddressBookRequest(input *DeleteAddressBookInput) (req *request.Request, output *DeleteAddressBookOutput) {
	op := &request.Operation{
		Name:       opDeleteAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAddressBookInput{}
	}

	output = &DeleteAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAddressBook API operation for Alexa For Business.
//
// Deletes an address book by the address book ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteAddressBook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook
func (c *AlexaForBusiness) DeleteAddressBook(input *DeleteAddressBookInput) (*DeleteAddressBookOutput, error) {
	req, out := c.DeleteAddressBookRequest(input)
	return out, req.Send()
}

// DeleteAddressBookWithContext is the same as DeleteAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteAddressBookWithContext(ctx aws.Context, input *DeleteAddressBookInput, opts ...request.Option) (*DeleteAddressBookOutput, error) {
	req, out := c.DeleteAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContact = "DeleteContact"

// DeleteContactRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContact for more information on using the DeleteContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContactRequest method.
//    req, resp := client.DeleteContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact
func (c *AlexaForBusiness) DeleteContactRequest(input *DeleteContactInput) (req *request.Request, output *DeleteContactOutput) {
	op := &request.Operation{
		Name:       opDeleteContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactInput{}
	}

	output = &DeleteContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteContact API operation for Alexa For Business.
//
// Deletes a contact by the contact ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteContact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact
func (c *AlexaForBusiness) DeleteContact(input *DeleteContactInput) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	return out, req.Send()
}

// DeleteContactWithContext is the same as DeleteContact with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteContactWithContext(ctx aws.Context, input *DeleteContactInput, opts ...request.Option) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProfileRequest method.
//    req, resp := client.DeleteProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile
func (c *AlexaForBusiness) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfile API operation for Alexa For Business.
//
// Deletes a room profile by the profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile
func (c *AlexaForBusiness) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoom = "DeleteRoom"

// DeleteRoomRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoom for more information on using the DeleteRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoomRequest method.
//    req, resp := client.DeleteRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom
func (c *AlexaForBusiness) DeleteRoomRequest(input *DeleteRoomInput) (req *request.Request, output *DeleteRoomOutput) {
	op := &request.Operation{
		Name:       opDeleteRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRoomInput{}
	}

	output = &DeleteRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoom API operation for Alexa For Business.
//
// Deletes a room by the room ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteRoom for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom
func (c *AlexaForBusiness) DeleteRoom(input *DeleteRoomInput) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	return out, req.Send()
}

// DeleteRoomWithContext is the same as DeleteRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteRoomWithContext(ctx aws.Context, input *DeleteRoomInput, opts ...request.Option) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoomSkillParameter = "DeleteRoomSkillParameter"

// DeleteRoomSkillParameterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoomSkillParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoomSkillParameter for more information on using the DeleteRoomSkillParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoomSkillParameterRequest method.
//    req, resp := client.DeleteRoomSkillParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter
func (c *AlexaForBusiness) DeleteRoomSkillParameterRequest(input *DeleteRoomSkillParameterInput) (req *request.Request, output *DeleteRoomSkillParameterOutput) {
	op := &request.Operation{
		Name:       opDeleteRoomSkillParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRoomSkillParameterInput{}
	}

	output = &DeleteRoomSkillParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoomSkillParameter API operation for Alexa For Business.
//
// Deletes room skill parameter details by room, skill, and parameter key ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteRoomSkillParameter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter
func (c *AlexaForBusiness) DeleteRoomSkillParameter(input *DeleteRoomSkillParameterInput) (*DeleteRoomSkillParameterOutput, error) {
	req, out := c.DeleteRoomSkillParameterRequest(input)
	return out, req.Send()
}

// DeleteRoomSkillParameterWithContext is the same as DeleteRoomSkillParameter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoomSkillParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteRoomSkillParameterWithContext(ctx aws.Context, input *DeleteRoomSkillParameterInput, opts ...request.Option) (*DeleteRoomSkillParameterOutput, error) {
	req, out := c.DeleteRoomSkillParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSkillGroup = "DeleteSkillGroup"

// DeleteSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSkillGroup for more information on using the DeleteSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSkillGroupRequest method.
//    req, resp := client.DeleteSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup
func (c *AlexaForBusiness) DeleteSkillGroupRequest(input *DeleteSkillGroupInput) (req *request.Request, output *DeleteSkillGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSkillGroupInput{}
	}

	output = &DeleteSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSkillGroup API operation for Alexa For Business.
//
// Deletes a skill group by skill group ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteSkillGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup
func (c *AlexaForBusiness) DeleteSkillGroup(input *DeleteSkillGroupInput) (*DeleteSkillGroupOutput, error) {
	req, out := c.DeleteSkillGroupRequest(input)
	return out, req.Send()
}

// DeleteSkillGroupWithContext is the same as DeleteSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteSkillGroupWithContext(ctx aws.Context, input *DeleteSkillGroupInput, opts ...request.Option) (*DeleteSkillGroupOutput, error) {
	req, out := c.DeleteSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser
func (c *AlexaForBusiness) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Alexa For Business.
//
// Deletes a specified user by user ARN and enrollment ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser
func (c *AlexaForBusiness) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateContactFromAddressBook = "DisassociateContactFromAddressBook"

// DisassociateContactFromAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateContactFromAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateContactFromAddressBook for more information on using the DisassociateContactFromAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateContactFromAddressBookRequest method.
//    req, resp := client.DisassociateContactFromAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook
func (c *AlexaForBusiness) DisassociateContactFromAddressBookRequest(input *DisassociateContactFromAddressBookInput) (req *request.Request, output *DisassociateContactFromAddressBookOutput) {
	op := &request.Operation{
		Name:       opDisassociateContactFromAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateContactFromAddressBookInput{}
	}

	output = &DisassociateContactFromAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateContactFromAddressBook API operation for Alexa For Business.
//
// Disassociates a contact from a given address book.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateContactFromAddressBook for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook
func (c *AlexaForBusiness) DisassociateContactFromAddressBook(input *DisassociateContactFromAddressBookInput) (*DisassociateContactFromAddressBookOutput, error) {
	req, out := c.DisassociateContactFromAddressBookRequest(input)
	return out, req.Send()
}

// DisassociateContactFromAddressBookWithContext is the same as DisassociateContactFromAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateContactFromAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateContactFromAddressBookWithContext(ctx aws.Context, input *DisassociateContactFromAddressBookInput, opts ...request.Option) (*DisassociateContactFromAddressBookOutput, error) {
	req, out := c.DisassociateContactFromAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDeviceFromRoom = "DisassociateDeviceFromRoom"

// DisassociateDeviceFromRoomRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDeviceFromRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDeviceFromRoom for more information on using the DisassociateDeviceFromRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateDeviceFromRoomRequest method.
//    req, resp := client.DisassociateDeviceFromRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom
func (c *AlexaForBusiness) DisassociateDeviceFromRoomRequest(input *DisassociateDeviceFromRoomInput) (req *request.Request, output *DisassociateDeviceFromRoomOutput) {
	op := &request.Operation{
		Name:       opDisassociateDeviceFromRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateDeviceFromRoomInput{}
	}

	output = &DisassociateDeviceFromRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateDeviceFromRoom API operation for Alexa For Business.
//
// Disassociates a device from its current room. The device continues to be
// connected to the Wi-Fi network and is still registered to the account. The
// device settings and skills are removed from the room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateDeviceFromRoom for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom
func (c *AlexaForBusiness) DisassociateDeviceFromRoom(input *DisassociateDeviceFromRoomInput) (*DisassociateDeviceFromRoomOutput, error) {
	req, out := c.DisassociateDeviceFromRoomRequest(input)
	return out, req.Send()
}

// DisassociateDeviceFromRoomWithContext is the same as DisassociateDeviceFromRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDeviceFromRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateDeviceFromRoomWithContext(ctx aws.Context, input *DisassociateDeviceFromRoomInput, opts ...request.Option) (*DisassociateDeviceFromRoomOutput, error) {
	req, out := c.DisassociateDeviceFromRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSkillGroupFromRoom = "DisassociateSkillGroupFromRoom"

// DisassociateSkillGroupFromRoomRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSkillGroupFromRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSkillGroupFromRoom for more information on using the DisassociateSkillGroupFromRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateSkillGroupFromRoomRequest method.
//    req, resp := client.DisassociateSkillGroupFromRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom
func (c *AlexaForBusiness) DisassociateSkillGroupFromRoomRequest(input *DisassociateSkillGroupFromRoomInput) (req *request.Request, output *DisassociateSkillGroupFromRoomOutput) {
	op := &request.Operation{
		Name:       opDisassociateSkillGroupFromRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateSkillGroupFromRoomInput{}
	}

	output = &DisassociateSkillGroupFromRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateSkillGroupFromRoom API operation for Alexa For Business.
//
// Disassociates a skill group from a specified room. This disables all skills
// in the skill group on all devices in the room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateSkillGroupFromRoom for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom
func (c *AlexaForBusiness) DisassociateSkillGroupFromRoom(input *DisassociateSkillGroupFromRoomInput) (*DisassociateSkillGroupFromRoomOutput, error) {
	req, out := c.DisassociateSkillGroupFromRoomRequest(input)
	return out, req.Send()
}

// DisassociateSkillGroupFromRoomWithContext is the same as DisassociateSkillGroupFromRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSkillGroupFromRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateSkillGroupFromRoomWithContext(ctx aws.Context, input *DisassociateSkillGroupFromRoomInput, opts ...request.Option) (*DisassociateSkillGroupFromRoomOutput, error) {
	req, out := c.DisassociateSkillGroupFromRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAddressBook = "GetAddressBook"

// GetAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the GetAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAddressBook for more information on using the GetAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAddressBookRequest method.
//    req, resp := client.GetAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook
func (c *AlexaForBusiness) GetAddressBookRequest(input *GetAddressBookInput) (req *request.Request, output *GetAddressBookOutput) {
	op := &request.Operation{
		Name:       opGetAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAddressBookInput{}
	}

	output = &GetAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAddressBook API operation for Alexa For Business.
//
// Gets address the book details by the address book ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetAddressBook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook
func (c *AlexaForBusiness) GetAddressBook(input *GetAddressBookInput) (*GetAddressBookOutput, error) {
	req, out := c.GetAddressBookRequest(input)
	return out, req.Send()
}

// GetAddressBookWithContext is the same as GetAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See GetAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetAddressBookWithContext(ctx aws.Context, input *GetAddressBookInput, opts ...request.Option) (*GetAddressBookOutput, error) {
	req, out := c.GetAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContact = "GetContact"

// GetContactRequest generates a "aws/request.Request" representing the
// client's request for the GetContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContact for more information on using the GetContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContactRequest method.
//    req, resp := client.GetContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact
func (c *AlexaForBusiness) GetContactRequest(input *GetContactInput) (req *request.Request, output *GetContactOutput) {
	op := &request.Operation{
		Name:       opGetContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactInput{}
	}

	output = &GetContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContact API operation for Alexa For Business.
//
// Gets the contact details by the contact ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetContact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact
func (c *AlexaForBusiness) GetContact(input *GetContactInput) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	return out, req.Send()
}

// GetContactWithContext is the same as GetContact with the addition of
// the ability to pass a context and additional request options.
//
// See GetContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetContactWithContext(ctx aws.Context, input *GetContactInput, opts ...request.Option) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevice for more information on using the GetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceRequest method.
//    req, resp := client.GetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice
func (c *AlexaForBusiness) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevice API operation for Alexa For Business.
//
// Gets the details of a device by device ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice
func (c *AlexaForBusiness) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	return out, req.Send()
}

// GetDeviceWithContext is the same as GetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetDeviceWithContext(ctx aws.Context, input *GetDeviceInput, opts ...request.Option) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfile = "GetProfile"

// GetProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfile for more information on using the GetProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProfileRequest method.
//    req, resp := client.GetProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile
func (c *AlexaForBusiness) GetProfileRequest(input *GetProfileInput) (req *request.Request, output *GetProfileOutput) {
	op := &request.Operation{
		Name:       opGetProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProfileInput{}
	}

	output = &GetProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfile API operation for Alexa For Business.
//
// Gets the details of a room profile by profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile
func (c *AlexaForBusiness) GetProfile(input *GetProfileInput) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	return out, req.Send()
}

// GetProfileWithContext is the same as GetProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetProfileWithContext(ctx aws.Context, input *GetProfileInput, opts ...request.Option) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoom = "GetRoom"

// GetRoomRequest generates a "aws/request.Request" representing the
// client's request for the GetRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoom for more information on using the GetRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRoomRequest method.
//    req, resp := client.GetRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom
func (c *AlexaForBusiness) GetRoomRequest(input *GetRoomInput) (req *request.Request, output *GetRoomOutput) {
	op := &request.Operation{
		Name:       opGetRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoomInput{}
	}

	output = &GetRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoom API operation for Alexa For Business.
//
// Gets room details by room ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetRoom for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom
func (c *AlexaForBusiness) GetRoom(input *GetRoomInput) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	return out, req.Send()
}

// GetRoomWithContext is the same as GetRoom with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetRoomWithContext(ctx aws.Context, input *GetRoomInput, opts ...request.Option) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoomSkillParameter = "GetRoomSkillParameter"

// GetRoomSkillParameterRequest generates a "aws/request.Request" representing the
// client's request for the GetRoomSkillParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoomSkillParameter for more information on using the GetRoomSkillParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRoomSkillParameterRequest method.
//    req, resp := client.GetRoomSkillParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter
func (c *AlexaForBusiness) GetRoomSkillParameterRequest(input *GetRoomSkillParameterInput) (req *request.Request, output *GetRoomSkillParameterOutput) {
	op := &request.Operation{
		Name:       opGetRoomSkillParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoomSkillParameterInput{}
	}

	output = &GetRoomSkillParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoomSkillParameter API operation for Alexa For Business.
//
// Gets room skill parameter details by room, skill, and parameter key ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetRoomSkillParameter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter
func (c *AlexaForBusiness) GetRoomSkillParameter(input *GetRoomSkillParameterInput) (*GetRoomSkillParameterOutput, error) {
	req, out := c.GetRoomSkillParameterRequest(input)
	return out, req.Send()
}

// GetRoomSkillParameterWithContext is the same as GetRoomSkillParameter with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoomSkillParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetRoomSkillParameterWithContext(ctx aws.Context, input *GetRoomSkillParameterInput, opts ...request.Option) (*GetRoomSkillParameterOutput, error) {
	req, out := c.GetRoomSkillParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSkillGroup = "GetSkillGroup"

// GetSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSkillGroup for more information on using the GetSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSkillGroupRequest method.
//    req, resp := client.GetSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup
func (c *AlexaForBusiness) GetSkillGroupRequest(input *GetSkillGroupInput) (req *request.Request, output *GetSkillGroupOutput) {
	op := &request.Operation{
		Name:       opGetSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSkillGroupInput{}
	}

	output = &GetSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSkillGroup API operation for Alexa For Business.
//
// Gets skill group details by skill group ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetSkillGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup
func (c *AlexaForBusiness) GetSkillGroup(input *GetSkillGroupInput) (*GetSkillGroupOutput, error) {
	req, out := c.GetSkillGroupRequest(input)
	return out, req.Send()
}

// GetSkillGroupWithContext is the same as GetSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetSkillGroupWithContext(ctx aws.Context, input *GetSkillGroupInput, opts ...request.Option) (*GetSkillGroupOutput, error) {
	req, out := c.GetSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSkills = "ListSkills"

// ListSkillsRequest generates a "aws/request.Request" representing the
// client's request for the ListSkills operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSkills for more information on using the ListSkills
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSkillsRequest method.
//    req, resp := client.ListSkillsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills
func (c *AlexaForBusiness) ListSkillsRequest(input *ListSkillsInput) (req *request.Request, output *ListSkillsOutput) {
	op := &request.Operation{
		Name:       opListSkills,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSkillsInput{}
	}

	output = &ListSkillsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSkills API operation for Alexa For Business.
//
// Lists all enabled skills in a specific skill group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListSkills for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills
func (c *AlexaForBusiness) ListSkills(input *ListSkillsInput) (*ListSkillsOutput, error) {
	req, out := c.ListSkillsRequest(input)
	return out, req.Send()
}

// ListSkillsWithContext is the same as ListSkills with the addition of
// the ability to pass a context and additional request options.
//
// See ListSkills for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsWithContext(ctx aws.Context, input *ListSkillsInput, opts ...request.Option) (*ListSkillsOutput, error) {
	req, out := c.ListSkillsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSkillsPages iterates over the pages of a ListSkills operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSkills method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSkills operation.
//    pageNum := 0
//    err := client.ListSkillsPages(params,
//        func(page *ListSkillsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListSkillsPages(input *ListSkillsInput, fn func(*ListSkillsOutput, bool) bool) error {
	return c.ListSkillsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSkillsPagesWithContext same as ListSkillsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsPagesWithContext(ctx aws.Context, input *ListSkillsInput, fn func(*ListSkillsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSkillsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSkillsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSkillsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags
func (c *AlexaForBusiness) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Alexa For Business.
//
// Lists all tags for a specific resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags
func (c *AlexaForBusiness) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTagsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutRoomSkillParameter = "PutRoomSkillParameter"

// PutRoomSkillParameterRequest generates a "aws/request.Request" representing the
// client's request for the PutRoomSkillParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRoomSkillParameter for more information on using the PutRoomSkillParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRoomSkillParameterRequest method.
//    req, resp := client.PutRoomSkillParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter
func (c *AlexaForBusiness) PutRoomSkillParameterRequest(input *PutRoomSkillParameterInput) (req *request.Request, output *PutRoomSkillParameterOutput) {
	op := &request.Operation{
		Name:       opPutRoomSkillParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRoomSkillParameterInput{}
	}

	output = &PutRoomSkillParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRoomSkillParameter API operation for Alexa For Business.
//
// Updates room skill parameter details by room, skill, and parameter key ID.
// Not all skills have a room skill parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation PutRoomSkillParameter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter
func (c *AlexaForBusiness) PutRoomSkillParameter(input *PutRoomSkillParameterInput) (*PutRoomSkillParameterOutput, error) {
	req, out := c.PutRoomSkillParameterRequest(input)
	return out, req.Send()
}

// PutRoomSkillParameterWithContext is the same as PutRoomSkillParameter with the addition of
// the ability to pass a context and additional request options.
//
// See PutRoomSkillParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) PutRoomSkillParameterWithContext(ctx aws.Context, input *PutRoomSkillParameterInput, opts ...request.Option) (*PutRoomSkillParameterOutput, error) {
	req, out := c.PutRoomSkillParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveRoom = "ResolveRoom"

// ResolveRoomRequest generates a "aws/request.Request" representing the
// client's request for the ResolveRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveRoom for more information on using the ResolveRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResolveRoomRequest method.
//    req, resp := client.ResolveRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom
func (c *AlexaForBusiness) ResolveRoomRequest(input *ResolveRoomInput) (req *request.Request, output *ResolveRoomOutput) {
	op := &request.Operation{
		Name:       opResolveRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveRoomInput{}
	}

	output = &ResolveRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveRoom API operation for Alexa For Business.
//
// Determines the details for the room from which a skill request was invoked.
// This operation is used by skill developers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ResolveRoom for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom
func (c *AlexaForBusiness) ResolveRoom(input *ResolveRoomInput) (*ResolveRoomOutput, error) {
	req, out := c.ResolveRoomRequest(input)
	return out, req.Send()
}

// ResolveRoomWithContext is the same as ResolveRoom with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ResolveRoomWithContext(ctx aws.Context, input *ResolveRoomInput, opts ...request.Option) (*ResolveRoomOutput, error) {
	req, out := c.ResolveRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeInvitation = "RevokeInvitation"

// RevokeInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RevokeInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeInvitation for more information on using the RevokeInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeInvitationRequest method.
//    req, resp := client.RevokeInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation
func (c *AlexaForBusiness) RevokeInvitationRequest(input *RevokeInvitationInput) (req *request.Request, output *RevokeInvitationOutput) {
	op := &request.Operation{
		Name:       opRevokeInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeInvitationInput{}
	}

	output = &RevokeInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeInvitation API operation for Alexa For Business.
//
// Revokes an invitation and invalidates the enrollment URL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation RevokeInvitation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation
func (c *AlexaForBusiness) RevokeInvitation(input *RevokeInvitationInput) (*RevokeInvitationOutput, error) {
	req, out := c.RevokeInvitationRequest(input)
	return out, req.Send()
}

// RevokeInvitationWithContext is the same as RevokeInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) RevokeInvitationWithContext(ctx aws.Context, input *RevokeInvitationInput, opts ...request.Option) (*RevokeInvitationOutput, error) {
	req, out := c.RevokeInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAddressBooks = "SearchAddressBooks"

// SearchAddressBooksRequest generates a "aws/request.Request" representing the
// client's request for the SearchAddressBooks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAddressBooks for more information on using the SearchAddressBooks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchAddressBooksRequest method.
//    req, resp := client.SearchAddressBooksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks
func (c *AlexaForBusiness) SearchAddressBooksRequest(input *SearchAddressBooksInput) (req *request.Request, output *SearchAddressBooksOutput) {
	op := &request.Operation{
		Name:       opSearchAddressBooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAddressBooksInput{}
	}

	output = &SearchAddressBooksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAddressBooks API operation for Alexa For Business.
//
// Searches address books and lists the ones that meet a set of filter and sort
// criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchAddressBooks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks
func (c *AlexaForBusiness) SearchAddressBooks(input *SearchAddressBooksInput) (*SearchAddressBooksOutput, error) {
	req, out := c.SearchAddressBooksRequest(input)
	return out, req.Send()
}

// SearchAddressBooksWithContext is the same as SearchAddressBooks with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAddressBooks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchAddressBooksWithContext(ctx aws.Context, input *SearchAddressBooksInput, opts ...request.Option) (*SearchAddressBooksOutput, error) {
	req, out := c.SearchAddressBooksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAddressBooksPages iterates over the pages of a SearchAddressBooks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAddressBooks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchAddressBooks operation.
//    pageNum := 0
//    err := client.SearchAddressBooksPages(params,
//        func(page *SearchAddressBooksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchAddressBooksPages(input *SearchAddressBooksInput, fn func(*SearchAddressBooksOutput, bool) bool) error {
	return c.SearchAddressBooksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAddressBooksPagesWithContext same as SearchAddressBooksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchAddressBooksPagesWithContext(ctx aws.Context, input *SearchAddressBooksInput, fn func(*SearchAddressBooksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAddressBooksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAddressBooksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchAddressBooksOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchContacts = "SearchContacts"

// SearchContactsRequest generates a "aws/request.Request" representing the
// client's request for the SearchContacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchContacts for more information on using the SearchContacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchContactsRequest method.
//    req, resp := client.SearchContactsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts
func (c *AlexaForBusiness) SearchContactsRequest(input *SearchContactsInput) (req *request.Request, output *SearchContactsOutput) {
	op := &request.Operation{
		Name:       opSearchContacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchContactsInput{}
	}

	output = &SearchContactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchContacts API operation for Alexa For Business.
//
// Searches contacts and lists the ones that meet a set of filter and sort criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchContacts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts
func (c *AlexaForBusiness) SearchContacts(input *SearchContactsInput) (*SearchContactsOutput, error) {
	req, out := c.SearchContactsRequest(input)
	return out, req.Send()
}

// SearchContactsWithContext is the same as SearchContacts with the addition of
// the ability to pass a context and additional request options.
//
// See SearchContacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchContactsWithContext(ctx aws.Context, input *SearchContactsInput, opts ...request.Option) (*SearchContactsOutput, error) {
	req, out := c.SearchContactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchContactsPages iterates over the pages of a SearchContacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchContacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchContacts operation.
//    pageNum := 0
//    err := client.SearchContactsPages(params,
//        func(page *SearchContactsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchContactsPages(input *SearchContactsInput, fn func(*SearchContactsOutput, bool) bool) error {
	return c.SearchContactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchContactsPagesWithContext same as SearchContactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchContactsPagesWithContext(ctx aws.Context, input *SearchContactsInput, fn func(*SearchContactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchContactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchContactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchContactsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchDevices = "SearchDevices"

// SearchDevicesRequest generates a "aws/request.Request" representing the
// client's request for the SearchDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDevices for more information on using the SearchDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchDevicesRequest method.
//    req, resp := client.SearchDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices
func (c *AlexaForBusiness) SearchDevicesRequest(input *SearchDevicesInput) (req *request.Request, output *SearchDevicesOutput) {
	op := &request.Operation{
		Name:       opSearchDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDevicesInput{}
	}

	output = &SearchDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDevices API operation for Alexa For Business.
//
// Searches devices and lists the ones that meet a set of filter criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchDevices for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices
func (c *AlexaForBusiness) SearchDevices(input *SearchDevicesInput) (*SearchDevicesOutput, error) {
	req, out := c.SearchDevicesRequest(input)
	return out, req.Send()
}

// SearchDevicesWithContext is the same as SearchDevices with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchDevicesWithContext(ctx aws.Context, input *SearchDevicesInput, opts ...request.Option) (*SearchDevicesOutput, error) {
	req, out := c.SearchDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDevicesPages iterates over the pages of a SearchDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchDevices operation.
//    pageNum := 0
//    err := client.SearchDevicesPages(params,
//        func(page *SearchDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchDevicesPages(input *SearchDevicesInput, fn func(*SearchDevicesOutput, bool) bool) error {
	return c.SearchDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDevicesPagesWithContext same as SearchDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchDevicesPagesWithContext(ctx aws.Context, input *SearchDevicesInput, fn func(*SearchDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchDevicesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchProfiles = "SearchProfiles"

// SearchProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchProfiles for more information on using the SearchProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchProfilesRequest method.
//    req, resp := client.SearchProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles
func (c *AlexaForBusiness) SearchProfilesRequest(input *SearchProfilesInput) (req *request.Request, output *SearchProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchProfilesInput{}
	}

	output = &SearchProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchProfiles API operation for Alexa For Business.
//
// Searches room profiles and lists the ones that meet a set of filter criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchProfiles for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles
func (c *AlexaForBusiness) SearchProfiles(input *SearchProfilesInput) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	return out, req.Send()
}

// SearchProfilesWithContext is the same as SearchProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchProfilesWithContext(ctx aws.Context, input *SearchProfilesInput, opts ...request.Option) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchProfilesPages iterates over the pages of a SearchProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchProfiles operation.
//    pageNum := 0
//    err := client.SearchProfilesPages(params,
//        func(page *SearchProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchProfilesPages(input *SearchProfilesInput, fn func(*SearchProfilesOutput, bool) bool) error {
	return c.SearchProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchProfilesPagesWithContext same as SearchProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchProfilesPagesWithContext(ctx aws.Context, input *SearchProfilesInput, fn func(*SearchProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchProfilesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchRooms = "SearchRooms"

// SearchRoomsRequest generates a "aws/request.Request" representing the
// client's request for the SearchRooms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchRooms for more information on using the SearchRooms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchRoomsRequest method.
//    req, resp := client.SearchRoomsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms
func (c *AlexaForBusiness) SearchRoomsRequest(input *SearchRoomsInput) (req *request.Request, output *SearchRoomsOutput) {
	op := &request.Operation{
		Name:       opSearchRooms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchRoomsInput{}
	}

	output = &SearchRoomsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchRooms API operation for Alexa For Business.
//
// Searches rooms and lists the ones that meet a set of filter and sort criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchRooms for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms
func (c *AlexaForBusiness) SearchRooms(input *SearchRoomsInput) (*SearchRoomsOutput, error) {
	req, out := c.SearchRoomsRequest(input)
	return out, req.Send()
}

// SearchRoomsWithContext is the same as SearchRooms with the addition of
// the ability to pass a context and additional request options.
//
// See SearchRooms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchRoomsWithContext(ctx aws.Context, input *SearchRoomsInput, opts ...request.Option) (*SearchRoomsOutput, error) {
	req, out := c.SearchRoomsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchRoomsPages iterates over the pages of a SearchRooms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchRooms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchRooms operation.
//    pageNum := 0
//    err := client.SearchRoomsPages(params,
//        func(page *SearchRoomsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchRoomsPages(input *SearchRoomsInput, fn func(*SearchRoomsOutput, bool) bool) error {
	return c.SearchRoomsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchRoomsPagesWithContext same as SearchRoomsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchRoomsPagesWithContext(ctx aws.Context, input *SearchRoomsInput, fn func(*SearchRoomsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchRoomsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRoomsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchRoomsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchSkillGroups = "SearchSkillGroups"

// SearchSkillGroupsRequest generates a "aws/request.Request" representing the
// client's request for the SearchSkillGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSkillGroups for more information on using the SearchSkillGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchSkillGroupsRequest method.
//    req, resp := client.SearchSkillGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups
func (c *AlexaForBusiness) SearchSkillGroupsRequest(input *SearchSkillGroupsInput) (req *request.Request, output *SearchSkillGroupsOutput) {
	op := &request.Operation{
		Name:       opSearchSkillGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSkillGroupsInput{}
	}

	output = &SearchSkillGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchSkillGroups API operation for Alexa For Business.
//
// Searches skill groups and lists the ones that meet a set of filter and sort
// criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchSkillGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups
func (c *AlexaForBusiness) SearchSkillGroups(input *SearchSkillGroupsInput) (*SearchSkillGroupsOutput, error) {
	req, out := c.SearchSkillGroupsRequest(input)
	return out, req.Send()
}

// SearchSkillGroupsWithContext is the same as SearchSkillGroups with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSkillGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchSkillGroupsWithContext(ctx aws.Context, input *SearchSkillGroupsInput, opts ...request.Option) (*SearchSkillGroupsOutput, error) {
	req, out := c.SearchSkillGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchSkillGroupsPages iterates over the pages of a SearchSkillGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchSkillGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchSkillGroups operation.
//    pageNum := 0
//    err := client.SearchSkillGroupsPages(params,
//        func(page *SearchSkillGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchSkillGroupsPages(input *SearchSkillGroupsInput, fn func(*SearchSkillGroupsOutput, bool) bool) error {
	return c.SearchSkillGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchSkillGroupsPagesWithContext same as SearchSkillGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchSkillGroupsPagesWithContext(ctx aws.Context, input *SearchSkillGroupsInput, fn func(*SearchSkillGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchSkillGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchSkillGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchSkillGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchUsers = "SearchUsers"

// SearchUsersRequest generates a "aws/request.Request" representing the
// client's request for the SearchUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchUsers for more information on using the SearchUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchUsersRequest method.
//    req, resp := client.SearchUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers
func (c *AlexaForBusiness) SearchUsersRequest(input *SearchUsersInput) (req *request.Request, output *SearchUsersOutput) {
	op := &request.Operation{
		Name:       opSearchUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchUsersInput{}
	}

	output = &SearchUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchUsers API operation for Alexa For Business.
//
// Searches users and lists the ones that meet a set of filter and sort criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchUsers for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers
func (c *AlexaForBusiness) SearchUsers(input *SearchUsersInput) (*SearchUsersOutput, error) {
	req, out := c.SearchUsersRequest(input)
	return out, req.Send()
}

// SearchUsersWithContext is the same as SearchUsers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchUsersWithContext(ctx aws.Context, input *SearchUsersInput, opts ...request.Option) (*SearchUsersOutput, error) {
	req, out := c.SearchUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchUsersPages iterates over the pages of a SearchUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchUsers operation.
//    pageNum := 0
//    err := client.SearchUsersPages(params,
//        func(page *SearchUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchUsersPages(input *SearchUsersInput, fn func(*SearchUsersOutput, bool) bool) error {
	return c.SearchUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchUsersPagesWithContext same as SearchUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchUsersPagesWithContext(ctx aws.Context, input *SearchUsersInput, fn func(*SearchUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchUsersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSendInvitation = "SendInvitation"

// SendInvitationRequest generates a "aws/request.Request" representing the
// client's request for the SendInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendInvitation for more information on using the SendInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendInvitationRequest method.
//    req, resp := client.SendInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation
func (c *AlexaForBusiness) SendInvitationRequest(input *SendInvitationInput) (req *request.Request, output *SendInvitationOutput) {
	op := &request.Operation{
		Name:       opSendInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendInvitationInput{}
	}

	output = &SendInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendInvitation API operation for Alexa For Business.
//
// Sends an enrollment invitation email with a URL to a user. The URL is valid
// for 72 hours or until you call this operation again, whichever comes first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SendInvitation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
//   * ErrCodeInvalidUserStatusException "InvalidUserStatusException"
//   The attempt to update a user is invalid due to the user's current status.
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation
func (c *AlexaForBusiness) SendInvitation(input *SendInvitationInput) (*SendInvitationOutput, error) {
	req, out := c.SendInvitationRequest(input)
	return out, req.Send()
}

// SendInvitationWithContext is the same as SendInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See SendInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SendInvitationWithContext(ctx aws.Context, input *SendInvitationInput, opts ...request.Option) (*SendInvitationOutput, error) {
	req, out := c.SendInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDeviceSync = "StartDeviceSync"

// StartDeviceSyncRequest generates a "aws/request.Request" representing the
// client's request for the StartDeviceSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDeviceSync for more information on using the StartDeviceSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDeviceSyncRequest method.
//    req, resp := client.StartDeviceSyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync
func (c *AlexaForBusiness) StartDeviceSyncRequest(input *StartDeviceSyncInput) (req *request.Request, output *StartDeviceSyncOutput) {
	op := &request.Operation{
		Name:       opStartDeviceSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDeviceSyncInput{}
	}

	output = &StartDeviceSyncOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDeviceSync API operation for Alexa For Business.
//
// Resets a device and its account to the known default settings by clearing
// all information and settings set by previous users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation StartDeviceSync for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync
func (c *AlexaForBusiness) StartDeviceSync(input *StartDeviceSyncInput) (*StartDeviceSyncOutput, error) {
	req, out := c.StartDeviceSyncRequest(input)
	return out, req.Send()
}

// StartDeviceSyncWithContext is the same as StartDeviceSync with the addition of
// the ability to pass a context and additional request options.
//
// See StartDeviceSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) StartDeviceSyncWithContext(ctx aws.Context, input *StartDeviceSyncInput, opts ...request.Option) (*StartDeviceSyncOutput, error) {
	req, out := c.StartDeviceSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource
func (c *AlexaForBusiness) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Alexa For Business.
//
// Adds metadata tags to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource
func (c *AlexaForBusiness) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource
func (c *AlexaForBusiness) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Alexa For Business.
//
// Removes metadata tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource
func (c *AlexaForBusiness) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAddressBook = "UpdateAddressBook"

// UpdateAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAddressBook for more information on using the UpdateAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAddressBookRequest method.
//    req, resp := client.UpdateAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook
func (c *AlexaForBusiness) UpdateAddressBookRequest(input *UpdateAddressBookInput) (req *request.Request, output *UpdateAddressBookOutput) {
	op := &request.Operation{
		Name:       opUpdateAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAddressBookInput{}
	}

	output = &UpdateAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAddressBook API operation for Alexa For Business.
//
// Updates address book details by the address book ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateAddressBook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
//   * ErrCodeNameInUseException "NameInUseException"
//   The name sent in the request is already in use. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook
func (c *AlexaForBusiness) UpdateAddressBook(input *UpdateAddressBookInput) (*UpdateAddressBookOutput, error) {
	req, out := c.UpdateAddressBookRequest(input)
	return out, req.Send()
}

// UpdateAddressBookWithContext is the same as UpdateAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateAddressBookWithContext(ctx aws.Context, input *UpdateAddressBookInput, opts ...request.Option) (*UpdateAddressBookOutput, error) {
	req, out := c.UpdateAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContact = "UpdateContact"

// UpdateContactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContact for more information on using the UpdateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContactRequest method.
//    req, resp := client.UpdateContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact
func (c *AlexaForBusiness) UpdateContactRequest(input *UpdateContactInput) (req *request.Request, output *UpdateContactOutput) {
	op := &request.Operation{
		Name:       opUpdateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContactInput{}
	}

	output = &UpdateContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContact API operation for Alexa For Business.
//
// Updates the contact details by the contact ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateContact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact
func (c *AlexaForBusiness) UpdateContact(input *UpdateContactInput) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	return out, req.Send()
}

// UpdateContactWithContext is the same as UpdateContact with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateContactWithContext(ctx aws.Context, input *UpdateContactInput, opts ...request.Option) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevice = "UpdateDevice"

// UpdateDeviceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevice for more information on using the UpdateDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceRequest method.
//    req, resp := client.UpdateDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice
func (c *AlexaForBusiness) UpdateDeviceRequest(input *UpdateDeviceInput) (req *request.Request, output *UpdateDeviceOutput) {
	op := &request.Operation{
		Name:       opUpdateDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceInput{}
	}

	output = &UpdateDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDevice API operation for Alexa For Business.
//
// Updates the device name by device ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice
func (c *AlexaForBusiness) UpdateDevice(input *UpdateDeviceInput) (*UpdateDeviceOutput, error) {
	req, out := c.UpdateDeviceRequest(input)
	return out, req.Send()
}

// UpdateDeviceWithContext is the same as UpdateDevice with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateDeviceWithContext(ctx aws.Context, input *UpdateDeviceInput, opts ...request.Option) (*UpdateDeviceOutput, error) {
	req, out := c.UpdateDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfile for more information on using the UpdateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProfileRequest method.
//    req, resp := client.UpdateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile
func (c *AlexaForBusiness) UpdateProfileRequest(input *UpdateProfileInput) (req *request.Request, output *UpdateProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	output = &UpdateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfile API operation for Alexa For Business.
//
// Updates an existing room profile by room profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
//   * ErrCodeNameInUseException "NameInUseException"
//   The name sent in the request is already in use. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile
func (c *AlexaForBusiness) UpdateProfile(input *UpdateProfileInput) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	return out, req.Send()
}

// UpdateProfileWithContext is the same as UpdateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateProfileWithContext(ctx aws.Context, input *UpdateProfileInput, opts ...request.Option) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoom = "UpdateRoom"

// UpdateRoomRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoom for more information on using the UpdateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoomRequest method.
//    req, resp := client.UpdateRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom
func (c *AlexaForBusiness) UpdateRoomRequest(input *UpdateRoomInput) (req *request.Request, output *UpdateRoomOutput) {
	op := &request.Operation{
		Name:       opUpdateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRoomInput{}
	}

	output = &UpdateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoom API operation for Alexa For Business.
//
// Updates room details by room ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateRoom for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
//   * ErrCodeNameInUseException "NameInUseException"
//   The name sent in the request is already in use. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom
func (c *AlexaForBusiness) UpdateRoom(input *UpdateRoomInput) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	return out, req.Send()
}

// UpdateRoomWithContext is the same as UpdateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateRoomWithContext(ctx aws.Context, input *UpdateRoomInput, opts ...request.Option) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSkillGroup = "UpdateSkillGroup"

// UpdateSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSkillGroup for more information on using the UpdateSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSkillGroupRequest method.
//    req, resp := client.UpdateSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup
func (c *AlexaForBusiness) UpdateSkillGroupRequest(input *UpdateSkillGroupInput) (req *request.Request, output *UpdateSkillGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSkillGroupInput{}
	}

	output = &UpdateSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSkillGroup API operation for Alexa For Business.
//
// Updates skill group details by skill group ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateSkillGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource is not found. HTTP Status Code: 400
//
//   * ErrCodeNameInUseException "NameInUseException"
//   The name sent in the request is already in use. HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup
func (c *AlexaForBusiness) UpdateSkillGroup(input *UpdateSkillGroupInput) (*UpdateSkillGroupOutput, error) {
	req, out := c.UpdateSkillGroupRequest(input)
	return out, req.Send()
}

// UpdateSkillGroupWithContext is the same as UpdateSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateSkillGroupWithContext(ctx aws.Context, input *UpdateSkillGroupInput, opts ...request.Option) (*UpdateSkillGroupOutput, error) {
	req, out := c.UpdateSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An address book with attributes.
type AddressBook struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AddressBook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressBook) GoString() string {
	return s.String()
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *AddressBook) SetAddressBookArn(v string) *AddressBook {
	s.AddressBookArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddressBook) SetDescription(v string) *AddressBook {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddressBook) SetName(v string) *AddressBook {
	s.Name = &v
	return s
}

// Information related to an address book.
type AddressBookData struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AddressBookData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressBookData) GoString() string {
	return s.String()
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *AddressBookData) SetAddressBookArn(v string) *AddressBookData {
	s.AddressBookArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddressBookData) SetDescription(v string) *AddressBookData {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddressBookData) SetName(v string) *AddressBookData {
	s.Name = &v
	return s
}

type AssociateContactWithAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book with which to associate the contact.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The ARN of the contact to associate with an address book.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateContactWithAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateContactWithAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateContactWithAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateContactWithAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *AssociateContactWithAddressBookInput) SetAddressBookArn(v string) *AssociateContactWithAddressBookInput {
	s.AddressBookArn = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *AssociateContactWithAddressBookInput) SetContactArn(v string) *AssociateContactWithAddressBookInput {
	s.ContactArn = &v
	return s
}

type AssociateContactWithAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateContactWithAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateContactWithAddressBookOutput) GoString() string {
	return s.String()
}

type AssociateDeviceWithRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to associate to a room. Required.
	DeviceArn *string `type:"string"`

	// The ARN of the room with which to associate the device. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation
func (s AssociateDeviceWithRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDeviceWithRoomInput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *AssociateDeviceWithRoomInput) SetDeviceArn(v string) *AssociateDeviceWithRoomInput {
	s.DeviceArn = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *AssociateDeviceWithRoomInput) SetRoomArn(v string) *AssociateDeviceWithRoomInput {
	s.RoomArn = &v
	return s
}

type AssociateDeviceWithRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDeviceWithRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDeviceWithRoomOutput) GoString() string {
	return s.String()
}

type AssociateSkillGroupWithRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room with which to associate the skill group. Required.
	RoomArn *string `type:"string"`

	// The ARN of the skill group to associate with a room. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s AssociateSkillGroupWithRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSkillGroupWithRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *AssociateSkillGroupWithRoomInput) SetRoomArn(v string) *AssociateSkillGroupWithRoomInput {
	s.RoomArn = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *AssociateSkillGroupWithRoomInput) SetSkillGroupArn(v string) *AssociateSkillGroupWithRoomInput {
	s.SkillGroupArn = &v
	return s
}

type AssociateSkillGroupWithRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateSkillGroupWithRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSkillGroupWithRoomOutput) GoString() string {
	return s.String()
}

// A contact with attributes.
type Contact struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact.
	ContactArn *string `type:"string"`

	// The name of the contact to display on the AWS management console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact that is used to call the contact on the device.
	FirstName *string `min:"1" type:"string"`

	// The last name of the contact that is used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact.
	PhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s Contact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Contact) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *Contact) SetContactArn(v string) *Contact {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Contact) SetDisplayName(v string) *Contact {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *Contact) SetFirstName(v string) *Contact {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *Contact) SetLastName(v string) *Contact {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Contact) SetPhoneNumber(v string) *Contact {
	s.PhoneNumber = &v
	return s
}

// Information related to a contact.
type ContactData struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact.
	ContactArn *string `type:"string"`

	// The name of the contact to display on the AWS management console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact that is used to call the contact on the device.
	FirstName *string `min:"1" type:"string"`

	// The last name of the contact that is used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact.
	PhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s ContactData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactData) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *ContactData) SetContactArn(v string) *ContactData {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ContactData) SetDisplayName(v string) *ContactData {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *ContactData) SetFirstName(v string) *ContactData {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *ContactData) SetLastName(v string) *ContactData {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *ContactData) SetPhoneNumber(v string) *ContactData {
	s.PhoneNumber = &v
	return s
}

type CreateAddressBookInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for the request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddressBookInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAddressBookInput) SetClientRequestToken(v string) *CreateAddressBookInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAddressBookInput) SetDescription(v string) *CreateAddressBookInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAddressBookInput) SetName(v string) *CreateAddressBookInput {
	s.Name = &v
	return s
}

type CreateAddressBookOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created address book.
	AddressBookArn *string `type:"string"`
}

// String returns the string representation
func (s CreateAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddressBookOutput) GoString() string {
	return s.String()
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *CreateAddressBookOutput) SetAddressBookArn(v string) *CreateAddressBookOutput {
	s.AddressBookArn = &v
	return s
}

type CreateContactInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The name of the contact to display on the AWS management console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact that is used to call the contact on the device.
	//
	// FirstName is a required field
	FirstName *string `min:"1" type:"string" required:"true"`

	// The last name of the contact that is used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact in E164 format.
	//
	// PhoneNumber is a required field
	PhoneNumber *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FirstName == nil {
		invalidParams.Add(request.NewErrParamRequired("FirstName"))
	}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}
	if s.PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateContactInput) SetClientRequestToken(v string) *CreateContactInput {
	s.ClientRequestToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateContactInput) SetDisplayName(v string) *CreateContactInput {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateContactInput) SetFirstName(v string) *CreateContactInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateContactInput) SetLastName(v string) *CreateContactInput {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *CreateContactInput) SetPhoneNumber(v string) *CreateContactInput {
	s.PhoneNumber = &v
	return s
}

type CreateContactOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created address book.
	ContactArn *string `type:"string"`
}

// String returns the string representation
func (s CreateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContactOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *CreateContactOutput) SetContactArn(v string) *CreateContactOutput {
	s.ContactArn = &v
	return s
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// The valid address for the room.
	//
	// Address is a required field
	Address *string `min:"1" type:"string" required:"true"`

	// The user-specified token that is used during the creation of a profile.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The distance unit to be used by devices in the profile.
	//
	// DistanceUnit is a required field
	DistanceUnit *string `type:"string" required:"true" enum:"DistanceUnit"`

	// The maximum volume limit for a room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// Whether PSTN calling is enabled.
	PSTNEnabled *bool `type:"boolean"`

	// The name of a room profile.
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// Whether room profile setup is enabled.
	SetupModeDisabled *bool `type:"boolean"`

	// The temperature unit to be used by devices in the profile.
	//
	// TemperatureUnit is a required field
	TemperatureUnit *string `type:"string" required:"true" enum:"TemperatureUnit"`

	// The time zone used by a room profile.
	//
	// Timezone is a required field
	Timezone *string `min:"1" type:"string" required:"true"`

	// A wake word for Alexa, Echo, Amazon, or a computer.
	//
	// WakeWord is a required field
	WakeWord *string `type:"string" required:"true" enum:"WakeWord"`
}

// String returns the string representation
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.Address != nil && len(*s.Address) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.DistanceUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("DistanceUnit"))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 1))
	}
	if s.TemperatureUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("TemperatureUnit"))
	}
	if s.Timezone == nil {
		invalidParams.Add(request.NewErrParamRequired("Timezone"))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 1))
	}
	if s.WakeWord == nil {
		invalidParams.Add(request.NewErrParamRequired("WakeWord"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *CreateProfileInput) SetAddress(v string) *CreateProfileInput {
	s.Address = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProfileInput) SetClientRequestToken(v string) *CreateProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *CreateProfileInput) SetDistanceUnit(v string) *CreateProfileInput {
	s.DistanceUnit = &v
	return s
}

// SetMaxVolumeLimit sets the MaxVolumeLimit field's value.
func (s *CreateProfileInput) SetMaxVolumeLimit(v int64) *CreateProfileInput {
	s.MaxVolumeLimit = &v
	return s
}

// SetPSTNEnabled sets the PSTNEnabled field's value.
func (s *CreateProfileInput) SetPSTNEnabled(v bool) *CreateProfileInput {
	s.PSTNEnabled = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *CreateProfileInput) SetProfileName(v string) *CreateProfileInput {
	s.ProfileName = &v
	return s
}

// SetSetupModeDisabled sets the SetupModeDisabled field's value.
func (s *CreateProfileInput) SetSetupModeDisabled(v bool) *CreateProfileInput {
	s.SetupModeDisabled = &v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *CreateProfileInput) SetTemperatureUnit(v string) *CreateProfileInput {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *CreateProfileInput) SetTimezone(v string) *CreateProfileInput {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *CreateProfileInput) SetWakeWord(v string) *CreateProfileInput {
	s.WakeWord = &v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created room profile in the response.
	ProfileArn *string `type:"string"`
}

// String returns the string representation
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateProfileOutput) SetProfileArn(v string) *CreateProfileOutput {
	s.ProfileArn = &v
	return s
}

type CreateRoomInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description for the room.
	Description *string `min:"1" type:"string"`

	// The profile ARN for the room.
	ProfileArn *string `type:"string"`

	// The calendar ARN for the room.
	ProviderCalendarId *string `type:"string"`

	// The name for the room.
	//
	// RoomName is a required field
	RoomName *string `min:"1" type:"string" required:"true"`

	// The tags for the room.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoomInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoomName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomName"))
	}
	if s.RoomName != nil && len(*s.RoomName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateRoomInput) SetClientRequestToken(v string) *CreateRoomInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRoomInput) SetDescription(v string) *CreateRoomInput {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateRoomInput) SetProfileArn(v string) *CreateRoomInput {
	s.ProfileArn = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *CreateRoomInput) SetProviderCalendarId(v string) *CreateRoomInput {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *CreateRoomInput) SetRoomName(v string) *CreateRoomInput {
	s.RoomName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRoomInput) SetTags(v []*Tag) *CreateRoomInput {
	s.Tags = v
	return s
}

type CreateRoomOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created room in the response.
	RoomArn *string `type:"string"`
}

// String returns the string representation
func (s CreateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoomOutput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *CreateRoomOutput) SetRoomArn(v string) *CreateRoomOutput {
	s.RoomArn = &v
	return s
}

type CreateSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description for the skill group.
	Description *string `min:"1" type:"string"`

	// The name for the skill group.
	//
	// SkillGroupName is a required field
	SkillGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSkillGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSkillGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSkillGroupInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.SkillGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillGroupName"))
	}
	if s.SkillGroupName != nil && len(*s.SkillGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SkillGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateSkillGroupInput) SetClientRequestToken(v string) *CreateSkillGroupInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSkillGroupInput) SetDescription(v string) *CreateSkillGroupInput {
	s.Description = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *CreateSkillGroupInput) SetSkillGroupName(v string) *CreateSkillGroupInput {
	s.SkillGroupName = &v
	return s
}

type CreateSkillGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created skill group in the response.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s CreateSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSkillGroupOutput) GoString() string {
	return s.String()
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *CreateSkillGroupOutput) SetSkillGroupArn(v string) *CreateSkillGroupOutput {
	s.SkillGroupArn = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The email address for the user.
	Email *string `min:"1" type:"string"`

	// The first name for the user.
	FirstName *string `type:"string"`

	// The last name for the user.
	LastName *string `type:"string"`

	// The tags for the user.
	Tags []*Tag `type:"list"`

	// The ARN for the user.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateUserInput) SetClientRequestToken(v string) *CreateUserInput {
	s.ClientRequestToken = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateUserInput) SetEmail(v string) *CreateUserInput {
	s.Email = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateUserInput) SetFirstName(v string) *CreateUserInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateUserInput) SetLastName(v string) *CreateUserInput {
	s.LastName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v []*Tag) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserInput) SetUserId(v string) *CreateUserInput {
	s.UserId = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created user in the response.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserOutput) SetUserArn(v string) *CreateUserOutput {
	s.UserArn = &v
	return s
}

type DeleteAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book to delete.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *DeleteAddressBookInput) SetAddressBookArn(v string) *DeleteAddressBookInput {
	s.AddressBookArn = &v
	return s
}

type DeleteAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAddressBookOutput) GoString() string {
	return s.String()
}

type DeleteContactInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact to delete.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContactInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *DeleteContactInput) SetContactArn(v string) *DeleteContactInput {
	s.ContactArn = &v
	return s
}

type DeleteContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContactOutput) GoString() string {
	return s.String()
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room profile to delete. Required.
	ProfileArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *DeleteProfileInput) SetProfileArn(v string) *DeleteProfileInput {
	s.ProfileArn = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

type DeleteRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room to delete. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *DeleteRoomInput) SetRoomArn(v string) *DeleteRoomInput {
	s.RoomArn = &v
	return s
}

type DeleteRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomOutput) GoString() string {
	return s.String()
}

type DeleteRoomSkillParameterInput struct {
	_ struct{} `type:"structure"`

	// The room skill parameter key for which to remove details.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The ARN of the room from which to remove the room skill parameter details.
	RoomArn *string `type:"string"`

	// The ID of the skill from which to remove the room skill parameter details.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoomSkillParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomSkillParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoomSkillParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoomSkillParameterInput"}
	if s.ParameterKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterKey", 1))
	}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterKey sets the ParameterKey field's value.
func (s *DeleteRoomSkillParameterInput) SetParameterKey(v string) *DeleteRoomSkillParameterInput {
	s.ParameterKey = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *DeleteRoomSkillParameterInput) SetRoomArn(v string) *DeleteRoomSkillParameterInput {
	s.RoomArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *DeleteRoomSkillParameterInput) SetSkillId(v string) *DeleteRoomSkillParameterInput {
	s.SkillId = &v
	return s
}

type DeleteRoomSkillParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoomSkillParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomSkillParameterOutput) GoString() string {
	return s.String()
}

type DeleteSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill group to delete. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSkillGroupInput) GoString() string {
	return s.String()
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *DeleteSkillGroupInput) SetSkillGroupArn(v string) *DeleteSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

type DeleteSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSkillGroupOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user's enrollment in the organization. Required.
	//
	// EnrollmentId is a required field
	EnrollmentId *string `type:"string" required:"true"`

	// The ARN of the user to delete in the organization. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.EnrollmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnrollmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnrollmentId sets the EnrollmentId field's value.
func (s *DeleteUserInput) SetEnrollmentId(v string) *DeleteUserInput {
	s.EnrollmentId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DeleteUserInput) SetUserArn(v string) *DeleteUserInput {
	s.UserArn = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// A device with attributes.
type Device struct {
	_ struct{} `type:"structure"`

	// The ARN of a device.
	DeviceArn *string `type:"string"`

	// The name of a device.
	DeviceName *string `min:"2" type:"string"`

	// The serial number of a device.
	DeviceSerialNumber *string `type:"string"`

	// The status of a device. If the status is not READY, check the DeviceStatusInfo
	// for details.
	DeviceStatus *string `type:"string" enum:"DeviceStatus"`

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo `type:"structure"`

	// The type of a device.
	DeviceType *string `type:"string"`

	// The MAC address of a device.
	MacAddress *string `type:"string"`

	// The room ARN of a device.
	RoomArn *string `type:"string"`

	// The software version of a device.
	SoftwareVersion *string `type:"string"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Device) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *Device) SetDeviceArn(v string) *Device {
	s.DeviceArn = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *Device) SetDeviceName(v string) *Device {
	s.DeviceName = &v
	return s
}

// SetDeviceSerialNumber sets the DeviceSerialNumber field's value.
func (s *Device) SetDeviceSerialNumber(v string) *Device {
	s.DeviceSerialNumber = &v
	return s
}

// SetDeviceStatus sets the DeviceStatus field's value.
func (s *Device) SetDeviceStatus(v string) *Device {
	s.DeviceStatus = &v
	return s
}

// SetDeviceStatusInfo sets the DeviceStatusInfo field's value.
func (s *Device) SetDeviceStatusInfo(v *DeviceStatusInfo) *Device {
	s.DeviceStatusInfo = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *Device) SetDeviceType(v string) *Device {
	s.DeviceType = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *Device) SetMacAddress(v string) *Device {
	s.MacAddress = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *Device) SetRoomArn(v string) *Device {
	s.RoomArn = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *Device) SetSoftwareVersion(v string) *Device {
	s.SoftwareVersion = &v
	return s
}

// Device attributes.
type DeviceData struct {
	_ struct{} `type:"structure"`

	// The ARN of a device.
	DeviceArn *string `type:"string"`

	// The name of a device.
	DeviceName *string `min:"2" type:"string"`

	// The serial number of a device.
	DeviceSerialNumber *string `type:"string"`

	// The status of a device.
	DeviceStatus *string `type:"string" enum:"DeviceStatus"`

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo `type:"structure"`

	// The type of a device.
	DeviceType *string `type:"string"`

	// The MAC address of a device.
	MacAddress *string `type:"string"`

	// The room ARN associated with a device.
	RoomArn *string `type:"string"`

	// The name of the room associated with a device.
	RoomName *string `min:"1" type:"string"`

	// The software version of a device.
	SoftwareVersion *string `type:"string"`
}

// String returns the string representation
func (s DeviceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceData) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DeviceData) SetDeviceArn(v string) *DeviceData {
	s.DeviceArn = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *DeviceData) SetDeviceName(v string) *DeviceData {
	s.DeviceName = &v
	return s
}

// SetDeviceSerialNumber sets the DeviceSerialNumber field's value.
func (s *DeviceData) SetDeviceSerialNumber(v string) *DeviceData {
	s.DeviceSerialNumber = &v
	return s
}

// SetDeviceStatus sets the DeviceStatus field's value.
func (s *DeviceData) SetDeviceStatus(v string) *DeviceData {
	s.DeviceStatus = &v
	return s
}

// SetDeviceStatusInfo sets the DeviceStatusInfo field's value.
func (s *DeviceData) SetDeviceStatusInfo(v *DeviceStatusInfo) *DeviceData {
	s.DeviceStatusInfo = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *DeviceData) SetDeviceType(v string) *DeviceData {
	s.DeviceType = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *DeviceData) SetMacAddress(v string) *DeviceData {
	s.MacAddress = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *DeviceData) SetRoomArn(v string) *DeviceData {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *DeviceData) SetRoomName(v string) *DeviceData {
	s.RoomName = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *DeviceData) SetSoftwareVersion(v string) *DeviceData {
	s.SoftwareVersion = &v
	return s
}

// Details of a device’s status.
type DeviceStatusDetail struct {
	_ struct{} `type:"structure"`

	// The device status detail code.
	Code *string `type:"string" enum:"DeviceStatusDetailCode"`
}

// String returns the string representation
func (s DeviceStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceStatusDetail) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *DeviceStatusDetail) SetCode(v string) *DeviceStatusDetail {
	s.Code = &v
	return s
}

// Detailed information about a device's status.
type DeviceStatusInfo struct {
	_ struct{} `type:"structure"`

	// One or more device status detail descriptions.
	DeviceStatusDetails []*DeviceStatusDetail `type:"list"`
}

// String returns the string representation
func (s DeviceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceStatusInfo) GoString() string {
	return s.String()
}

// SetDeviceStatusDetails sets the DeviceStatusDetails field's value.
func (s *DeviceStatusInfo) SetDeviceStatusDetails(v []*DeviceStatusDetail) *DeviceStatusInfo {
	s.DeviceStatusDetails = v
	return s
}

type DisassociateContactFromAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address from which to disassociate the contact.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The ARN of the contact to disassociate from an address book.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateContactFromAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateContactFromAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateContactFromAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateContactFromAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *DisassociateContactFromAddressBookInput) SetAddressBookArn(v string) *DisassociateContactFromAddressBookInput {
	s.AddressBookArn = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *DisassociateContactFromAddressBookInput) SetContactArn(v string) *DisassociateContactFromAddressBookInput {
	s.ContactArn = &v
	return s
}

type DisassociateContactFromAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateContactFromAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateContactFromAddressBookOutput) GoString() string {
	return s.String()
}

type DisassociateDeviceFromRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to disassociate from a room. Required.
	DeviceArn *string `type:"string"`
}

// String returns the string representation
func (s DisassociateDeviceFromRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDeviceFromRoomInput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DisassociateDeviceFromRoomInput) SetDeviceArn(v string) *DisassociateDeviceFromRoomInput {
	s.DeviceArn = &v
	return s
}

type DisassociateDeviceFromRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDeviceFromRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDeviceFromRoomOutput) GoString() string {
	return s.String()
}

type DisassociateSkillGroupFromRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room from which the skill group is to be disassociated. Required.
	RoomArn *string `type:"string"`

	// The ARN of the skill group to disassociate from a room. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s DisassociateSkillGroupFromRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateSkillGroupFromRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *DisassociateSkillGroupFromRoomInput) SetRoomArn(v string) *DisassociateSkillGroupFromRoomInput {
	s.RoomArn = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *DisassociateSkillGroupFromRoomInput) SetSkillGroupArn(v string) *DisassociateSkillGroupFromRoomInput {
	s.SkillGroupArn = &v
	return s
}

type DisassociateSkillGroupFromRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateSkillGroupFromRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateSkillGroupFromRoomOutput) GoString() string {
	return s.String()
}

// A filter name and value pair that is used to return a more specific list
// of results. Filters can be used to match a set of resources by various criteria.
type Filter struct {
	_ struct{} `type:"structure"`

	// The key of a filter.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The values of a filter.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Filter) SetKey(v string) *Filter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book for which to request details.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *GetAddressBookInput) SetAddressBookArn(v string) *GetAddressBookInput {
	s.AddressBookArn = &v
	return s
}

type GetAddressBookOutput struct {
	_ struct{} `type:"structure"`

	// The details of the requested address book.
	AddressBook *AddressBook `type:"structure"`
}

// String returns the string representation
func (s GetAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAddressBookOutput) GoString() string {
	return s.String()
}

// SetAddressBook sets the AddressBook field's value.
func (s *GetAddressBookOutput) SetAddressBook(v *AddressBook) *GetAddressBookOutput {
	s.AddressBook = v
	return s
}

type GetContactInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact for which to request details.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactInput) SetContactArn(v string) *GetContactInput {
	s.ContactArn = &v
	return s
}

type GetContactOutput struct {
	_ struct{} `type:"structure"`

	// The details of the requested contact.
	Contact *Contact `type:"structure"`
}

// String returns the string representation
func (s GetContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContactOutput) GoString() string {
	return s.String()
}

// SetContact sets the Contact field's value.
func (s *GetContactOutput) SetContact(v *Contact) *GetContactOutput {
	s.Contact = v
	return s
}

type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device for which to request details. Required.
	DeviceArn *string `type:"string"`
}

// String returns the string representation
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *GetDeviceInput) SetDeviceArn(v string) *GetDeviceInput {
	s.DeviceArn = &v
	return s
}

type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The details of the device requested. Required.
	Device *Device `type:"structure"`
}

// String returns the string representation
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *GetDeviceOutput) SetDevice(v *Device) *GetDeviceOutput {
	s.Device = v
	return s
}

type GetProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room profile for which to request details. Required.
	ProfileArn *string `type:"string"`
}

// String returns the string representation
func (s GetProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileInput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *GetProfileInput) SetProfileArn(v string) *GetProfileInput {
	s.ProfileArn = &v
	return s
}

type GetProfileOutput struct {
	_ struct{} `type:"structure"`

	// The details of the room profile requested. Required.
	Profile *Profile `type:"structure"`
}

// String returns the string representation
func (s GetProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *GetProfileOutput) SetProfile(v *Profile) *GetProfileOutput {
	s.Profile = v
	return s
}

type GetRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room for which to request details. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation
func (s GetRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *GetRoomInput) SetRoomArn(v string) *GetRoomInput {
	s.RoomArn = &v
	return s
}

type GetRoomOutput struct {
	_ struct{} `type:"structure"`

	// The details of the room requested.
	Room *Room `type:"structure"`
}

// String returns the string representation
func (s GetRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoomOutput) GoString() string {
	return s.String()
}

// SetRoom sets the Room field's value.
func (s *GetRoomOutput) SetRoom(v *Room) *GetRoomOutput {
	s.Room = v
	return s
}

type GetRoomSkillParameterInput struct {
	_ struct{} `type:"structure"`

	// The room skill parameter key for which to get details. Required.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The ARN of the room from which to get the room skill parameter details.
	RoomArn *string `type:"string"`

	// The ARN of the skill from which to get the room skill parameter details.
	// Required.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetRoomSkillParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoomSkillParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoomSkillParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoomSkillParameterInput"}
	if s.ParameterKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterKey", 1))
	}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterKey sets the ParameterKey field's value.
func (s *GetRoomSkillParameterInput) SetParameterKey(v string) *GetRoomSkillParameterInput {
	s.ParameterKey = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *GetRoomSkillParameterInput) SetRoomArn(v string) *GetRoomSkillParameterInput {
	s.RoomArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *GetRoomSkillParameterInput) SetSkillId(v string) *GetRoomSkillParameterInput {
	s.SkillId = &v
	return s
}

type GetRoomSkillParameterOutput struct {
	_ struct{} `type:"structure"`

	// The details of the room skill parameter requested. Required.
	RoomSkillParameter *RoomSkillParameter `type:"structure"`
}

// String returns the string representation
func (s GetRoomSkillParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoomSkillParameterOutput) GoString() string {
	return s.String()
}

// SetRoomSkillParameter sets the RoomSkillParameter field's value.
func (s *GetRoomSkillParameterOutput) SetRoomSkillParameter(v *RoomSkillParameter) *GetRoomSkillParameterOutput {
	s.RoomSkillParameter = v
	return s
}

type GetSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill group for which to get details. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s GetSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSkillGroupInput) GoString() string {
	return s.String()
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *GetSkillGroupInput) SetSkillGroupArn(v string) *GetSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

type GetSkillGroupOutput struct {
	_ struct{} `type:"structure"`

	// The details of the skill group requested. Required.
	SkillGroup *SkillGroup `type:"structure"`
}

// String returns the string representation
func (s GetSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSkillGroupOutput) GoString() string {
	return s.String()
}

// SetSkillGroup sets the SkillGroup field's value.
func (s *GetSkillGroupOutput) SetSkillGroup(v *SkillGroup) *GetSkillGroupOutput {
	s.SkillGroup = v
	return s
}

type ListSkillsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved. Required.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	// Required.
	NextToken *string `min:"1" type:"string"`

	// The ARN of the skill group for which to list enabled skills. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s ListSkillsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSkillsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSkillsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSkillsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSkillsInput) SetMaxResults(v int64) *ListSkillsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsInput) SetNextToken(v string) *ListSkillsInput {
	s.NextToken = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *ListSkillsInput) SetSkillGroupArn(v string) *ListSkillsInput {
	s.SkillGroupArn = &v
	return s
}

type ListSkillsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The list of enabled skills requested. Required.
	SkillSummaries []*SkillSummary `type:"list"`
}

// String returns the string representation
func (s ListSkillsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSkillsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsOutput) SetNextToken(v string) *ListSkillsOutput {
	s.NextToken = &v
	return s
}

// SetSkillSummaries sets the SkillSummaries field's value.
func (s *ListSkillsOutput) SetSkillSummaries(v []*SkillSummary) *ListSkillsOutput {
	s.SkillSummaries = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the specific resource for which to list tags. Required.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsInput) SetArn(v string) *ListTagsInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The list of tags requested for the specific resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v []*Tag) *ListTagsOutput {
	s.Tags = v
	return s
}

// A room profile with attributes.
type Profile struct {
	_ struct{} `type:"structure"`

	// The address of a room profile.
	Address *string `min:"1" type:"string"`

	// The distance unit of a room profile.
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// The max volume limit of a room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// The PSTN setting of a room profile.
	PSTNEnabled *bool `type:"boolean"`

	// The ARN of a room profile.
	ProfileArn *string `type:"string"`

	// The name of a room profile.
	ProfileName *string `min:"1" type:"string"`

	// The setup mode of a room profile.
	SetupModeDisabled *bool `type:"boolean"`

	// The temperature unit of a room profile.
	TemperatureUnit *string `type:"string" enum:"TemperatureUnit"`

	// The time zone of a room profile.
	Timezone *string `min:"1" type:"string"`

	// The wake word of a room profile.
	WakeWord *string `type:"string" enum:"WakeWord"`
}

// String returns the string representation
func (s Profile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Profile) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Profile) SetAddress(v string) *Profile {
	s.Address = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *Profile) SetDistanceUnit(v string) *Profile {
	s.DistanceUnit = &v
	return s
}

// SetMaxVolumeLimit sets the MaxVolumeLimit field's value.
func (s *Profile) SetMaxVolumeLimit(v int64) *Profile {
	s.MaxVolumeLimit = &v
	return s
}

// SetPSTNEnabled sets the PSTNEnabled field's value.
func (s *Profile) SetPSTNEnabled(v bool) *Profile {
	s.PSTNEnabled = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *Profile) SetProfileArn(v string) *Profile {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *Profile) SetProfileName(v string) *Profile {
	s.ProfileName = &v
	return s
}

// SetSetupModeDisabled sets the SetupModeDisabled field's value.
func (s *Profile) SetSetupModeDisabled(v bool) *Profile {
	s.SetupModeDisabled = &v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *Profile) SetTemperatureUnit(v string) *Profile {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *Profile) SetTimezone(v string) *Profile {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *Profile) SetWakeWord(v string) *Profile {
	s.WakeWord = &v
	return s
}

// The data of a room profile.
type ProfileData struct {
	_ struct{} `type:"structure"`

	// The address of a room profile.
	Address *string `min:"1" type:"string"`

	// The distance unit of a room profile.
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// The ARN of a room profile.
	ProfileArn *string `type:"string"`

	// The name of a room profile.
	ProfileName *string `min:"1" type:"string"`

	// The temperature unit of a room profile.
	TemperatureUnit *string `type:"string" enum:"TemperatureUnit"`

	// The timezone of a room profile.
	Timezone *string `min:"1" type:"string"`

	// The wake word of a room profile.
	WakeWord *string `type:"string" enum:"WakeWord"`
}

// String returns the string representation
func (s ProfileData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProfileData) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *ProfileData) SetAddress(v string) *ProfileData {
	s.Address = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *ProfileData) SetDistanceUnit(v string) *ProfileData {
	s.DistanceUnit = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ProfileData) SetProfileArn(v string) *ProfileData {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *ProfileData) SetProfileName(v string) *ProfileData {
	s.ProfileName = &v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *ProfileData) SetTemperatureUnit(v string) *ProfileData {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *ProfileData) SetTimezone(v string) *ProfileData {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *ProfileData) SetWakeWord(v string) *ProfileData {
	s.WakeWord = &v
	return s
}

type PutRoomSkillParameterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room associated with the room skill parameter. Required.
	RoomArn *string `type:"string"`

	// The updated room skill parameter. Required.
	//
	// RoomSkillParameter is a required field
	RoomSkillParameter *RoomSkillParameter `type:"structure" required:"true"`

	// The ARN of the skill associated with the room skill parameter. Required.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutRoomSkillParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRoomSkillParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRoomSkillParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRoomSkillParameterInput"}
	if s.RoomSkillParameter == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomSkillParameter"))
	}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}
	if s.RoomSkillParameter != nil {
		if err := s.RoomSkillParameter.Validate(); err != nil {
			invalidParams.AddNested("RoomSkillParameter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoomArn sets the RoomArn field's value.
func (s *PutRoomSkillParameterInput) SetRoomArn(v string) *PutRoomSkillParameterInput {
	s.RoomArn = &v
	return s
}

// SetRoomSkillParameter sets the RoomSkillParameter field's value.
func (s *PutRoomSkillParameterInput) SetRoomSkillParameter(v *RoomSkillParameter) *PutRoomSkillParameterInput {
	s.RoomSkillParameter = v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *PutRoomSkillParameterInput) SetSkillId(v string) *PutRoomSkillParameterInput {
	s.SkillId = &v
	return s
}

type PutRoomSkillParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRoomSkillParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRoomSkillParameterOutput) GoString() string {
	return s.String()
}

type ResolveRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill that was requested. Required.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`

	// The ARN of the user. Required.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResolveRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolveRoomInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillId sets the SkillId field's value.
func (s *ResolveRoomInput) SetSkillId(v string) *ResolveRoomInput {
	s.SkillId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ResolveRoomInput) SetUserId(v string) *ResolveRoomInput {
	s.UserId = &v
	return s
}

type ResolveRoomOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room from which the skill request was invoked.
	RoomArn *string `type:"string"`

	// The name of the room from which the skill request was invoked.
	RoomName *string `min:"1" type:"string"`

	// Response to get the room profile request. Required.
	RoomSkillParameters []*RoomSkillParameter `type:"list"`
}

// String returns the string representation
func (s ResolveRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveRoomOutput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *ResolveRoomOutput) SetRoomArn(v string) *ResolveRoomOutput {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *ResolveRoomOutput) SetRoomName(v string) *ResolveRoomOutput {
	s.RoomName = &v
	return s
}

// SetRoomSkillParameters sets the RoomSkillParameters field's value.
func (s *ResolveRoomOutput) SetRoomSkillParameters(v []*RoomSkillParameter) *ResolveRoomOutput {
	s.RoomSkillParameters = v
	return s
}

type RevokeInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the enrollment invitation to revoke. Required.
	EnrollmentId *string `type:"string"`

	// The ARN of the user for whom to revoke an enrollment invitation. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s RevokeInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeInvitationInput) GoString() string {
	return s.String()
}

// SetEnrollmentId sets the EnrollmentId field's value.
func (s *RevokeInvitationInput) SetEnrollmentId(v string) *RevokeInvitationInput {
	s.EnrollmentId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *RevokeInvitationInput) SetUserArn(v string) *RevokeInvitationInput {
	s.UserArn = &v
	return s
}

type RevokeInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeInvitationOutput) GoString() string {
	return s.String()
}

// A room with attributes.
type Room struct {
	_ struct{} `type:"structure"`

	// The description of a room.
	Description *string `min:"1" type:"string"`

	// The profile ARN of a room.
	ProfileArn *string `type:"string"`

	// The provider calendar ARN of a room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of a room.
	RoomArn *string `type:"string"`

	// The name of a room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Room) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Room) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Room) SetDescription(v string) *Room {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *Room) SetProfileArn(v string) *Room {
	s.ProfileArn = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *Room) SetProviderCalendarId(v string) *Room {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *Room) SetRoomArn(v string) *Room {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *Room) SetRoomName(v string) *Room {
	s.RoomName = &v
	return s
}

// The data of a room.
type RoomData struct {
	_ struct{} `type:"structure"`

	// The description of a room.
	Description *string `min:"1" type:"string"`

	// The profile ARN of a room.
	ProfileArn *string `type:"string"`

	// The profile name of a room.
	ProfileName *string `min:"1" type:"string"`

	// The provider calendar ARN of a room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of a room.
	RoomArn *string `type:"string"`

	// The name of a room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RoomData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoomData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *RoomData) SetDescription(v string) *RoomData {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *RoomData) SetProfileArn(v string) *RoomData {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *RoomData) SetProfileName(v string) *RoomData {
	s.ProfileName = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *RoomData) SetProviderCalendarId(v string) *RoomData {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *RoomData) SetRoomArn(v string) *RoomData {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *RoomData) SetRoomName(v string) *RoomData {
	s.RoomName = &v
	return s
}

// A skill parameter associated with a room.
type RoomSkillParameter struct {
	_ struct{} `type:"structure"`

	// The parameter key of a room skill parameter. ParameterKey is an enumerated
	// type that only takes “DEFAULT” or “SCOPE” as valid values.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The parameter value of a room skill parameter.
	//
	// ParameterValue is a required field
	ParameterValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RoomSkillParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoomSkillParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoomSkillParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RoomSkillParameter"}
	if s.ParameterKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterKey", 1))
	}
	if s.ParameterValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterValue"))
	}
	if s.ParameterValue != nil && len(*s.ParameterValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterKey sets the ParameterKey field's value.
func (s *RoomSkillParameter) SetParameterKey(v string) *RoomSkillParameter {
	s.ParameterKey = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *RoomSkillParameter) SetParameterValue(v string) *RoomSkillParameter {
	s.ParameterValue = &v
	return s
}

type SearchAddressBooksInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of address books. The supported
	// filter key is AddressBookName.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// only includes results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of address books. The
	// supported sort key is AddressBookName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation
func (s SearchAddressBooksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchAddressBooksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchAddressBooksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchAddressBooksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchAddressBooksInput) SetFilters(v []*Filter) *SearchAddressBooksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchAddressBooksInput) SetMaxResults(v int64) *SearchAddressBooksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAddressBooksInput) SetNextToken(v string) *SearchAddressBooksInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchAddressBooksInput) SetSortCriteria(v []*Sort) *SearchAddressBooksInput {
	s.SortCriteria = v
	return s
}

type SearchAddressBooksOutput struct {
	_ struct{} `type:"structure"`

	// The address books that meet the specified set of filter criteria, in sort
	// order.
	AddressBooks []*AddressBookData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of address books returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchAddressBooksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchAddressBooksOutput) GoString() string {
	return s.String()
}

// SetAddressBooks sets the AddressBooks field's value.
func (s *SearchAddressBooksOutput) SetAddressBooks(v []*AddressBookData) *SearchAddressBooksOutput {
	s.AddressBooks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAddressBooksOutput) SetNextToken(v string) *SearchAddressBooksOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchAddressBooksOutput) SetTotalCount(v int64) *SearchAddressBooksOutput {
	s.TotalCount = &v
	return s
}

type SearchContactsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of address books. The supported
	// filter keys are DisplayName, FirstName, LastName, and AddressBookArns.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// only includes results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of contacts. The supported
	// sort keys are DisplayName, FirstName, and LastName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation
func (s SearchContactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchContactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchContactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchContactsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchContactsInput) SetFilters(v []*Filter) *SearchContactsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchContactsInput) SetMaxResults(v int64) *SearchContactsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchContactsInput) SetNextToken(v string) *SearchContactsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchContactsInput) SetSortCriteria(v []*Sort) *SearchContactsInput {
	s.SortCriteria = v
	return s
}

type SearchContactsOutput struct {
	_ struct{} `type:"structure"`

	// The contacts that meet the specified set of filter criteria, in sort order.
	Contacts []*ContactData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of contacts returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchContactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchContactsOutput) GoString() string {
	return s.String()
}

// SetContacts sets the Contacts field's value.
func (s *SearchContactsOutput) SetContacts(v []*ContactData) *SearchContactsOutput {
	s.Contacts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchContactsOutput) SetNextToken(v string) *SearchContactsOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchContactsOutput) SetTotalCount(v int64) *SearchContactsOutput {
	s.TotalCount = &v
	return s
}

type SearchDevicesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of devices. Supported filter keys
	// are DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType,
	// DeviceSerialNumber, and UnassociatedOnly.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of devices. Supported
	// sort keys are DeviceName, DeviceStatus, RoomName, DeviceType, and DeviceSerialNumber.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation
func (s SearchDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchDevicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchDevicesInput) SetFilters(v []*Filter) *SearchDevicesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchDevicesInput) SetMaxResults(v int64) *SearchDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDevicesInput) SetNextToken(v string) *SearchDevicesInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchDevicesInput) SetSortCriteria(v []*Sort) *SearchDevicesInput {
	s.SortCriteria = v
	return s
}

type SearchDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices that meet the specified set of filter criteria, in sort order.
	Devices []*DeviceData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of devices returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *SearchDevicesOutput) SetDevices(v []*DeviceData) *SearchDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDevicesOutput) SetNextToken(v string) *SearchDevicesOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchDevicesOutput) SetTotalCount(v int64) *SearchDevicesOutput {
	s.TotalCount = &v
	return s
}

type SearchProfilesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of room profiles. Supported filter
	// keys are ProfileName and Address. Required.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of room profiles. Supported
	// sort keys are ProfileName and Address.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation
func (s SearchProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchProfilesInput) SetFilters(v []*Filter) *SearchProfilesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchProfilesInput) SetMaxResults(v int64) *SearchProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesInput) SetNextToken(v string) *SearchProfilesInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchProfilesInput) SetSortCriteria(v []*Sort) *SearchProfilesInput {
	s.SortCriteria = v
	return s
}

type SearchProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The profiles that meet the specified set of filter criteria, in sort order.
	Profiles []*ProfileData `type:"list"`

	// The total number of room profiles returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesOutput) SetNextToken(v string) *SearchProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *SearchProfilesOutput) SetProfiles(v []*ProfileData) *SearchProfilesOutput {
	s.Profiles = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchProfilesOutput) SetTotalCount(v int64) *SearchProfilesOutput {
	s.TotalCount = &v
	return s
}

type SearchRoomsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of rooms. The supported filter
	// keys are RoomName and ProfileName.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of rooms. The supported
	// sort keys are RoomName and ProfileName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation
func (s SearchRoomsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchRoomsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchRoomsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchRoomsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchRoomsInput) SetFilters(v []*Filter) *SearchRoomsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchRoomsInput) SetMaxResults(v int64) *SearchRoomsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRoomsInput) SetNextToken(v string) *SearchRoomsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchRoomsInput) SetSortCriteria(v []*Sort) *SearchRoomsInput {
	s.SortCriteria = v
	return s
}

type SearchRoomsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The rooms that meet the specified set of filter criteria, in sort order.
	Rooms []*RoomData `type:"list"`

	// The total number of rooms returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchRoomsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchRoomsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRoomsOutput) SetNextToken(v string) *SearchRoomsOutput {
	s.NextToken = &v
	return s
}

// SetRooms sets the Rooms field's value.
func (s *SearchRoomsOutput) SetRooms(v []*RoomData) *SearchRoomsOutput {
	s.Rooms = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchRoomsOutput) SetTotalCount(v int64) *SearchRoomsOutput {
	s.TotalCount = &v
	return s
}

type SearchSkillGroupsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of skill groups. The supported
	// filter key is SkillGroupName.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	// Required.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of skill groups. The supported
	// sort key is SkillGroupName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation
func (s SearchSkillGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchSkillGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSkillGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchSkillGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchSkillGroupsInput) SetFilters(v []*Filter) *SearchSkillGroupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchSkillGroupsInput) SetMaxResults(v int64) *SearchSkillGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSkillGroupsInput) SetNextToken(v string) *SearchSkillGroupsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchSkillGroupsInput) SetSortCriteria(v []*Sort) *SearchSkillGroupsInput {
	s.SortCriteria = v
	return s
}

type SearchSkillGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The skill groups that meet the filter criteria, in sort order.
	SkillGroups []*SkillGroupData `type:"list"`

	// The total number of skill groups returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchSkillGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchSkillGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSkillGroupsOutput) SetNextToken(v string) *SearchSkillGroupsOutput {
	s.NextToken = &v
	return s
}

// SetSkillGroups sets the SkillGroups field's value.
func (s *SearchSkillGroupsOutput) SetSkillGroups(v []*SkillGroupData) *SearchSkillGroupsOutput {
	s.SkillGroups = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchSkillGroupsOutput) SetTotalCount(v int64) *SearchSkillGroupsOutput {
	s.TotalCount = &v
	return s
}

type SearchUsersInput struct {
	_ struct{} `type:"structure"`

	// The filters to use for listing a specific set of users. Required. Supported
	// filter keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved. Required.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	// Required.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the filtered set of users. Required. Supported
	// sort keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation
func (s SearchUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchUsersInput) SetFilters(v []*Filter) *SearchUsersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchUsersInput) SetMaxResults(v int64) *SearchUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchUsersInput) SetNextToken(v string) *SearchUsersInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchUsersInput) SetSortCriteria(v []*Sort) *SearchUsersInput {
	s.SortCriteria = v
	return s
}

type SearchUsersOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of users returned.
	TotalCount *int64 `type:"integer"`

	// The users that meet the specified set of filter criteria, in sort order.
	Users []*UserData `type:"list"`
}

// String returns the string representation
func (s SearchUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchUsersOutput) SetNextToken(v string) *SearchUsersOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchUsersOutput) SetTotalCount(v int64) *SearchUsersOutput {
	s.TotalCount = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *SearchUsersOutput) SetUsers(v []*UserData) *SearchUsersOutput {
	s.Users = v
	return s
}

type SendInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user to whom to send an invitation. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s SendInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendInvitationInput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *SendInvitationInput) SetUserArn(v string) *SendInvitationInput {
	s.UserArn = &v
	return s
}

type SendInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendInvitationOutput) GoString() string {
	return s.String()
}

// A skill group with attributes.
type SkillGroup struct {
	_ struct{} `type:"structure"`

	// The description of a skill group.
	Description *string `min:"1" type:"string"`

	// The ARN of a skill group.
	SkillGroupArn *string `type:"string"`

	// The name of a skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SkillGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SkillGroup) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SkillGroup) SetDescription(v string) *SkillGroup {
	s.Description = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *SkillGroup) SetSkillGroupArn(v string) *SkillGroup {
	s.SkillGroupArn = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *SkillGroup) SetSkillGroupName(v string) *SkillGroup {
	s.SkillGroupName = &v
	return s
}

// The attributes of a skill group.
type SkillGroupData struct {
	_ struct{} `type:"structure"`

	// The description of a skill group.
	Description *string `min:"1" type:"string"`

	// The skill group ARN of a skill group.
	SkillGroupArn *string `type:"string"`

	// The skill group name of a skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SkillGroupData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SkillGroupData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SkillGroupData) SetDescription(v string) *SkillGroupData {
	s.Description = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *SkillGroupData) SetSkillGroupArn(v string) *SkillGroupData {
	s.SkillGroupArn = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *SkillGroupData) SetSkillGroupName(v string) *SkillGroupData {
	s.SkillGroupName = &v
	return s
}

// The summary of skills.
type SkillSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill summary.
	SkillId *string `type:"string"`

	// The name of the skill.
	SkillName *string `min:"1" type:"string"`

	// Linking support for a skill.
	SupportsLinking *bool `type:"boolean"`
}

// String returns the string representation
func (s SkillSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SkillSummary) GoString() string {
	return s.String()
}

// SetSkillId sets the SkillId field's value.
func (s *SkillSummary) SetSkillId(v string) *SkillSummary {
	s.SkillId = &v
	return s
}

// SetSkillName sets the SkillName field's value.
func (s *SkillSummary) SetSkillName(v string) *SkillSummary {
	s.SkillName = &v
	return s
}

// SetSupportsLinking sets the SupportsLinking field's value.
func (s *SkillSummary) SetSupportsLinking(v bool) *SkillSummary {
	s.SupportsLinking = &v
	return s
}

// An object representing a sort criteria.
type Sort struct {
	_ struct{} `type:"structure"`

	// The sort key of a sort object.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The sort value of a sort object.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" enum:"SortValue"`
}

// String returns the string representation
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Sort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sort"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Sort) SetKey(v string) *Sort {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Sort) SetValue(v string) *Sort {
	s.Value = &v
	return s
}

type StartDeviceSyncInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to sync. Required.
	DeviceArn *string `type:"string"`

	// Request structure to start the device sync. Required.
	//
	// Features is a required field
	Features []*string `type:"list" required:"true"`

	// The ARN of the room with which the device to sync is associated. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation
func (s StartDeviceSyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDeviceSyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDeviceSyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDeviceSyncInput"}
	if s.Features == nil {
		invalidParams.Add(request.NewErrParamRequired("Features"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *StartDeviceSyncInput) SetDeviceArn(v string) *StartDeviceSyncInput {
	s.DeviceArn = &v
	return s
}

// SetFeatures sets the Features field's value.
func (s *StartDeviceSyncInput) SetFeatures(v []*string) *StartDeviceSyncInput {
	s.Features = v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *StartDeviceSyncInput) SetRoomArn(v string) *StartDeviceSyncInput {
	s.RoomArn = &v
	return s
}

type StartDeviceSyncOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartDeviceSyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDeviceSyncOutput) GoString() string {
	return s.String()
}

// A key-value pair that can be associated with a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of a tag. Tag keys are case-sensitive.
	Key *string `min:"1" type:"string"`

	// The value of a tag. Tag values are case-sensitive and can be null.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to which to add metadata tags. Required.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The tags to be added to the specified resource. Do not provide system tags.
	// Required.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource from which to remove metadata tags. Required.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The tags to be removed from the specified resource. Do not provide system
	// tags. Required.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room to update.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The updated description of the room.
	Description *string `min:"1" type:"string"`

	// The updated name of the room.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *UpdateAddressBookInput) SetAddressBookArn(v string) *UpdateAddressBookInput {
	s.AddressBookArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAddressBookInput) SetDescription(v string) *UpdateAddressBookInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAddressBookInput) SetName(v string) *UpdateAddressBookInput {
	s.Name = &v
	return s
}

type UpdateAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAddressBookOutput) GoString() string {
	return s.String()
}

type UpdateContactInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact to update.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`

	// The updated display name of the contact.
	DisplayName *string `min:"1" type:"string"`

	// The updated first name of the contact.
	FirstName *string `min:"1" type:"string"`

	// The updated last name of the contact.
	LastName *string `min:"1" type:"string"`

	// The updated phone number of the contact.
	PhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s UpdateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *UpdateContactInput) SetContactArn(v string) *UpdateContactInput {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateContactInput) SetDisplayName(v string) *UpdateContactInput {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UpdateContactInput) SetFirstName(v string) *UpdateContactInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UpdateContactInput) SetLastName(v string) *UpdateContactInput {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *UpdateContactInput) SetPhoneNumber(v string) *UpdateContactInput {
	s.PhoneNumber = &v
	return s
}

type UpdateContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContactOutput) GoString() string {
	return s.String()
}

type UpdateDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to update. Required.
	DeviceArn *string `type:"string"`

	// The updated device name. Required.
	DeviceName *string `min:"2" type:"string"`
}

// String returns the string representation
func (s UpdateDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceInput"}
	if s.DeviceName != nil && len(*s.DeviceName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *UpdateDeviceInput) SetDeviceArn(v string) *UpdateDeviceInput {
	s.DeviceArn = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *UpdateDeviceInput) SetDeviceName(v string) *UpdateDeviceInput {
	s.DeviceName = &v
	return s
}

type UpdateDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceOutput) GoString() string {
	return s.String()
}

type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// The updated address for the room profile.
	Address *string `min:"1" type:"string"`

	// The updated distance unit for the room profile.
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// The updated maximum volume limit for the room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// Whether the PSTN setting of the room profile is enabled.
	PSTNEnabled *bool `type:"boolean"`

	// The ARN of the room profile to update. Required.
	ProfileArn *string `type:"string"`

	// The updated name for the room profile.
	ProfileName *string `min:"1" type:"string"`

	// Whether the setup mode of the profile is enabled.
	SetupModeDisabled *bool `type:"boolean"`

	// The updated temperature unit for the room profile.
	TemperatureUnit *string `type:"string" enum:"TemperatureUnit"`

	// The updated timezone for the room profile.
	Timezone *string `min:"1" type:"string"`

	// The updated wake word for the room profile.
	WakeWord *string `type:"string" enum:"WakeWord"`
}

// String returns the string representation
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.Address != nil && len(*s.Address) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address", 1))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 1))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *UpdateProfileInput) SetAddress(v string) *UpdateProfileInput {
	s.Address = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *UpdateProfileInput) SetDistanceUnit(v string) *UpdateProfileInput {
	s.DistanceUnit = &v
	return s
}

// SetMaxVolumeLimit sets the MaxVolumeLimit field's value.
func (s *UpdateProfileInput) SetMaxVolumeLimit(v int64) *UpdateProfileInput {
	s.MaxVolumeLimit = &v
	return s
}

// SetPSTNEnabled sets the PSTNEnabled field's value.
func (s *UpdateProfileInput) SetPSTNEnabled(v bool) *UpdateProfileInput {
	s.PSTNEnabled = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpdateProfileInput) SetProfileArn(v string) *UpdateProfileInput {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *UpdateProfileInput) SetProfileName(v string) *UpdateProfileInput {
	s.ProfileName = &v
	return s
}

// SetSetupModeDisabled sets the SetupModeDisabled field's value.
func (s *UpdateProfileInput) SetSetupModeDisabled(v bool) *UpdateProfileInput {
	s.SetupModeDisabled = &v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *UpdateProfileInput) SetTemperatureUnit(v string) *UpdateProfileInput {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *UpdateProfileInput) SetTimezone(v string) *UpdateProfileInput {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *UpdateProfileInput) SetWakeWord(v string) *UpdateProfileInput {
	s.WakeWord = &v
	return s
}

type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProfileOutput) GoString() string {
	return s.String()
}

type UpdateRoomInput struct {
	_ struct{} `type:"structure"`

	// The updated description for the room.
	Description *string `min:"1" type:"string"`

	// The updated profile ARN for the room.
	ProfileArn *string `type:"string"`

	// The updated provider calendar ARN for the room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of the room to update.
	RoomArn *string `type:"string"`

	// The updated name for the room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoomInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoomName != nil && len(*s.RoomName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRoomInput) SetDescription(v string) *UpdateRoomInput {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpdateRoomInput) SetProfileArn(v string) *UpdateRoomInput {
	s.ProfileArn = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *UpdateRoomInput) SetProviderCalendarId(v string) *UpdateRoomInput {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *UpdateRoomInput) SetRoomArn(v string) *UpdateRoomInput {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *UpdateRoomInput) SetRoomName(v string) *UpdateRoomInput {
	s.RoomName = &v
	return s
}

type UpdateRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoomOutput) GoString() string {
	return s.String()
}

type UpdateSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The updated description for the skill group.
	Description *string `min:"1" type:"string"`

	// The ARN of the skill group to update.
	SkillGroupArn *string `type:"string"`

	// The updated name for the skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSkillGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSkillGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSkillGroupInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.SkillGroupName != nil && len(*s.SkillGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SkillGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSkillGroupInput) SetDescription(v string) *UpdateSkillGroupInput {
	s.Description = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *UpdateSkillGroupInput) SetSkillGroupArn(v string) *UpdateSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *UpdateSkillGroupInput) SetSkillGroupName(v string) *UpdateSkillGroupInput {
	s.SkillGroupName = &v
	return s
}

type UpdateSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSkillGroupOutput) GoString() string {
	return s.String()
}

// Information related to a user.
type UserData struct {
	_ struct{} `type:"structure"`

	// The email of a user.
	Email *string `min:"1" type:"string"`

	// The enrollment ARN of a user.
	EnrollmentId *string `type:"string"`

	// The enrollment status of a user.
	EnrollmentStatus *string `type:"string" enum:"EnrollmentStatus"`

	// The first name of a user.
	FirstName *string `type:"string"`

	// The last name of a user.
	LastName *string `type:"string"`

	// The ARN of a user.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s UserData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserData) GoString() string {
	return s.String()
}

// SetEmail sets the Email field's value.
func (s *UserData) SetEmail(v string) *UserData {
	s.Email = &v
	return s
}

// SetEnrollmentId sets the EnrollmentId field's value.
func (s *UserData) SetEnrollmentId(v string) *UserData {
	s.EnrollmentId = &v
	return s
}

// SetEnrollmentStatus sets the EnrollmentStatus field's value.
func (s *UserData) SetEnrollmentStatus(v string) *UserData {
	s.EnrollmentStatus = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UserData) SetFirstName(v string) *UserData {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UserData) SetLastName(v string) *UserData {
	s.LastName = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UserData) SetUserArn(v string) *UserData {
	s.UserArn = &v
	return s
}

const (
	// DeviceStatusReady is a DeviceStatus enum value
	DeviceStatusReady = "READY"

	// DeviceStatusPending is a DeviceStatus enum value
	DeviceStatusPending = "PENDING"

	// DeviceStatusWasOffline is a DeviceStatus enum value
	DeviceStatusWasOffline = "WAS_OFFLINE"
)

const (
	// DeviceStatusDetailCodeDeviceSoftwareUpdateNeeded is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeDeviceSoftwareUpdateNeeded = "DEVICE_SOFTWARE_UPDATE_NEEDED"

	// DeviceStatusDetailCodeDeviceWasOffline is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeDeviceWasOffline = "DEVICE_WAS_OFFLINE"
)

const (
	// DistanceUnitMetric is a DistanceUnit enum value
	DistanceUnitMetric = "METRIC"

	// DistanceUnitImperial is a DistanceUnit enum value
	DistanceUnitImperial = "IMPERIAL"
)

const (
	// EnrollmentStatusInitialized is a EnrollmentStatus enum value
	EnrollmentStatusInitialized = "INITIALIZED"

	// EnrollmentStatusPending is a EnrollmentStatus enum value
	EnrollmentStatusPending = "PENDING"

	// EnrollmentStatusRegistered is a EnrollmentStatus enum value
	EnrollmentStatusRegistered = "REGISTERED"

	// EnrollmentStatusDeregistering is a EnrollmentStatus enum value
	EnrollmentStatusDeregistering = "DEREGISTERING"
)

const (
	// FeatureBluetooth is a Feature enum value
	FeatureBluetooth = "BLUETOOTH"

	// FeatureVolume is a Feature enum value
	FeatureVolume = "VOLUME"

	// FeatureNotifications is a Feature enum value
	FeatureNotifications = "NOTIFICATIONS"

	// FeatureLists is a Feature enum value
	FeatureLists = "LISTS"

	// FeatureSkills is a Feature enum value
	FeatureSkills = "SKILLS"

	// FeatureAll is a Feature enum value
	FeatureAll = "ALL"
)

const (
	// SortValueAsc is a SortValue enum value
	SortValueAsc = "ASC"

	// SortValueDesc is a SortValue enum value
	SortValueDesc = "DESC"
)

const (
	// TemperatureUnitFahrenheit is a TemperatureUnit enum value
	TemperatureUnitFahrenheit = "FAHRENHEIT"

	// TemperatureUnitCelsius is a TemperatureUnit enum value
	TemperatureUnitCelsius = "CELSIUS"
)

const (
	// WakeWordAlexa is a WakeWord enum value
	WakeWordAlexa = "ALEXA"

	// WakeWordAmazon is a WakeWord enum value
	WakeWordAmazon = "AMAZON"

	// WakeWordEcho is a WakeWord enum value
	WakeWordEcho = "ECHO"

	// WakeWordComputer is a WakeWord enum value
	WakeWordComputer = "COMPUTER"
)
