/***************************************************************** -*- C -*- **
 *
 * console.c
 * xrootconsole
 * Copyright (C) 1998  Eric Youngblut
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this software can be reached by e-mail at
 * yngblut@cs.washington.edu.  The latest version of this software can be
 * found at http://www.cs.washington.edu/homes/yngblut/
 */


#include <fcntl.h>
#include <pty.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>


int open_console()
{
    int pty, tty, on = 1;
    
    /* Allocate a pseudo-terminal. */
    if (openpty(&pty, &tty, NULL, NULL, NULL) == -1)
    {
	perror("openpty");
	exit(EXIT_FAILURE);
    }

    /* Drop privileges. */
    if (seteuid(getuid()) == -1)
    {
	perror("seteuid");
	exit(EXIT_FAILURE);
    }

    /* Linux specific? */
    if (ioctl(tty, TIOCCONS, &on) == -1)
    {
	perror("ioctl");
	exit(EXIT_FAILURE);
    }

    /* Make it non-blocking. */
    if (fcntl(pty, F_SETFL, O_NONBLOCK) == -1)
    {
	perror("fcntl");
	exit(EXIT_FAILURE);
    }
    
    return pty;
}
