##############################################################################
#
# Copyright (c) 1996-1998, Digital Creations, Fredericksburg, VA, USA.
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
#   o Redistributions of source code must retain the above copyright
#     notice, this list of conditions, and the disclaimer that follows.
# 
#   o Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions, and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# 
#   o Neither the name of Digital Creations nor the names of its
#     contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
# 
# 
# THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS AND CONTRIBUTORS *AS IS*
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL
# CREATIONS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
# 
# If you have questions regarding this software, contact:
#
#   Digital Creations, L.C.
#   910 Princess Ann Street
#   Fredericksburge, Virginia  22401
#
#   info@digicool.com
#
#   (540) 371-6909
#
##############################################################################
__doc__='''Python PickleJar base

$Id: pPickleJar.py,v 1.4 1998/10/23 21:45:20 jim Exp $'''
__version__='$Revision: 1.4 $'[11:-2]

from cStringIO import StringIO
from cPickle import Pickler

class PickleJar:

    def new_oid(self):
        oid=self.oid+1
        self.oid=oid
        return oid

    def store(self,object,T=None):
        plan=self.planToStore
        stack=[]
        topoid=plan(object,stack)
        if stack:
            file=StringIO()
            if T is None: m=''
            else: m=T.info()    

            # Create a special persistent_id that passes T and the subobject
            # stack along:
            def persistent_id(object,self=self,stack=stack):
                if (not hasattr(object, '_p_oid') or
                    not hasattr(object, '__class__')
                    ): return None

                oid=object._p_oid

                if oid is None or object._p_jar is not self:
                    oid = self.new_oid()
                    object._p_jar=self      
                    object._p_oid=oid
                    stack.append(object)
                elif object._p_changed:
                    stack.append(object)

                if hasattr(object.__class__, '__getinitargs__'): return oid
                return oid, object.__class__

            pickler=Pickler(file,1)
            pickler.persistent_id=persistent_id
            dbstore=self.db.store
            seek=file.seek
            file=file.getvalue
            cache=self.cache
            dump=pickler.dump
            clear_memo=pickler.clear_memo
            
            while stack:
                object=stack[-1]
                del stack[-1]
                oid=object._p_oid
                cls = object.__class__
                if hasattr(cls, '__getinitargs__'):
                    args = object.__getinitargs__()
                    len(args) # XXX Assert it's a sequence
                else:
                    args = None # New no-constructor protocol!
                seek(0)
                clear_memo()
                dump((cls,args))
                state=object.__getstate__()
                dump(state)
                p=file(1)
                dbstore(oid,p,m)
                object.__changed__(0)
                cache[oid]=object

        return topoid

    def planToStore(self,object,stack):
        oid=object._p_oid
        if oid is None or object._p_jar is not self:
            oid = self.new_oid()
            object._p_jar=self      
            object._p_oid=oid
            stack.append(object)
        elif object._p_changed:
            stack.append(object)
        return oid
