/*
 Matrox PINS decoding routines.
 
 (C) 2000 Dave Jones.

*/

#include <time.h>

/*******************************************
 Decode PINS area
 *******************************************/
void decode_pins(char **TextPtr, int pinsoffset, char *memptr)
{
	unsigned char *offset;
	unsigned short lastprog, pcbrev;

	offset = memptr+pinsoffset;
	
	if ((*offset++ != 0x2e) && (*offset++ != 0x41)) {
		*TextPtr+=sprintf (*TextPtr, "\n\nFATAL!: PINS header not found!\n");
		return;
	}
	
	offset += 4;
	*TextPtr+=sprintf(*TextPtr, "PINS version\t: %d.", *offset);
	offset--;
	*TextPtr+=sprintf(*TextPtr, "%d\n", *offset);

	/******
	Last programmed date
	*******/
	*TextPtr+=sprintf(*TextPtr, "Last programmed\t: ");
	offset+=3;
	lastprog = *offset << 8;
	offset--;
	lastprog |= *offset;

	*TextPtr+=sprintf(*TextPtr, "%d/", lastprog & 31);		/* Day number */
	*TextPtr+=sprintf(*TextPtr, "%d/", (lastprog >>5) & 15);	/* Month number */

	/* Handle year number with century.
	   Anyone think their G200 still gonna work >2070 ? :) */
	if (lastprog>>9 > 70)
		*TextPtr+=sprintf(*TextPtr, "19");
	else
		*TextPtr+=sprintf(*TextPtr, "20");	
	*TextPtr+=sprintf(*TextPtr, "%d\n", lastprog>>9);

/*****
Number of times programmed.
*****/

	offset+=2;
	*TextPtr+=sprintf (*TextPtr, "Times programmed: %d\n", *offset);

/*****
Serial Number
*****/

	offset+=4;
	*TextPtr+=sprintf (*TextPtr, "Serial number\t: %s\n", offset);

/*****
Card version
*****/

	offset+=16;
	*TextPtr+=sprintf (*TextPtr, "Card version\t: %s\n", offset);

/*****
PCB Revision
*****/

	offset+=7;
	pcbrev = *offset<<8;
	offset--;
	pcbrev |= *offset;

	*TextPtr+=sprintf(*TextPtr, "PCB Revision\t: %d.%d\n", pcbrev >> 4, pcbrev & 0xF);

/*****
Max RAMDAC freq
*****/

	offset += 2;
	*TextPtr+=sprintf (*TextPtr, "Max RAMDAC freq\t: %dMHz\n", *offset++ +100);

/*****
Max pixel clocks
*****/

	*TextPtr+=sprintf (*TextPtr, "Max pixel clocks:\n");
	*TextPtr+=sprintf (*TextPtr, "\t8bpp = %dMhz\n", *offset++ +100);
	*TextPtr+=sprintf (*TextPtr, "\t16bpp = %dMhz\n", *offset++ +100);
	*TextPtr+=sprintf (*TextPtr, "\t24bpp = %dMhz\n", *offset++ +100);
	*TextPtr+=sprintf (*TextPtr, "\t32bpp = %dMhz\n", *offset++ +100);
}
