#include <string.h>
#include <stdlib.h>
#include <qfiledialog.h>
#include "filebox.h"

static char *filename = NULL;

/***********************************************************************/

char *fileBox(const char *title, const char *filter) 
{
  static char *scratchname = NULL;
  enum {SAVE, OPEN, IMPORT} what;

  if (0 == strcmp(title, "Open")) {
    what = OPEN;
  }
  else if (0 == strcmp(title, "Import QIF")) {
    what = IMPORT;
  }
  else if (0 == strcmp(title, "Save")) {
    what = SAVE;
  }
  else if (0 == strcmp(title, "SaveAs")) {
    what = SAVE;
  }
  else { 
    printf("%s(%s, %s) called\n", __FUNCTION__, title, filter);
    return(NULL); 
  }

  QString s;

  switch (what) {
  case SAVE:
    s = QFileDialog::getSaveFileName(filename, filter);
    break;
  case OPEN:
    s = QFileDialog::getOpenFileName(0, filter);
    break;
  case IMPORT:
    s = QFileDialog::getOpenFileName(0, filter);
    break;
  }

  if (s.isNull())
    return(NULL);

  if (what == IMPORT) {
    if (scratchname)
      free(scratchname);
    scratchname = strdup(s);
    return(scratchname);
  }

  if (filename)
    free(filename);
  filename = strdup(s);  
  return(filename);
}

/******************************* E N D *********************************/
