/**********************************************************************
$Id: g-wrap-fns.c,v 1.1 1999/05/29 23:46:11 linas Exp $
Copyright (C) 1996, 1997, 1998 Christopher Lee
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <libguile.h>
#include <libguile/__scm.h>
#include "../g-wrap.h"
#ifdef HAVE_CONFIG_H
# include "../conf.h"
#endif

void FatalError(char *msg)
{
  gw_error(msg);
}

void gw_error (char *message) {
  SCM errsym;
  SCM str;

  /*SCM_ALLOW_INTS;*/
  errsym = SCM_CAR (scm_intern ("error", 5));
  str = scm_makfrom0str (message);
  scm_throw (errsym, scm_cons (str, SCM_EOL));
}

void gw_puts(char* str, GWSCM port) {
#if HAVE_SCM_PUTS
  scm_puts(str,port);
#else
  scm_gen_puts(scm_mb_string,str,port);
#endif
}

void gw_mark(GWSCM obj) {
 if ( SCM_NIMP(obj) ) {
   scm_gc_mark (obj);
 }
}

static int gw_initialized = 0;
static SCM *scm_gw_descriptions;

static SCM gw_get_descriptions (void);

void gw_initialize(void) {
  if ( !gw_initialized ) {
    scm_gw_descriptions = SCM_CDRLOC (scm_sysintern ("*gw:descriptions*", 
						     SCM_EOL));
    gw_initialized = 1;
  }
}
  

void gw_add_description(GWSCM lst) {
  *scm_gw_descriptions = scm_cons(lst,*scm_gw_descriptions);
}


/* POINTER_TOKENs */

void
POINTER_TOKEN_print(POINTER_TOKEN pt, GWSCM port, int writingp)
{
  char buff[256];
  sprintf(buff,"#<pt-%s:0x%lX>",pt->typename,(unsigned long)pt->pdata);
  gw_puts(buff,port);
}

int
POINTER_TOKEN_eq(POINTER_TOKEN pt1, POINTER_TOKEN pt2)
{
  return ( pt1 == pt2 || (!strcmp(pt1->typename,pt2->typename)
			  && pt1->pdata == pt2->pdata) );
}

POINTER_TOKEN
make_POINTER_TOKEN(char *type, void* addr)
{
  POINTER_TOKEN newpt = (POINTER_TOKEN)malloc(sizeof(POINTER_TOKEN_st));
  newpt->typename = strdup(type);
  newpt->pdata = addr;
  return newpt;
}

void
POINTER_TOKEN_free(POINTER_TOKEN pt) {
  free(pt->typename);
  free(pt);
}

int
POINTER_TOKEN_null_p(POINTER_TOKEN pt) {
  return(pt->pdata == NULL);
}


/* POINTER_ARRAYs */

void
POINTER_ARRAY_print(POINTER_ARRAY pa, GWSCM port, int writingp) {
  char buff[256];
  sprintf(buff,"#<pa-%s[%lu]:0x%lX>", pa->itemtype, pa->length,
          (unsigned long) pa->pdata);
  gw_puts(buff,port);
}

int
POINTER_ARRAY_eq(POINTER_ARRAY pa1, POINTER_ARRAY pa2) {
  return(pa1 == pa2 || (!strcmp(pa1->typename,pa2->typename)
                        && pa1->pdata == pa2->pdata) );
}

POINTER_ARRAY
make_POINTER_ARRAY(char *type, char *itemtype, void** addr) {
  POINTER_ARRAY newpt = (POINTER_ARRAY) malloc(sizeof(POINTER_ARRAY_st));
  newpt->typename = strdup(type);
  newpt->itemtype = strdup(itemtype);
  newpt->pdata = addr;

  {
    unsigned long length = 0;
    void **cursor = addr;
    while(*addr++) length++;
    newpt->length = length;
  }

  return newpt;
}

void
POINTER_ARRAY_free(POINTER_ARRAY pa) {
  free(pa->typename);
  free(pa->itemtype);
  free(pa);
}

POINTER_TOKEN
POINTER_ARRAY_ref(POINTER_ARRAY pa, int index) {
  /* FIXME: need range checking here... */
  return(make_POINTER_TOKEN(pa->itemtype, (pa->pdata)[index]));
}

unsigned long
POINTER_ARRAY_length(POINTER_ARRAY pa) {
  return(pa->length);
}

static int initialized_p = 0;
static SCM longlongoffset;
static SCM mult;
static SCM add;
static SCM quotient;
static SCM remainder;

static void
initialize_longlongs() {
  mult = gh_eval_str("*");
  add = gh_eval_str("+");
  quotient = gh_eval_str("quotient");
  remainder = gh_eval_str("remainder");
  longlongoffset = gh_eval_str("#x100000000");
  initialized_p = 42;
}

GWSCM
gh_ulonglong2scm(unsigned long long x) {
  const unsigned long upper = x >> 32;
  const unsigned long lower = (unsigned long) (x & 0xFFFFFFFF);
  SCM result;
  
  if(!initialized_p) initialize_longlongs();
  
  result = gh_call2(mult, gh_ulong2scm(upper), longlongoffset);
  result = gh_call2(add, result, gh_ulong2scm(lower));

  return(result);
}

unsigned long long
gh_scm2ulonglong(GWSCM x) {
  unsigned long long result;
  unsigned long upper;
  unsigned long lower;
  SCM upper_scm;
  SCM lower_scm;
  
  if(!initialized_p) initialize_longlongs();

  upper_scm = gh_call2(quotient, x, longlongoffset);
  lower_scm = gh_call2(remainder, x, longlongoffset);

  upper = gh_scm2ulong(upper_scm);
  lower = gh_scm2ulong(lower_scm);

  result = (((unsigned long long) upper) << 32) | lower;

  return(result);
}

GWSCM
gh_longlong2scm(long long x) {
  const long upper = x >> 32;
  const long lower = (unsigned long) (x & 0xFFFFFFFF);
  SCM result;
  
  if(!initialized_p) initialize_longlongs();
  
  result = gh_call2(mult, gh_long2scm(upper), longlongoffset);
  result = gh_call2(add, result, gh_long2scm(lower));

  return(result);
}

long long
gh_scm2longlong(GWSCM x) {
  long long result;
  long upper;
  long lower;
  SCM upper_scm;
  SCM lower_scm;
  
  if(!initialized_p) initialize_longlongs();

  upper_scm = gh_call2(quotient, x, longlongoffset);
  lower_scm = gh_call2(remainder, x, longlongoffset);

  upper = gh_scm2long(upper_scm);
  lower = gh_scm2long(lower_scm);

  result = (((long long) upper) << 32) | lower;

  return(result);
}
