/*
 * exitcodes.h  -  Exit codes for all netboot programs
 *
 * Copyright (C) 1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * Definition of exit codes
 *   0x00 - 0x1f  general exit codes for all programs
 *   0x20 - 0x3f  exit codes for makerom
 *   0x40 - 0x5f  exit codes for mknbi-linux
 *   0x60 - 0x7f  exit codes for mknbi-dos
 *   0x80 - 0x9f  exit codes for mknbi-mgl
 */
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS		0x00		/* no error */
#endif
#define EXIT_USAGE		0x01		/* usage */
#define EXIT_MEMORY		0x02		/* not enough memory */
#define EXIT_OPEN		0x03		/* cannot open file */
#define EXIT_CREATE		0x04		/* cannot create file */
#define EXIT_READ		0x05		/* read error */
#define EXIT_WRITE		0x06		/* write error */
#define EXIT_ACCESS		0x07		/* error accessing file */
#define EXIT_TEMPNAME		0x08		/* error generating temp name */
#define EXIT_SEEK		0x09		/* seek error */
#define EXIT_OPENDIR		0x0A		/* error opening directory */
#define EXIT_INTERNAL		0x0B		/* internal error */
#define EXIT_HOSTNAME		0x0C		/* invalid hostname */
#define EXIT_HOSTADDR		0x0D		/* invalid host address */
#define EXIT_INET		0x0E		/* no INET support */
#define EXIT_STAT		0x0F		/* cannot stat file or dir */
#define EXIT_CONFIG		0x10		/* error in config file */
#define EXIT_DB			0x11		/* error in database file */
#define EXIT_NODB		0x12		/* no database specified */
#define EXIT_NOSYS		0x13		/* system not in database */

#define EXIT_MAKEROM_OPENKERN	0x20		/* unable to open kernel */
#define EXIT_MAKEROM_READKERN	0x21		/* unable to read kernel */
#define EXIT_MAKEROM_INVKERN	0x22		/* invalid kernel version */
#define EXIT_MAKEROM_OPENDRV	0x23		/* unable to open driver */
#define EXIT_MAKEROM_EXEEOF	0x24		/* unexpected end of EXE file */
#define EXIT_MAKEROM_SIZE64	0x25		/* output file >64kB */
#define EXIT_MAKEROM_OPENLDR	0x26		/* unable to open loader */
#define EXIT_MAKEROM_NETFND	0x27		/* no network drivers found */
#define EXIT_MAKEROM_KERNFND	0x28		/* no kernel files found */
#define EXIT_MAKEROM_ROMEOF	0x29		/* unexpected end of rom */
#define EXIT_MAKEROM_MISORDER	0x2A		/* image chunks misordered */
#define EXIT_MAKEROM_PROGLSIZE	0x2B		/* FlashCard prog too large */
#define EXIT_MAKEROM_INVEXE	0x2C		/* Invalid EXE file header */
#define EXIT_MAKEROM_INVDRV	0x2D		/* invalid network driver */
#define EXIT_MAKEROM_INVLDR	0x2E		/* invalid loader */

#define EXIT_LINUX_MISORDER	0x40		/* image chunks misordered */
#define EXIT_LINUX_KERNEOF	0x41		/* unexpected end of kernel */
#define EXIT_LINUX_INVKERN	0x42		/* invalid kernel image */
#define EXIT_LINUX_INVSETUP	0x43		/* invalid kernel setup */
#define EXIT_LINUX_KERNSIZE	0x44		/* kernel too large */
#define EXIT_LINUX_CMDLSIZE	0x45		/* command line size */
#define EXIT_LINUX_NORD		0x46		/* no ramdisk specified */
#define EXIT_LINUX_KERNOPEN	0x47		/* unable to open kernel file */
#define EXIT_LINUX_IMGCREATE	0x48		/* unable to create image */
#define EXIT_LINUX_RDOPEN	0x49		/* unable to open ramdisk */
#define EXIT_LINUX_BOOTLSIZE	0x4A		/* invalid boot loader size */
#define EXIT_LINUX_INVETH	0x4B		/* invalid ethernet device */
#define EXIT_LINUX_RDLOC	0x4C		/* invalid ramdisk location */

#define EXIT_DOS_MISORDER	0x60		/* image chunks misordered */
#define EXIT_DOS_RDREAD		0x61		/* error reading ramdisk */
#define EXIT_DOS_RDEOF		0x62		/* unexpected end of ramdisk */
#define EXIT_DOS_FATCMP		0x63		/* FAT copies do not match */
#define EXIT_DOS_NOBOOT		0x64		/* ramdisk not bootable */
#define EXIT_DOS_NODOS		0x65		/* ramdisk not DOS image */
#define EXIT_DOS_INVFS		0x66		/* invalid DOS filesystem */
#define EXIT_DOS_SECTSIZE	0x67		/* invalid sector size */
#define EXIT_DOS_HIDDEN		0x68		/* ramdisk has hidden sectors */
#define EXIT_DOS_FATNUM		0x69		/* invalid FAT number */
#define EXIT_DOS_RESVDSECT	0x6A		/* invalid reserved sectors */
#define EXIT_DOS_DOUBLESIDE	0x6B		/* ramdisk not double sided */
#define EXIT_DOS_RDSIZE		0x6C		/* invalid ramdisk size */
#define EXIT_DOS_IMGCREATE	0x6D		/* unable to create image */
#define EXIT_DOS_BOOTLSIZE	0x6E		/* invalid boot loader size */
#define EXIT_DOS_DOUBLEFILE	0x6F		/* two files with same name */
#define EXIT_DOS_MSDOSSYS	0x70		/* msdos.sys is missing */
#define EXIT_DOS_IOSYS		0x71		/* io.sys is missing */
#define EXIT_DOS_RDSPACE	0x72		/* not enough ramdisk space */
#define EXIT_DOS_RDSTAT		0x73		/* unable to stat ramdisk */
#define EXIT_DOS_RDOPEN		0x74		/* unable to open ramdisk */
#define EXIT_DOS_INVRD		0x75		/* ramdisk no file or dir */
#define EXIT_DOS_BOOTSECT	0x76		/* invalid DOS boot sector */

#define EXIT_MGL_MISORDER	0x80		/* image chunks misordered */
#define EXIT_MGL_CODESIZE	0x81		/* code size too large */
#define EXIT_MGL_CONSTSIZE	0x82		/* const data size too large */
#define EXIT_MGL_RELOCOVRFLOW	0x83		/* overflow of reloc buffer */
#define EXIT_MGL_DEBUGOVRFLOW	0x84		/* overflow of debug buffer */
#define EXIT_MGL_COMPERRS	0x85		/* compile errors */
#define EXIT_MGL_NOSTART	0x86		/* no start screen defined */
#define EXIT_MGL_PROGOPEN	0x87		/* unable to open prog file */
#define EXIT_MGL_IMGCREATE	0x88		/* error creating output file */

