/*
 * common.h  -  Common definitions for all mknbi programs
 *
 * Copyright (C) 1996-1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * General definitions for compiling on different systems
 */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef __STDC__
# define voidstar void *
#else
# define voidstar char *
#endif

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#ifdef STDC_HEADERS
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# else
extern voidstar malloc();
extern void free();
# endif
#endif

#ifndef O_BINARY
# define O_BINARY 0
#endif

#ifndef __P
# if defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#  define __P(args) args
# else
#  define __P(args) ()
# endif
#endif

#include <errno.h>
#ifndef errno
extern int errno;
#endif

#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif
#ifndef MAXPATHLEN
# ifdef PATH_MAX
#  define MAXPATHLEN PATH_MAX
# else
#  define MAXPATHLEN 1024
# endif
#endif

#if defined(M_XENIX) && defined(I_286)
#undef __XENIX__
#define __XENIX__
#endif


/*
 * Check for packed attribute. This is necessary to match some C
 * structures to what the bootrom and the assembler modules expect.
 * Without the packed attribute at least the GNU C compiler aligns
 * byte variables to word boundaries which is not always correct.
 * Other compilers might be able to use the pack or align pragmas.
 */
#ifdef USE_PACKED
# define PACKED __attribute__((packed))
# undef USE_PRAGMA_PACK
# undef USE_PRAGMA_ALIGN
#endif

#ifdef USE_PRAGMA_PACK
# define PACKED
# undef USE_PACKED
# undef USE_PRAGMA_ALIGN
#endif

#ifdef USE_PRAGMA_ALIGN
# define PACKED
# undef USE_PACKED
# undef USE_PRAGMA_PACK
#endif


/*
 * sys/types.h and unistd.h are required to include variable types
 * which define certain bit sized units.
 */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <sys/types.h>
#ifdef HAVE_SYS_BITYPES_H
# include <sys/bitypes.h>
#endif


/*
 * Check if we have proper networking support
 */
#if !defined(HAVE_NETDB_H) || !defined(HAVE_NETINET_IN_H) || !defined(HAVE_ARPA_INET_H)
#undef HAVE_INET
#else
#define HAVE_INET
#endif


/*
 * Different variants of UNIX use different ways accessing directories. Make
 * everything so that it looks like in dirent.h.
 */
#if defined(DIRENT) || defined(_POSIX_VERSION)
# include <dirent.h>
# define NLENGTH(dirent) (strlen((dirent)->d_name))
#else
# define dirent direct
# define NLENGTH(dirent) ((dirent)->d_namlen)
# ifdef SYSNDIR
#  include <sys/ndir.h>
# endif
# ifdef SYSDIR
#  include <sys/dir.h>
# endif
# ifdef NDIR
#  include <dir.h>
# endif
#endif


/*
 * Check for include files which define struct tm.
 */
#ifdef TIME_WITH_SYS_TIME
# ifdef TM_IN_SYS_TIME
#  include <sys/time.h>
# endif
# include <time.h>
#else
# if defined(HAS_SYS_TIME_H) && defined(TM_IN_SYS_TIME)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif


/*
 * Do the usual checks for memory and string handling functions.
 */
#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
# include <string.h>
# if !defined(STDC_HEADERS) && defined(HAVE_MEMORY_H)
#  include <memory.h>
# endif
#else
# include <strings.h>
# ifndef memcpy
#  define memcpy(D, S, N) bcopy((S), (D), (N))
# endif
# ifndef strchr
#  define strchr(S, C) index ((S), (C))
# endif
# ifndef strrchr
#  define strrchr(S, C) rindex ((S), (C))
# endif
# ifndef bcopy
void bcopy();
# endif
#endif


/*
 * Next check for type definitions for 8, 16 and 32 bit variables.
 * The assembler modules expect most values in a specific size, and
 * we must ensure that the C programs produce the correct size.
 */
#ifdef USE_U_INT
# define __u8 u_int8_t
# define __u16 u_int16_t
# define __u32 u_int32_t
#else
# ifndef USE__UXX
#  ifndef U8_TYPE
#   if SIZEOF_UNSIGNED_CHAR == 1
#    define U8_TYPE unsigned char
#   else
#    error Unable to set 8-bit-type
#   endif
#  endif
#  ifndef U16_TYPE
#   if SIZEOF_UNSIGNED_INT == 2
#    define U16_TYPE unsigned int
#   else
#    if SIZEOF_UNSIGNED_SHORT == 2
#     define U16_TYPE unsigned short
#    else
#     error Unable to set 16-bit-type
#    endif
#   endif
#  endif
#  ifndef U32_TYPE
#   if SIZEOF_UNSIGNED_LONG == 4
#    define U32_TYPE unsigned long
#   else
#    if SIZEOF_UNSIGNED_INT == 4
#     define U32_TYPE unsigned int
#    else
#     error Unable to set 32-bit-type
#    endif
#   endif
#  endif
typedef U8_TYPE  __u8;
typedef U16_TYPE __u16;
typedef U32_TYPE __u32;
# endif
#endif


/*
 * Define some macros to allow a non-intel host system to produce
 * correct byte ordering code for the intel target system.
 */
#ifndef NO_BINARY  /* No need to include this for utility programs */
# define swapbytes(a)	((((__u16)(a) & 0x00ff) << 8) | (((__u16)(a) & 0xff00) >> 8))
# define low_word(a)	((a) & 0x0000ffff)
# define high_word(a)	(((a) >> 16) & 0x0000ffff)
# define get_long(a)	((unsigned long)((ttoh(getval((a).high)) << 16) | \
						ttoh(getval((a).low))))
# ifndef WORDS_BIGENDIAN
#  define htot(a)		((__u16)(a))
#  define ttoh(a)		((unsigned short)(a))
# else
#  define htot(a)		((__u16)swapbytes(a))
#  define ttoh(a)		((unsigned short)swapbytes(a))
# endif
#endif /* NO_BINARY */


/*
 * On some systems like SPARCs it is not possible to have integer variables
 * on misaligned addresses, so we have to use memcpy in that case.
 */
#ifndef NO_BINARY  /* No need to include this for utility programs */
# ifdef USE_COPY

#  define assign(a, b)	mycopy(&(a), (b))
	/*
	 * Copy a value out of a host system variable into a target system
	 * structure
	 */
	static inline void mycopy(a, b)
	  __u16 *a;
	  __u16 b;
	{
	  memcpy(a, &b, sizeof(__u16));
	}

#  define getval(a)	mygetval(&(a))
	/*
	 * Return a value out of a target system structure
	 */
	static inline __u16 mygetval(a)
	  __u16 *a;
	{
	  __u16 b;
	  memcpy(&b, a, sizeof(__u16));
	  return(b);
	}

# else /* USE_COPY */

#  define assign(a, b)	a = b
#  define getval(a)	(a)

# endif /* USE_COPY */
#endif /* NO_BINARY */


/*
 * Define the layout of Intel addresses and long words in memory.
 */
#ifdef USE_PRAGMA
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif
struct i_addr {
  __u16 offset	PACKED;
  __u16 segment	PACKED;
};


struct i_long {
  __u16 low	PACKED;
  __u16 high	PACKED;
};
#ifdef USE_PRAGMA
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif


/*
 * General definitions
 */
#ifndef TRUE
# define TRUE 1
#endif
#ifndef FALSE
# define FALSE 0
#endif


/*
 * Include exit codes
 */
#include "exitcodes.h"



/*
 * Include version information
 */
#include "version.h"

