/* Dump memory allocation routines
   
   Copyright (C) 1996 Maurizio Plaza
   		 1996 Jakub Jelinek
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef LARGETILO
#define MALLOC_BASE 0x3D0000	/* this must be an unused memory area !!! */
#else
#define MALLOC_BASE 0x4D0000
#endif

static char *malloc_ptr = (char *) MALLOC_BASE;
static char *last_alloc = 0;

void *malloc (int size)
{
    char *caddr;

    caddr = malloc_ptr;
    malloc_ptr += size;
    last_alloc = caddr;
    malloc_ptr = (char *) ((((unsigned int) malloc_ptr) + 3) & (~3));
    return caddr;
}

void free (void *m)
{
    if (m == last_alloc)
	malloc_ptr = last_alloc;
}

void mark (void **ptr)
{
    *ptr = (void *) malloc_ptr;
}

void release (void *ptr)
{
    malloc_ptr = (char *) ptr;
}
