/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module implements a static trie structure */

/* types ====================================================================*/

typedef struct
{
  string_t key; /* The key of a trie entry is considered case insensitive. */
  int_t content;
} trie_entry_t; /* a "trie_entry_t" associates <key> with <content> */

/* functions ================================================================*/

/* A trie is a vector of ints. When constructed, it is returned as a pool
 * together with the index of the root node. */

extern void new_trie (int_t n, 
		      trie_entry_t *trie_entries, 
		      pool_t *trie_pool,
		      int_t *root_node);
/* Take <n> <trie_entries> and build a trie of them.
 * Return the trie in *<trie_pool> and *<root_node>.
 * The keys in *<trie_entries> must be unique and sorted alphabetically. */

extern bool_t lookup_trie (int_t *trie,
			   int_t *node, 
			   string_t *input, 
			   int_t *content);
/* Test if a prefix of *<input> matches the subtrie with root index <node>.
 * If it does, return TRUE (else return FALSE) and:
 *   *<node>  is the node for the matched input,
 *   *<input> is the pointer to first char not matched yet, and
 *   *<content> is the trie content for the matched input. */

/* end of file ==============================================================*/
