/*
 * Copyright 1996 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: util.c,v 1.4 1996/09/14 09:42:34 bousch Exp $
 *
 * Miscillaneous utility routines.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "saml-util.h"

void saml_panic (const char *msg)
{
	write(2, "SAML panic: ", 12);
	write(2, msg, strlen(msg));
	write(2, "\n", 1);
	abort();
}

void panic_out_of_memory (void)
{
	saml_panic("out of memory");
}

/*
 * Miscillaneous operations on growable strings
 */

#define INITIAL_GRS_LENGTH 100

gr_string* new_gr_string (size_t ilen)
{
	gr_string *new;

	if (ilen == 0)
		ilen = INITIAL_GRS_LENGTH;
	new = malloc(sizeof(gr_string) + ilen);
	if (new == NULL)
		panic_out_of_memory();
	new->buflen = ilen;
	new->len = 0;
	return new;
}

gr_string* grs_append (gr_string* dest, const char* src, size_t slen)
{
	int newsize;

	if ((newsize = dest->len + slen) > dest->buflen) {
		/* The size of the buffer will be at least doubled */
		newsize += dest->buflen;
		dest = realloc(dest, sizeof(gr_string) + newsize);
		if (dest == NULL)
			panic_out_of_memory();
		dest->buflen = newsize;
	}
	memcpy(dest->s + dest->len, src, slen);
	dest->len += slen;
	return dest;
}

gr_string* grs_prepend (gr_string* dest, const char* src, size_t slen)
{
	int newsize;

	if ((newsize = dest->len + slen) > dest->buflen) {
		/* The size of the buffer will be at least doubled */
		newsize += dest->buflen;
		dest = realloc(dest, sizeof(gr_string) + newsize);
		if (dest == NULL)
			panic_out_of_memory();
		dest->buflen = newsize;
	}
	memmove(dest->s + slen, dest->s, dest->len);
	memcpy(dest->s, src, slen);
	dest->len += slen;
	return dest;
}

gr_string* grs_prepend1 (gr_string* dest, char c)
{
	return grs_prepend(dest, &c, 1);
}

gr_string* grs_append1 (gr_string* dest, char c)
{
	return grs_append(dest, &c, 1);
}

char* u32toa (__u32 x)
{
	static char s[32];
	char *p;

	p = &s[31]; *p = '\0';
	do {
		*--p = (x % 10) + '0';
		x /= 10;
	}
	while (x != 0);
	return p;
}

char* u64toa (__u64 x)
{
	static char s[32];
	char *p;

	p = &s[31]; *p = '\0';
	do {
		*--p = (x % 10) + '0';
		x /= 10;
	}
	while (x != 0);
	return p;
}
