/*
 * Copyright 1996 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: saml-mtypes.h,v 1.1 1996/08/18 07:32:52 bousch Exp $
 *
 * Simple math types commonly used
 */

#ifndef _SAML_MATH_TYPES_H
#define _SAML_MATH_TYPES_H

#define ST_VOID		0	/* Void */
#define ST_LITERAL	1	/* A literal (string) */
#define ST_MINT		3	/* Machine integer (int) */
#define ST_INTEGER	4	/* Arbitrary big integer */
#define ST_CYCLIC	5	/* Elements of Z/nZ */
#define ST_FLOAT	6	/* Multi-precision reals */
#define ST_RATIONAL	7	/* Rational (on a ring) */
#define ST_COMPLEX	8	/* Complex number */
#define ST_ALGEXT	9	/* Algebraic extensions */
#define ST_MONO		12	/* Sparse monomial */
#define ST_POLY		13	/* Sparse polynomial */
#define ST_APOLY	10	/* Another implementation of polynomials */
#define ST_UPOLY	14	/* Dense univariate polynomial */
#define ST_LINE		15	/* Matrix line */
#define ST_MATRIX	16	/* Rectangular matrix */
#define ST_TENSOR	17	/* Dense tensor (on a ring) */

#endif	/* _SAML_MATH_TYPES_H */
